/*
 * Decompiled with CFR 0.152.
 */
package de.jplag;

import java.io.File;
import java.util.Collection;
import java.util.stream.Collectors;

public class ParsingException
extends Exception {
    private static final long serialVersionUID = 4385949762027596330L;

    public ParsingException(File file) {
        this(file, (String)null);
    }

    public ParsingException(File file, String reason) {
        super(ParsingException.constructMessage(file, reason));
    }

    public ParsingException(File file, Throwable cause) {
        this(file, null, cause);
    }

    public ParsingException(File file, String reason, Throwable cause) {
        super(ParsingException.constructMessage(file, reason), cause);
    }

    public static ParsingException wrappingExceptions(Collection<ParsingException> exceptions) {
        return switch (exceptions.size()) {
            case 0 -> null;
            case 1 -> exceptions.iterator().next();
            default -> {
                String message = exceptions.stream().map(Throwable::getMessage).collect(Collectors.joining("\n"));
                yield new ParsingException(message);
            }
        };
    }

    private ParsingException(String message) {
        super(message);
    }

    private static String constructMessage(File file, String reason) {
        String fileName;
        StringBuilder messageBuilder = new StringBuilder();
        String string = fileName = file == null ? "<null>" : file.toString();
        if (reason == null || !reason.contains(fileName)) {
            messageBuilder.append("failed to parse '%s'".formatted(fileName));
        }
        if (reason != null && !reason.isBlank()) {
            messageBuilder.append(reason);
        }
        return messageBuilder.toString();
    }
}

