/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.semantics;

import de.jplag.semantics.CodeSemantics;
import de.jplag.semantics.Variable;
import de.jplag.semantics.VariableAccessType;
import de.jplag.semantics.VariableScope;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.Map;
import java.util.Set;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VariableRegistry {
    private static final Logger logger = LoggerFactory.getLogger(VariableRegistry.class);
    private CodeSemantics semantics;
    private final Map<String, Variable> fileVariables = new HashMap<String, Variable>();
    private final Deque<Map<String, Variable>> classVariables = new LinkedList<Map<String, Variable>>();
    private final Map<String, Deque<Variable>> localVariables = new HashMap<String, Deque<Variable>>();
    private final Deque<Set<String>> localVariablesByScope = new LinkedList<Set<String>>();
    private VariableAccessType nextVariableAccessType = VariableAccessType.READ;
    private boolean ignoreNextVariableAccess = false;
    private boolean mutableWrite = false;

    public boolean inLocalScope() {
        return !this.localVariablesByScope.isEmpty();
    }

    public void setNextVariableAccessType(VariableAccessType nextVariableAccessType) {
        this.nextVariableAccessType = nextVariableAccessType;
    }

    public void setIgnoreNextVariableAccess(boolean ignoreNextVariableAccess) {
        this.ignoreNextVariableAccess = ignoreNextVariableAccess;
    }

    public void setMutableWrite(boolean mutableWrite) {
        this.mutableWrite = mutableWrite;
    }

    public void enterClass() {
        this.classVariables.push(new HashMap());
    }

    public void exitClass() {
        this.classVariables.pop();
    }

    public void enterLocalScope() {
        this.localVariablesByScope.push(new HashSet());
    }

    public void exitLocalScope() {
        for (String variableName : this.localVariablesByScope.pop()) {
            Deque<Variable> variableStack = this.localVariables.get(variableName);
            variableStack.pop();
            if (!variableStack.isEmpty()) continue;
            this.localVariables.remove(variableName);
        }
    }

    public void updateSemantics(CodeSemantics semantics) {
        this.semantics = semantics;
    }

    public void registerVariable(String variableName, VariableScope scope, boolean mutable) {
        logger.debug("Register variable {}", (Object)variableName);
        Variable variable = new Variable(variableName, scope, mutable);
        switch (scope) {
            case FILE: {
                this.fileVariables.put(variableName, variable);
                break;
            }
            case CLASS: {
                this.classVariables.getFirst().put(variableName, variable);
                break;
            }
            case LOCAL: {
                this.localVariables.putIfAbsent(variableName, new LinkedList());
                this.localVariables.get(variableName).push(variable);
                this.localVariablesByScope.getFirst().add(variableName);
            }
        }
    }

    public void registerVariableAccess(String variableName, boolean isClassVariable) {
        Variable variable;
        logger.debug("{} {}", (Object)variableName, (Object)this.nextVariableAccessType);
        if (this.ignoreNextVariableAccess) {
            this.ignoreNextVariableAccess = false;
            return;
        }
        Variable variable2 = variable = isClassVariable ? this.getClassVariable(variableName) : this.getVariable(variableName);
        if (variable != null) {
            if (this.nextVariableAccessType.isRead) {
                this.semantics.addRead(variable);
            }
            if (this.nextVariableAccessType.isWrite || this.mutableWrite && variable.isMutable()) {
                this.semantics.addWrite(variable);
            }
        }
        this.nextVariableAccessType = VariableAccessType.READ;
    }

    public void addAllNonLocalVariablesAsReads() {
        HashSet<Variable> nonLocalVariables = new HashSet<Variable>(this.fileVariables.values());
        if (!this.classVariables.isEmpty()) {
            nonLocalVariables.addAll(this.classVariables.getFirst().values());
            for (Variable variable : nonLocalVariables) {
                this.semantics.addRead(variable);
            }
        }
    }

    private Variable getVariable(String variableName) {
        Deque<Variable> variableIdStack = this.localVariables.get(variableName);
        if (variableIdStack != null) {
            return variableIdStack.getFirst();
        }
        Variable variable = this.getClassVariable(variableName);
        return variable != null ? variable : this.fileVariables.get(variableName);
    }

    private Variable getClassVariable(String variableName) {
        Map<String, Variable> currentClassVariables = this.classVariables.peek();
        return currentClassVariables != null ? currentClassVariables.get(variableName) : null;
    }
}

