/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.util;

import com.ibm.icu.text.CharsetDetector;
import com.ibm.icu.text.CharsetMatch;
import de.jplag.ParsingException;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;

public class FileUtils {
    private static final Charset DEFAULT_OUTPUT_CHARSET = StandardCharsets.UTF_8;
    private static final char BYTE_ORDER_MARK = '\ufeff';
    private static final int SINGLE_CHAR_BUFFER_SIZE = 10;

    private FileUtils() {
    }

    public static BufferedReader openFileReader(File file) throws IOException {
        BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));
        Charset charset = FileUtils.detectCharset(stream);
        BufferedReader reader = new BufferedReader(new FileReader(file, charset));
        FileUtils.removeBom(reader, charset);
        return reader;
    }

    public static String readFileContent(File file) throws IOException {
        try (BufferedReader reader = FileUtils.openFileReader(file);){
            String string = reader.lines().collect(Collectors.joining(System.lineSeparator()));
            return string;
        }
    }

    private static void removeBom(BufferedReader reader, Charset charset) throws IOException {
        if (charset.name().toUpperCase().startsWith("UTF")) {
            reader.mark(10);
            if (reader.read() != 65279) {
                reader.reset();
            }
        }
    }

    public static Charset detectCharset(File file) throws IOException {
        try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
            Charset charset = FileUtils.detectCharset(stream);
            return charset;
        }
    }

    public static Charset detectCharsetFromMultiple(Collection<File> files) throws ParsingException {
        HashMap<String, List> charsetValues = new HashMap<String, List>();
        ArrayList<CharsetMatch[]> matchData = new ArrayList<CharsetMatch[]>();
        for (File file : files) {
            try (BufferedInputStream stream = new BufferedInputStream(new FileInputStream(file));){
                matchData.add(FileUtils.detectAllCharsets(stream));
            }
            catch (IOException e) {
                throw new ParsingException(file, (Throwable)e);
            }
        }
        for (CharsetMatch[] matches : matchData) {
            HashSet<String> remaining = new HashSet<String>(Set.of(CharsetDetector.getAllDetectableCharsets()));
            for (CharsetMatch match : matches) {
                charsetValues.putIfAbsent(match.getName(), new ArrayList());
                ((List)charsetValues.get(match.getName())).add(match.getConfidence());
                remaining.remove(match.getName());
            }
            remaining.forEach(it -> {
                charsetValues.putIfAbsent((String)it, new ArrayList());
                ((List)charsetValues.get(it)).add(0);
            });
        }
        AtomicReference<Charset> mostProbable = new AtomicReference<Charset>(StandardCharsets.UTF_8);
        AtomicReference<Double> mostProbableConfidence = new AtomicReference<Double>(0.0);
        charsetValues.forEach((charset, confidenceValues) -> {
            double average = confidenceValues.stream().mapToInt(it -> it).average().orElse(0.0);
            if (confidenceValues.stream().anyMatch(it -> it == 0)) {
                average = 0.0;
            }
            if (average > (Double)mostProbableConfidence.get()) {
                mostProbable.set(Charset.forName(charset));
                mostProbableConfidence.set(average);
            }
        });
        return mostProbable.get();
    }

    private static Charset detectCharset(InputStream stream) throws IOException {
        CharsetDetector charsetDetector = new CharsetDetector();
        charsetDetector.setText(stream);
        CharsetMatch match = charsetDetector.detect();
        return Charset.forName(match.getName());
    }

    private static CharsetMatch[] detectAllCharsets(InputStream stream) throws IOException {
        CharsetDetector charsetDetector = new CharsetDetector();
        charsetDetector.setText(stream);
        return charsetDetector.detectAll();
    }

    public static Writer openFileWriter(File file) throws IOException {
        return new BufferedWriter(new FileWriter(file, DEFAULT_OUTPUT_CHARSET));
    }

    public static void write(File file, String content) throws IOException {
        Writer writer = FileUtils.openFileWriter(file);
        writer.write(content);
        writer.close();
    }

    public static boolean checkWritable(File file) {
        if (file.exists()) {
            return file.canWrite();
        }
        return FileUtils.checkParentWritable(file);
    }

    public static boolean checkParentWritable(File file) {
        return file.getAbsoluteFile().getParentFile().canWrite();
    }
}

