/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.rust;

import de.jplag.AbstractParser;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.rust.JPlagRustListener;
import de.jplag.rust.RustTokenType;
import de.jplag.rust.grammar.RustLexer;
import de.jplag.rust.grammar.RustParser;
import de.jplag.util.FileUtils;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.CharStream;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class RustParserAdapter
extends AbstractParser {
    private File currentFile;
    private List<Token> tokens;

    public List<Token> parse(Set<File> files) throws ParsingException {
        this.tokens = new ArrayList<Token>();
        for (File file : files) {
            this.parseFile(file);
            this.tokens.add(Token.fileEnd((File)file));
        }
        return this.tokens;
    }

    private void parseFile(File file) throws ParsingException {
        try (BufferedReader reader = FileUtils.openFileReader((File)file);){
            this.currentFile = file;
            RustLexer lexer = new RustLexer((CharStream)CharStreams.fromReader((Reader)reader));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            RustParser parser = new RustParser((TokenStream)tokenStream);
            RustParser.CrateContext entryContext = parser.crate();
            ParseTreeWalker treeWalker = new ParseTreeWalker();
            for (int i = 0; i < entryContext.getChildCount(); ++i) {
                ParseTree parseTree = entryContext.getChild(i);
                treeWalker.walk((ParseTreeListener)new JPlagRustListener(this), parseTree);
            }
        }
        catch (IOException exception) {
            throw new ParsingException(file, exception.getMessage(), (Throwable)exception);
        }
    }

    void addToken(RustTokenType type, int line, int start, int length) {
        this.tokens.add(new Token((TokenType)type, this.currentFile, line, start, length));
    }
}

