/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.swift;

import de.jplag.AbstractParser;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.swift.JPlagSwiftListener;
import de.jplag.swift.SwiftTokenType;
import de.jplag.swift.grammar.Swift5Lexer;
import de.jplag.swift.grammar.Swift5Parser;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.antlr.v4.runtime.CharStreams;
import org.antlr.v4.runtime.CommonTokenStream;
import org.antlr.v4.runtime.TokenSource;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.tree.ParseTree;
import org.antlr.v4.runtime.tree.ParseTreeListener;
import org.antlr.v4.runtime.tree.ParseTreeWalker;

public class SwiftParserAdapter
extends AbstractParser {
    public static final int NOT_SET = -1;
    private File currentFile;
    private List<Token> tokens;

    public List<Token> parse(Set<File> files) throws ParsingException {
        this.tokens = new ArrayList<Token>();
        for (File file : files) {
            this.parse(file);
            this.tokens.add(Token.fileEnd((File)file));
        }
        return this.tokens;
    }

    private void parse(File file) throws ParsingException {
        try (FileInputStream inputStream = new FileInputStream(file);){
            this.currentFile = file;
            Swift5Lexer lexer = new Swift5Lexer(CharStreams.fromStream((InputStream)inputStream));
            CommonTokenStream tokenStream = new CommonTokenStream((TokenSource)lexer);
            Swift5Parser parser = new Swift5Parser((TokenStream)tokenStream);
            Swift5Parser.Top_levelContext entryContext = parser.top_level();
            ParseTreeWalker treeWalker = new ParseTreeWalker();
            JPlagSwiftListener listener = new JPlagSwiftListener(this);
            for (int i = 0; i < entryContext.getChildCount(); ++i) {
                ParseTree parseTree = entryContext.getChild(i);
                treeWalker.walk((ParseTreeListener)listener, parseTree);
            }
        }
        catch (IOException exception) {
            throw new ParsingException(file, exception.getMessage(), (Throwable)exception);
        }
    }

    void addToken(SwiftTokenType tokenType, int line, int column, int length) {
        this.tokens.add(new Token((TokenType)tokenType, this.currentFile, line, column, length));
    }
}

