/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.swift.grammar;

import java.util.BitSet;
import org.antlr.v4.runtime.Token;
import org.antlr.v4.runtime.TokenStream;
import org.antlr.v4.runtime.misc.Interval;

public class SwiftSupport {
    public static final BitSet operatorHead = new BitSet(65536);
    public static final BitSet operatorCharacter;
    public static final BitSet leftWS;
    public static final BitSet rightWS;

    private static boolean isCharacterFromSet(Token token, BitSet bitSet) {
        if (token.getType() == -1) {
            return false;
        }
        String text = token.getText();
        int codepoint = text.codePointAt(0);
        if (Character.charCount(codepoint) != text.length()) {
            return false;
        }
        return bitSet.get(codepoint);
    }

    public static boolean isOperatorHead(Token token) {
        return SwiftSupport.isCharacterFromSet(token, operatorHead);
    }

    public static boolean isOperatorCharacter(Token token) {
        return SwiftSupport.isCharacterFromSet(token, operatorCharacter);
    }

    public static boolean isOpNext(TokenStream tokens) {
        int start = tokens.index();
        int stop = SwiftSupport.getLastOpTokenIndex(tokens);
        return stop != -1;
    }

    public static int getLastOpTokenIndex(TokenStream tokens) {
        SwiftSupport.fillUp(tokens);
        int currentTokenIndex = tokens.index();
        Token currentToken = tokens.get(currentTokenIndex);
        if (currentToken.getType() == 138 && tokens.get(currentTokenIndex + 1).getType() == 138) {
            currentToken = tokens.get(currentTokenIndex += 2);
            while (currentToken.getType() == 138 || SwiftSupport.isOperatorCharacter(currentToken)) {
                currentToken = tokens.get(++currentTokenIndex);
            }
            return currentTokenIndex - 1;
        }
        if (SwiftSupport.isOperatorHead(currentToken)) {
            currentToken = tokens.get(currentTokenIndex);
            while (SwiftSupport.isOperatorCharacter(currentToken)) {
                currentToken = tokens.get(++currentTokenIndex);
            }
            return currentTokenIndex - 1;
        }
        return -1;
    }

    public static boolean isBinaryOp(TokenStream tokens) {
        SwiftSupport.fillUp(tokens);
        int stop = SwiftSupport.getLastOpTokenIndex(tokens);
        if (stop == -1) {
            return false;
        }
        int start = tokens.index();
        Token currentToken = tokens.get(start);
        Token prevToken = tokens.get(start - 1);
        Token nextToken = tokens.get(stop + 1);
        boolean prevIsWS = SwiftSupport.isLeftOperatorWS(prevToken);
        boolean nextIsWS = SwiftSupport.isRightOperatorWS(nextToken);
        if (prevIsWS) {
            return nextIsWS;
        }
        if (currentToken.getType() == 151 || currentToken.getType() == 152) {
            return false;
        }
        if (!nextIsWS) {
            return nextToken.getType() != 138;
        }
        return false;
    }

    public static boolean isPrefixOp(TokenStream tokens) {
        SwiftSupport.fillUp(tokens);
        int stop = SwiftSupport.getLastOpTokenIndex(tokens);
        if (stop == -1) {
            return false;
        }
        int start = tokens.index();
        Token prevToken = tokens.get(start - 1);
        Token nextToken = tokens.get(stop + 1);
        boolean prevIsWS = SwiftSupport.isLeftOperatorWS(prevToken);
        boolean nextIsWS = SwiftSupport.isRightOperatorWS(nextToken);
        return prevIsWS && !nextIsWS;
    }

    public static boolean isPostfixOp(TokenStream tokens) {
        SwiftSupport.fillUp(tokens);
        int stop = SwiftSupport.getLastOpTokenIndex(tokens);
        if (stop == -1) {
            return false;
        }
        int start = tokens.index();
        Token prevToken = tokens.get(start - 1);
        Token nextToken = tokens.get(stop + 1);
        boolean prevIsWS = SwiftSupport.isLeftOperatorWS(prevToken);
        boolean nextIsWS = SwiftSupport.isRightOperatorWS(nextToken);
        return !prevIsWS && nextIsWS || !prevIsWS && nextToken.getType() == 138;
    }

    public static boolean isOperator(TokenStream tokens, String op) {
        SwiftSupport.fillUp(tokens);
        int stop = SwiftSupport.getLastOpTokenIndex(tokens);
        if (stop == -1) {
            return false;
        }
        int start = tokens.index();
        String text = tokens.getText(Interval.of((int)start, (int)stop));
        return text.equals(op);
    }

    public static boolean isLeftOperatorWS(Token t) {
        return leftWS.get(t.getType());
    }

    public static boolean isRightOperatorWS(Token t) {
        return rightWS.get(t.getType()) || t.getType() == -1;
    }

    public static boolean isSeparatedStatement(TokenStream tokens, int indexOfPreviousStatement) {
        int indexFrom;
        SwiftSupport.fillUp(tokens);
        int indexTo = tokens.index() - 1;
        if (indexFrom >= 0) {
            for (indexFrom = indexOfPreviousStatement - 1; indexFrom >= 0 && tokens.get(indexFrom).getChannel() == 1; --indexFrom) {
            }
            for (int i = indexTo; i >= indexFrom; --i) {
                String t = tokens.get(i).getText();
                if (!t.contains("\n") && !t.contains(";")) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static void fillUp(TokenStream tokens) {
        int t;
        int jj = 1;
        while ((t = tokens.LA(jj)) != -1) {
            ++jj;
        }
    }

    static {
        leftWS = new BitSet(255);
        rightWS = new BitSet(255);
        operatorHead.set(47);
        operatorHead.set(61);
        operatorHead.set(45);
        operatorHead.set(43);
        operatorHead.set(33);
        operatorHead.set(42);
        operatorHead.set(37);
        operatorHead.set(38);
        operatorHead.set(124);
        operatorHead.set(60);
        operatorHead.set(62);
        operatorHead.set(94);
        operatorHead.set(126);
        operatorHead.set(63);
        operatorHead.set(161, 168);
        operatorHead.set(169);
        operatorHead.set(171);
        operatorHead.set(172);
        operatorHead.set(174);
        operatorHead.set(176, 178);
        operatorHead.set(182);
        operatorHead.set(187);
        operatorHead.set(191);
        operatorHead.set(215);
        operatorHead.set(247);
        operatorHead.set(8214, 8216);
        operatorHead.set(8224, 8232);
        operatorHead.set(8240, 8255);
        operatorHead.set(8257, 8276);
        operatorHead.set(8277, 8287);
        operatorHead.set(8592, 9216);
        operatorHead.set(9472, 10102);
        operatorHead.set(10132, 11264);
        operatorHead.set(11776, 11904);
        operatorHead.set(12289, 12292);
        operatorHead.set(12296, 12321);
        operatorHead.set(12336);
        operatorCharacter = (BitSet)operatorHead.clone();
        operatorCharacter.set(768, 880);
        operatorCharacter.set(7616, 7680);
        operatorCharacter.set(8400, 8448);
        operatorCharacter.set(65024, 65040);
        operatorCharacter.set(65056, 65072);
        operatorCharacter.set(917760, 918000);
        leftWS.set(176);
        leftWS.set(140);
        leftWS.set(187);
        leftWS.set(184);
        leftWS.set(141);
        leftWS.set(139);
        leftWS.set(145);
        leftWS.set(146);
        leftWS.set(147);
        rightWS.set(176);
        rightWS.set(143);
        rightWS.set(144);
        rightWS.set(142);
        rightWS.set(145);
        rightWS.set(146);
        rightWS.set(147);
        rightWS.set(179);
        rightWS.set(178);
    }
}

