/*
 * Decompiled with CFR 0.152.
 */
package de.jplag.text;

import de.jplag.AbstractParser;
import de.jplag.ParsingException;
import de.jplag.Token;
import de.jplag.TokenType;
import de.jplag.text.TextTokenType;
import edu.stanford.nlp.ling.CoreLabel;
import edu.stanford.nlp.pipeline.CoreDocument;
import edu.stanford.nlp.pipeline.StanfordCoreNLP;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.util.ArrayList;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class ParserAdapter
extends AbstractParser {
    private static final char LF = '\n';
    private static final char CR = '\r';
    private static final String ANNOTATORS_KEY = "annotators";
    private static final String ANNOTATORS_VALUE = "tokenize";
    private final StanfordCoreNLP pipeline;
    private List<Token> tokens;
    private File currentFile;
    private int currentLine;
    private int currentLineBreakIndex;

    public ParserAdapter() {
        Properties properties = new Properties();
        properties.put(ANNOTATORS_KEY, ANNOTATORS_VALUE);
        this.pipeline = new StanfordCoreNLP(properties);
    }

    public List<Token> parse(Set<File> files) throws ParsingException {
        this.tokens = new ArrayList<Token>();
        for (File file : files) {
            this.logger.trace("Parsing file {}", (Object)file);
            this.parseFile(file);
            this.tokens.add(Token.fileEnd((File)file));
        }
        return this.tokens;
    }

    private void parseFile(File file) throws ParsingException {
        this.currentFile = file;
        this.currentLine = 1;
        this.currentLineBreakIndex = 0;
        String content = this.readFile(file);
        int lastTokenEnd = 0;
        CoreDocument coreDocument = this.pipeline.processToCoreDocument(content);
        for (CoreLabel token : coreDocument.tokens()) {
            this.advanceLineBreaks(content, lastTokenEnd, token.beginPosition());
            lastTokenEnd = token.endPosition();
            if (!this.isWord(token)) continue;
            this.addToken(token);
        }
    }

    private void advanceLineBreaks(String content, int lastTokenEnd, int nextTokenBegin) {
        for (int i = lastTokenEnd; i < nextTokenBegin; ++i) {
            if (content.charAt(i) == '\n') {
                ++this.currentLine;
                this.currentLineBreakIndex = i;
                continue;
            }
            if (content.charAt(i) != '\r') continue;
            if (i + 1 >= content.length() || content.charAt(i + 1) == '\n') {
                // empty if block
            }
            ++this.currentLine;
            this.currentLineBreakIndex = ++i;
        }
    }

    private boolean isWord(CoreLabel token) {
        String text = token.originalText();
        return text.chars().anyMatch(it -> Character.isAlphabetic(it) || Character.isDigit(it));
    }

    private void addToken(CoreLabel label) {
        String text = label.originalText();
        int column = label.beginPosition() - this.currentLineBreakIndex;
        int length = label.endPosition() - label.beginPosition();
        this.tokens.add(new Token((TokenType)new TextTokenType(text), this.currentFile, this.currentLine, column, length));
    }

    private String readFile(File file) throws ParsingException {
        try {
            return Files.readString(file.toPath());
        }
        catch (IOException e) {
            throw new ParsingException(file, e.getMessage(), (Throwable)e);
        }
    }
}

