/*
 * Decompiled with CFR 0.152.
 */
package de.jsone_studios.wrapper.spotify;

import de.jsone_studios.wrapper.spotify.AuthenticationProvider;
import de.jsone_studios.wrapper.spotify.SpotifyApiException;
import de.jsone_studios.wrapper.spotify.SpotifyWebApi;
import de.jsone_studios.wrapper.spotify.authentication.SpotifyAuthApi;
import de.jsone_studios.wrapper.spotify.models.AuthTokens;
import de.jsone_studios.wrapper.spotify.util.TextUtils;
import java.io.IOException;
import okhttp3.HttpUrl;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import retrofit2.Call;

public class AuthenticatedSpotifyApi
extends SpotifyWebApi {
    private final AuthenticationProvider authProvider;
    private final SpotifyAuthApi authApi;

    public AuthenticatedSpotifyApi(AuthenticationProvider authProvider, HttpUrl baseUrlWebApi, HttpUrl baseUrlAuthApi) {
        super(AuthenticatedSpotifyApi.createOkHttpClient(authProvider), baseUrlWebApi);
        this.authProvider = authProvider;
        this.authApi = new SpotifyAuthApi(authProvider.getClientId(), authProvider.getClientSecret(), baseUrlAuthApi);
    }

    public AuthenticatedSpotifyApi(AuthenticationProvider authProvider) {
        super(AuthenticatedSpotifyApi.createOkHttpClient(authProvider));
        this.authProvider = authProvider;
        this.authApi = new SpotifyAuthApi(authProvider.getClientId(), authProvider.getClientSecret());
    }

    private static OkHttpClient createOkHttpClient(AuthenticationProvider authProvider) {
        return new OkHttpClient.Builder().addInterceptor((Interceptor)new AuthenticationInterceptor(authProvider)).build();
    }

    public SpotifyAuthApi getAuthApi() {
        return this.authApi;
    }

    public boolean getAuthTokensFromAuthCode(String authCode, String redirectUri) {
        Call<AuthTokens> call = this.authApi.getAuthTokensFromAuthCode(authCode, redirectUri);
        return this.executeAuthTokensCall(call);
    }

    private boolean getAuthTokensFromRefreshToken() {
        String refreshToken = this.authProvider.getRefreshToken();
        if (TextUtils.isEmpty(refreshToken)) {
            return false;
        }
        Call<AuthTokens> call = this.authApi.getAuthTokensFromRefreshToken(refreshToken);
        return this.executeAuthTokensCall(call);
    }

    private boolean executeAuthTokensCall(Call<AuthTokens> authTokensCall) {
        try {
            AuthTokens authTokens = this.callApiAndReturnBody(authTokensCall);
            this.authProvider.onNewAuthTokens(authTokens);
            return true;
        }
        catch (SpotifyApiException e) {
            this.authProvider.onErrorGettingAuthTokens(e);
            return false;
        }
    }

    @Override
    public <T> retrofit2.Response<T> callApi(Call<T> call) throws SpotifyApiException {
        try {
            retrofit2.Response response = call.execute();
            if (response.isSuccessful()) {
                return response;
            }
            if (response.code() == 401 && this.getAuthTokensFromRefreshToken()) {
                return call.clone().execute();
            }
            return response;
        }
        catch (IOException e) {
            throw new SpotifyApiException("Failed to make api call", e);
        }
    }

    private static class AuthenticationInterceptor
    implements Interceptor {
        private final AuthenticationProvider authProvider;

        AuthenticationInterceptor(AuthenticationProvider authProvider) {
            this.authProvider = authProvider;
        }

        public Response intercept(Interceptor.Chain chain) throws IOException {
            Request request = chain.request();
            String accessToken = this.authProvider.getAccessToken();
            if (accessToken != null) {
                request = request.newBuilder().addHeader("Authorization", "Bearer " + accessToken).build();
            }
            return chain.proceed(request);
        }
    }
}

