/*
 * Decompiled with CFR 0.152.
 */
package de.jsone_studios.wrapper.spotify;

import de.jsone_studios.wrapper.spotify.SpotifyApiException;
import de.jsone_studios.wrapper.spotify.models.ErrorDetails;
import de.jsone_studios.wrapper.spotify.models.ErrorResponse;
import de.jsone_studios.wrapper.spotify.services.AlbumsSpotifyService;
import de.jsone_studios.wrapper.spotify.services.ArtistsSpotifyService;
import de.jsone_studios.wrapper.spotify.services.BrowseSpotifyService;
import de.jsone_studios.wrapper.spotify.services.FollowSpotifyService;
import de.jsone_studios.wrapper.spotify.services.LibrarySpotifyService;
import de.jsone_studios.wrapper.spotify.services.PersonalizationSpotifyService;
import de.jsone_studios.wrapper.spotify.services.PlaylistTracksSpotifyService;
import de.jsone_studios.wrapper.spotify.services.PlaylistsSpotifyService;
import de.jsone_studios.wrapper.spotify.services.SearchSpotifyService;
import de.jsone_studios.wrapper.spotify.services.TracksSpotifyService;
import de.jsone_studios.wrapper.spotify.services.UsersProfileSpotifyService;
import java.io.IOException;
import java.lang.annotation.Annotation;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Response;
import retrofit2.Retrofit;

public interface SpotifyApi {
    default public <T> T callApiAndReturnBody(Call<T> call) throws SpotifyApiException {
        return this.getBody(this.callApi(call));
    }

    default public <T> Response<T> callApi(Call<T> call) throws SpotifyApiException {
        try {
            return call.execute();
        }
        catch (IOException e) {
            throw new SpotifyApiException("Failed to make api call", e);
        }
    }

    default public <T> T getBody(Response<T> response) throws SpotifyApiException {
        if (response.isSuccessful() && response.body() != null) {
            return (T)response.body();
        }
        throw new SpotifyApiException("Api call failed", this.getErrorBody(response));
    }

    default public ErrorDetails getErrorBody(Response<?> response) throws SpotifyApiException {
        if (response.errorBody() == null) {
            throw new SpotifyApiException("Failed to get error body", this.getErrorDetailsFromResponse(response));
        }
        try {
            Converter converter = this.getRetrofit().responseBodyConverter(ErrorResponse.class, new Annotation[0]);
            ErrorResponse errorResponse = (ErrorResponse)converter.convert((Object)response.errorBody());
            if (errorResponse != null) {
                return errorResponse.error;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        throw new SpotifyApiException("Failed to parse error body", this.getErrorDetailsFromResponse(response));
    }

    default public ErrorDetails getErrorDetailsFromResponse(Response<?> response) {
        ErrorDetails errorDetails = new ErrorDetails();
        errorDetails.status = response.code();
        errorDetails.message = response.message();
        return errorDetails;
    }

    public Retrofit getRetrofit();

    public AlbumsSpotifyService getAlbumsService();

    public ArtistsSpotifyService getArtistsService();

    public BrowseSpotifyService getBrowseService();

    public FollowSpotifyService getFollowService();

    public LibrarySpotifyService getLibraryService();

    public PersonalizationSpotifyService getPersonalizationService();

    public PlaylistsSpotifyService getPlaylistsService();

    public PlaylistTracksSpotifyService getPlaylistTracksService();

    public SearchSpotifyService getSearchService();

    public TracksSpotifyService getTracksService();

    public UsersProfileSpotifyService getUsersProfileService();
}

