/*
 * Decompiled with CFR 0.152.
 */
package de.jsone_studios.wrapper.spotify;

import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import de.jsone_studios.wrapper.spotify.SpotifyApi;
import de.jsone_studios.wrapper.spotify.services.AlbumsSpotifyService;
import de.jsone_studios.wrapper.spotify.services.ArtistsSpotifyService;
import de.jsone_studios.wrapper.spotify.services.BrowseSpotifyService;
import de.jsone_studios.wrapper.spotify.services.FollowSpotifyService;
import de.jsone_studios.wrapper.spotify.services.LibrarySpotifyService;
import de.jsone_studios.wrapper.spotify.services.PersonalizationSpotifyService;
import de.jsone_studios.wrapper.spotify.services.PlaylistTracksSpotifyService;
import de.jsone_studios.wrapper.spotify.services.PlaylistsSpotifyService;
import de.jsone_studios.wrapper.spotify.services.SearchSpotifyService;
import de.jsone_studios.wrapper.spotify.services.TracksSpotifyService;
import de.jsone_studios.wrapper.spotify.services.UsersProfileSpotifyService;
import okhttp3.HttpUrl;
import okhttp3.OkHttpClient;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class SpotifyWebApi
implements SpotifyApi {
    public static final String SPOTIFY_WEB_API_ENDPOINT = "https://api.spotify.com/v1/";
    private final Retrofit retrofit;
    private final AlbumsSpotifyService albumsService;
    private final ArtistsSpotifyService artistsService;
    private final BrowseSpotifyService browseService;
    private final FollowSpotifyService followService;
    private final LibrarySpotifyService libraryService;
    private final PersonalizationSpotifyService personalizationService;
    private final PlaylistsSpotifyService playlistsService;
    private final PlaylistTracksSpotifyService playlistTracksService;
    private final SearchSpotifyService searchService;
    private final TracksSpotifyService tracksService;
    private final UsersProfileSpotifyService usersProfileService;

    public SpotifyWebApi(Retrofit retrofit) {
        this.retrofit = retrofit;
        this.albumsService = (AlbumsSpotifyService)retrofit.create(AlbumsSpotifyService.class);
        this.artistsService = (ArtistsSpotifyService)retrofit.create(ArtistsSpotifyService.class);
        this.browseService = (BrowseSpotifyService)retrofit.create(BrowseSpotifyService.class);
        this.followService = (FollowSpotifyService)retrofit.create(FollowSpotifyService.class);
        this.libraryService = (LibrarySpotifyService)retrofit.create(LibrarySpotifyService.class);
        this.personalizationService = (PersonalizationSpotifyService)retrofit.create(PersonalizationSpotifyService.class);
        this.playlistsService = (PlaylistsSpotifyService)retrofit.create(PlaylistsSpotifyService.class);
        this.playlistTracksService = (PlaylistTracksSpotifyService)retrofit.create(PlaylistTracksSpotifyService.class);
        this.searchService = (SearchSpotifyService)retrofit.create(SearchSpotifyService.class);
        this.tracksService = (TracksSpotifyService)retrofit.create(TracksSpotifyService.class);
        this.usersProfileService = (UsersProfileSpotifyService)retrofit.create(UsersProfileSpotifyService.class);
    }

    public SpotifyWebApi(OkHttpClient okHttpClient) {
        this(SpotifyWebApi.createDefaultRetrofit(okHttpClient, HttpUrl.get((String)SPOTIFY_WEB_API_ENDPOINT)));
    }

    public SpotifyWebApi(OkHttpClient okHttpClient, HttpUrl baseUrl) {
        this(SpotifyWebApi.createDefaultRetrofit(okHttpClient, baseUrl));
    }

    public SpotifyWebApi(HttpUrl baseUrl) {
        this(new OkHttpClient(), baseUrl);
    }

    public SpotifyWebApi() {
        this(new OkHttpClient());
    }

    private static Retrofit createDefaultRetrofit(OkHttpClient okHttpClient, HttpUrl baseUrl) {
        ObjectMapper mapper = new ObjectMapper().configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        return new Retrofit.Builder().baseUrl(baseUrl).client(okHttpClient).addConverterFactory((Converter.Factory)JacksonConverterFactory.create((ObjectMapper)mapper)).build();
    }

    @Override
    public Retrofit getRetrofit() {
        return this.retrofit;
    }

    @Override
    public AlbumsSpotifyService getAlbumsService() {
        return this.albumsService;
    }

    @Override
    public ArtistsSpotifyService getArtistsService() {
        return this.artistsService;
    }

    @Override
    public BrowseSpotifyService getBrowseService() {
        return this.browseService;
    }

    @Override
    public FollowSpotifyService getFollowService() {
        return this.followService;
    }

    @Override
    public LibrarySpotifyService getLibraryService() {
        return this.libraryService;
    }

    @Override
    public PersonalizationSpotifyService getPersonalizationService() {
        return this.personalizationService;
    }

    @Override
    public PlaylistsSpotifyService getPlaylistsService() {
        return this.playlistsService;
    }

    @Override
    public PlaylistTracksSpotifyService getPlaylistTracksService() {
        return this.playlistTracksService;
    }

    @Override
    public SearchSpotifyService getSearchService() {
        return this.searchService;
    }

    @Override
    public TracksSpotifyService getTracksService() {
        return this.tracksService;
    }

    @Override
    public UsersProfileSpotifyService getUsersProfileService() {
        return this.usersProfileService;
    }
}

