/*
 * Decompiled with CFR 0.152.
 */
package de.jsone_studios.wrapper.spotify.authentication;

import de.jsone_studios.wrapper.spotify.authentication.AuthSpotifyService;
import de.jsone_studios.wrapper.spotify.authentication.Scope;
import de.jsone_studios.wrapper.spotify.models.AuthTokens;
import java.util.Base64;
import java.util.List;
import okhttp3.HttpUrl;
import retrofit2.Call;
import retrofit2.Converter;
import retrofit2.Retrofit;
import retrofit2.converter.jackson.JacksonConverterFactory;

public class SpotifyAuthApi {
    public static final String SPOTIFY_ACCOUNTS_ENDPOINT = "https://accounts.spotify.com";
    private final String clientId;
    private final String clientSecret;
    private final AuthSpotifyService authService;

    public SpotifyAuthApi(String clientId, String clientSecret, HttpUrl baseUrl) {
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.authService = this.createAuthService(baseUrl);
    }

    public SpotifyAuthApi(String clientId, String clientSecret, String baseUrl) {
        this(clientId, clientSecret, HttpUrl.get((String)baseUrl));
    }

    public SpotifyAuthApi(String clientId, String clientSecret) {
        this(clientId, clientSecret, SPOTIFY_ACCOUNTS_ENDPOINT);
    }

    private AuthSpotifyService createAuthService(HttpUrl baseUrl) {
        Retrofit retrofit = new Retrofit.Builder().baseUrl(baseUrl).addConverterFactory((Converter.Factory)JacksonConverterFactory.create()).build();
        return (AuthSpotifyService)retrofit.create(AuthSpotifyService.class);
    }

    public HttpUrl getAuthorizeUrl(String redirectUri, String state, List<Scope> scopes) {
        return this.getAuthorizeUrl("code", redirectUri, state, scopes);
    }

    public HttpUrl getAuthorizeUrl(String responseType, String redirectUri, String state, List<Scope> scopes) {
        String scope = scopes == null || scopes.size() == 0 ? "" : scopes.stream().map(Scope::getScope).reduce((scope1, scope2) -> scope1 + " " + scope2).get();
        return new HttpUrl.Builder().scheme("https").host("accounts.spotify.com").addPathSegment("authorize").addQueryParameter("client_id", this.clientId).addQueryParameter("response_type", responseType).addEncodedQueryParameter("redirect_uri", redirectUri).addQueryParameter("scope", scope).addQueryParameter("state", state).build();
    }

    public Call<AuthTokens> getAuthTokensFromAuthCode(String code, String redirectUri) {
        String authHeader = this.createAuthorizationHeaderValue();
        return this.authService.getAuthTokens(authHeader, "authorization_code", code, redirectUri);
    }

    public Call<AuthTokens> getAuthTokensFromRefreshToken(String refreshToken) {
        String authHeader = this.createAuthorizationHeaderValue();
        return this.authService.getAuthTokens(authHeader, "refresh_token", refreshToken);
    }

    private String createAuthorizationHeaderValue() {
        String clientInfo = this.clientId + ":" + this.clientSecret;
        String base64ClientInfo = Base64.getEncoder().encodeToString(clientInfo.getBytes());
        return "Basic " + base64ClientInfo;
    }

    public RedirectResponse parseRedirectResponse(String url) {
        HttpUrl httpUrl = HttpUrl.parse((String)url);
        if (httpUrl == null) {
            return null;
        }
        String state = httpUrl.queryParameter("state");
        String error = httpUrl.queryParameter("error");
        String authCode = httpUrl.queryParameter("code");
        return new RedirectResponse(state, error, authCode);
    }

    public class RedirectResponse {
        private final String state;
        private final String error;
        private final String authCode;

        private RedirectResponse(String state, String error, String authCode) {
            this.state = state;
            this.error = error;
            this.authCode = authCode;
        }

        public String getState() {
            return this.state;
        }

        public String getError() {
            return this.error;
        }

        public String getAuthCode() {
            return this.authCode;
        }
    }
}

