/*
 * Decompiled with CFR 0.152.
 */
package de.jsone_studios.wrapper.spotify.services;

import de.jsone_studios.wrapper.spotify.models.Image;
import de.jsone_studios.wrapper.spotify.models.Pager;
import de.jsone_studios.wrapper.spotify.models.Playlist;
import de.jsone_studios.wrapper.spotify.models.PlaylistSimple;
import de.jsone_studios.wrapper.spotify.models.Result;
import java.util.List;
import java.util.Map;
import retrofit2.Call;
import retrofit2.http.Body;
import retrofit2.http.GET;
import retrofit2.http.Headers;
import retrofit2.http.POST;
import retrofit2.http.PUT;
import retrofit2.http.Path;
import retrofit2.http.QueryMap;

public interface PlaylistsSpotifyService {
    @GET(value="me/playlists")
    public Call<Pager<PlaylistSimple>> getMyPlaylists();

    @GET(value="me/playlists")
    public Call<Pager<PlaylistSimple>> getMyPlaylists(@QueryMap Map<String, Object> var1);

    @GET(value="users/{id}/playlists")
    public Call<Pager<PlaylistSimple>> getPlaylists(@Path(value="id") String var1);

    @GET(value="users/{id}/playlists")
    public Call<Pager<PlaylistSimple>> getPlaylists(@Path(value="id") String var1, @QueryMap Map<String, Object> var2);

    @GET(value="playlists/{playlist_id}")
    public Call<Playlist> getPlaylist(@Path(value="playlist_id") String var1);

    @GET(value="playlists/{playlist_id}")
    public Call<Playlist> getPlaylist(@Path(value="playlist_id") String var1, @QueryMap Map<String, Object> var2);

    @POST(value="users/{user_id}/playlists")
    public Call<Playlist> createPlaylist(@Path(value="user_id") String var1, @Body Map<String, Object> var2);

    @PUT(value="playlists/{playlist_id}")
    public Call<Result> changePlaylistDetails(@Path(value="playlist_id") String var1, @Body Map<String, Object> var2);

    @GET(value="playlists/{playlist_id}/images")
    public Call<List<Image>> getPlaylistCoverImages(@Path(value="playlist_id") String var1);

    @PUT(value="playlists/{playlist_id}/images")
    @Headers(value={"Content-Type: image/jpeg"})
    public Call<Result> uploadPlaylistCoverImage(@Path(value="playlist_id") String var1, @Body String var2);
}

