/*
 * Decompiled with CFR 0.152.
 */
package de.jsone_studios.wrapper.spotify.util;

import de.jsone_studios.wrapper.spotify.util.SpotifyUriException;

public class SpotifyUri {
    private String artistsId;
    private String albumId;
    private String trackId;
    private String playlistId;
    private String userId;

    public boolean isArtist() {
        return this.artistsId != null;
    }

    public String getArtistId() throws SpotifyUriException {
        if (this.artistsId != null) {
            return this.artistsId;
        }
        throw new SpotifyUriException("SpotifyUri does not contain an artist id");
    }

    public boolean isAlbum() {
        return this.albumId != null;
    }

    public String getAlbumId() throws SpotifyUriException {
        if (this.albumId != null) {
            return this.albumId;
        }
        throw new SpotifyUriException("SpotifyUri does not contain an album id");
    }

    public boolean isTrack() {
        return this.trackId != null;
    }

    public String getTrackId() throws SpotifyUriException {
        if (this.trackId != null) {
            return this.trackId;
        }
        throw new SpotifyUriException("SpotifyUri does not contain a track id");
    }

    public boolean isPlaylist() {
        return this.playlistId != null;
    }

    public String getPlaylistId() throws SpotifyUriException {
        if (this.playlistId != null) {
            return this.playlistId;
        }
        throw new SpotifyUriException("SpotifyUri does not contain a playlist id");
    }

    public boolean isUser() {
        return this.userId != null;
    }

    public String getUserId() throws SpotifyUriException {
        if (this.userId != null) {
            return this.userId;
        }
        throw new SpotifyUriException("SpotifyUri does not contain a user id");
    }

    public String toSpotifyUri() throws SpotifyUriException {
        if (this.artistsId != null) {
            return "spotify:artist:" + this.artistsId;
        }
        if (this.albumId != null) {
            return "spotify:album:" + this.albumId;
        }
        if (this.trackId != null) {
            return "spotify:track:" + this.trackId;
        }
        if (this.playlistId != null) {
            return "spotify:playlist:" + this.playlistId;
        }
        if (this.userId != null) {
            return "spotify:user:" + this.userId;
        }
        throw new SpotifyUriException("Failed to generate spotify uri");
    }

    public String toString() {
        try {
            return this.toSpotifyUri();
        }
        catch (SpotifyUriException e) {
            return super.toString();
        }
    }

    public static SpotifyUri parseUri(String string) throws SpotifyUriException {
        if (string == null || string.length() == 0) {
            throw new SpotifyUriException("Can not parse empty spotifyUri");
        }
        String[] parts = string.split(":");
        if (parts.length != 3) {
            throw new SpotifyUriException("SpotifyUri has wrong format: " + string);
        }
        if (!"spotify".equals(parts[0])) {
            throw new SpotifyUriException("SpotifyUri must start with 'spotify'");
        }
        SpotifyUri spotifyUri = new SpotifyUri();
        if ("artist".equals(parts[1])) {
            spotifyUri.artistsId = parts[2];
        } else if ("album".equals(parts[1])) {
            spotifyUri.albumId = parts[2];
        } else if ("track".equals(parts[1])) {
            spotifyUri.trackId = parts[2];
        } else if ("user".equals(parts[1])) {
            spotifyUri.userId = parts[2];
        } else if ("playlist".equals(parts[1])) {
            spotifyUri.playlistId = parts[2];
        } else {
            throw new SpotifyUriException("Unknown field: " + parts[1]);
        }
        return spotifyUri;
    }
}

