/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.ChunkTagHandlerAdapter2;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingEvaluation;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.chunk.ConfidenceChunker;
import com.aliasi.chunk.NBestChunker;
import com.aliasi.classify.ScoredPrecisionRecallEvaluation;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.util.ObjectToCounterMap;
import com.aliasi.util.ScoredObject;
import com.aliasi.util.Strings;
import java.util.Formatter;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;

public class ChunkerEvaluator
implements ObjectHandler<Chunking> {
    private Chunker mChunker;
    private boolean mVerbose = false;
    private final ChunkingEvaluation mChunkingEvaluation;
    private final ObjectToCounterMap<Integer> mCorrectRanks = new ObjectToCounterMap();
    private final ScoredPrecisionRecallEvaluation mConfEval = new ScoredPrecisionRecallEvaluation();
    int mMaxNBest = 64;
    int mMaxNBestPrint = 8;
    String mLastNBestCase = null;
    int mConfMaxChunks = 128;
    String mLastConfidenceCase = null;

    public ChunkerEvaluator(Chunker chunker) {
        this.mChunker = chunker;
        this.mChunkingEvaluation = new ChunkingEvaluation();
    }

    public Chunker chunker() {
        return this.mChunker;
    }

    public void setChunker(Chunker chunker) {
        this.mChunker = chunker;
    }

    public void setVerbose(boolean isVerbose) {
        this.mVerbose = isVerbose;
    }

    public String lastFirstBestCaseReport() {
        return this.mChunkingEvaluation.mLastCase;
    }

    public void setMaxConfidenceChunks(int n) {
        this.mConfMaxChunks = n;
    }

    public String lastConfidenceCaseReport() {
        return this.mLastConfidenceCase;
    }

    public void setMaxNBest(int n) {
        this.mMaxNBest = n;
    }

    public void setMaxNBestReport(int n) {
        this.mMaxNBestPrint = n;
    }

    public String lastNBestCaseReport() {
        return this.mLastNBestCase;
    }

    void handle(String[] tokens, String[] whitespaces, String[] tags) {
        ChunkTagHandlerAdapter2 adapter = new ChunkTagHandlerAdapter2(this);
        adapter.handle(tokens, whitespaces, tags);
    }

    @Override
    public void handle(Chunking referenceChunking) {
        StringBuilder sb;
        char[] cs;
        CharSequence cSeq = referenceChunking.charSequence();
        Chunking firstBestChunking = this.mChunker.chunk(cSeq);
        if (firstBestChunking == null) {
            firstBestChunking = new ChunkingImpl(cSeq);
        }
        this.mChunkingEvaluation.addCase(referenceChunking, firstBestChunking);
        if (this.mChunker instanceof NBestChunker) {
            NBestChunker nBestChunker = (NBestChunker)this.mChunker;
            cs = Strings.toCharArray(cSeq);
            sb = new StringBuilder();
            sb.append(ChunkingEvaluation.formatHeader(13, referenceChunking));
            sb.append(" REF                 " + ChunkingEvaluation.formatChunks(referenceChunking));
            double score = Double.NEGATIVE_INFINITY;
            int foundRank = -1;
            int i = 0;
            Iterator<ScoredObject<Chunking>> nBestIt = nBestChunker.nBest(cs, 0, cs.length, this.mMaxNBest);
            Formatter formatter = new Formatter(sb, Locale.US);
            for (i = 0; i < this.mMaxNBest && nBestIt.hasNext(); ++i) {
                ScoredObject<Chunking> so = nBestIt.next();
                score = so.score();
                Chunking responseChunking = so.getObject();
                if (i < this.mMaxNBestPrint) {
                    formatter.format("%9d", i);
                    sb.append(" ");
                    formatter.format("%10.3f", score);
                    sb.append(" ");
                    sb.append(ChunkingEvaluation.formatChunks(responseChunking));
                }
                if (!responseChunking.equals(referenceChunking)) continue;
                sb.append("  -----------\n");
                foundRank = i;
            }
            if (foundRank < 0) {
                sb.append("Correct Rank >=" + this.mMaxNBest + "\n\n");
            } else {
                sb.append("Correct Rank=" + foundRank + "\n\n");
            }
            this.mCorrectRanks.increment(foundRank);
            this.mLastNBestCase = sb.toString();
        }
        if (this.mChunker instanceof ConfidenceChunker) {
            ConfidenceChunker confChunker = (ConfidenceChunker)((Object)this.mChunker);
            cs = Strings.toCharArray(cSeq);
            sb = new StringBuilder();
            HashSet<Chunk> refChunks = new HashSet<Chunk>();
            for (Chunk nextChunk : referenceChunking.chunkSet()) {
                Chunk zeroChunk = ChunkerEvaluator.toUnscoredChunk(nextChunk);
                refChunks.add(zeroChunk);
            }
            sb.append(ChunkingEvaluation.formatHeader(5, referenceChunking));
            Iterator<Chunk> nBestChunkIt = confChunker.nBestChunks(cs, 0, cs.length, this.mConfMaxChunks);
            boolean count = false;
            int missCount = refChunks.size();
            while (nBestChunkIt.hasNext()) {
                Chunk nextChunk = nBestChunkIt.next();
                double score = nextChunk.score();
                Chunk zeroedChunk = ChunkerEvaluator.toUnscoredChunk(nextChunk);
                boolean correct = refChunks.contains(zeroedChunk);
                if (correct) {
                    --missCount;
                }
                sb.append((correct ? "TRUE " : "false") + " (" + nextChunk.start() + ", " + nextChunk.end() + "): " + nextChunk.type() + "  " + nextChunk.score() + "\n");
                this.mConfEval.addCase(correct, score);
            }
            this.mConfEval.addMisses(missCount);
            this.mLastConfidenceCase = sb.toString();
        }
        this.report();
    }

    void report() {
        if (!this.mVerbose) {
            return;
        }
        System.out.println(this.mChunkingEvaluation.mLastCase);
        if (this.mChunker instanceof NBestChunker) {
            System.out.println(this.mLastNBestCase);
        }
        if (this.mChunker instanceof ConfidenceChunker) {
            System.out.println(this.mLastConfidenceCase);
        }
    }

    public ScoredPrecisionRecallEvaluation confidenceEvaluation() {
        return this.mConfEval;
    }

    public ChunkingEvaluation evaluation() {
        return this.mChunkingEvaluation;
    }

    public ObjectToCounterMap<Integer> nBestEvaluation() {
        return this.mCorrectRanks;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("FIRST-BEST EVAL\n");
        sb.append(this.evaluation().toString());
        if (this.mChunker instanceof NBestChunker) {
            sb.append("\n\nN-BEST EVAL (rank=count)\n");
            sb.append(this.nBestEvaluation().toString());
        }
        if (this.mChunker instanceof ConfidenceChunker) {
            sb.append("\n\nCONFIDENCE EVALUATION");
            sb.append(this.confidenceEvaluation().toString());
        }
        return sb.toString();
    }

    static Chunk toUnscoredChunk(Chunk c) {
        return ChunkFactory.createChunk(c.start(), c.end(), c.type());
    }
}

