/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.Chunking;
import com.aliasi.util.Iterators;
import com.aliasi.util.Strings;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.Set;

public class ChunkingImpl
implements Chunking,
Iterable<Chunk> {
    private final String mString;
    private final Set<Chunk> mChunkSet = new LinkedHashSet<Chunk>();
    static final Chunk[] EMPTY_CHUNK_ARRAY = new Chunk[0];

    public ChunkingImpl(CharSequence cSeq) {
        this.mString = cSeq.toString();
    }

    public ChunkingImpl(char[] cs, int start, int end) {
        this(new String(cs, start, end - start));
    }

    public void addAll(Collection<Chunk> chunks) {
        for (Chunk next : chunks) {
            this.add(next);
        }
    }

    @Override
    public Iterator<Chunk> iterator() {
        return Iterators.unmodifiable(this.chunkSet().iterator());
    }

    public void add(Chunk chunk) {
        if (chunk.end() > this.mString.length()) {
            String msg = "End point of chunk beyond end of char sequence.Char sequence length=" + this.mString.length() + " chunk.end()=" + chunk.end();
            throw new IllegalArgumentException(msg);
        }
        this.mChunkSet.add(chunk);
    }

    @Override
    public CharSequence charSequence() {
        return this.mString;
    }

    @Override
    public Set<Chunk> chunkSet() {
        return Collections.unmodifiableSet(this.mChunkSet);
    }

    @Override
    public boolean equals(Object that) {
        return that instanceof Chunking ? ChunkingImpl.equal(this, (Chunking)that) : false;
    }

    @Override
    public int hashCode() {
        return ChunkingImpl.hashCode(this);
    }

    public String toString() {
        return this.charSequence() + " : " + this.chunkSet();
    }

    public static boolean equal(Chunking chunking1, Chunking chunking2) {
        return Strings.equalCharSequence(chunking1.charSequence(), chunking2.charSequence()) && chunking1.chunkSet().equals(chunking2.chunkSet());
    }

    public static int hashCode(Chunking chunking) {
        return Strings.hashCode(chunking.charSequence()) + 31 * chunking.chunkSet().hashCode();
    }

    public static boolean overlap(Chunk chunk1, Chunk chunk2) {
        return ChunkingImpl.overlapOneWay(chunk1, chunk2) || ChunkingImpl.overlapOneWay(chunk2, chunk1);
    }

    public static Chunking merge(Chunking chunking1, Chunking chunking2) {
        if (!Strings.equalCharSequence(chunking1.charSequence(), chunking2.charSequence())) {
            String msg = "Chunkings must be over same character sequence. Found chunking1.charSequence()=" + chunking1.charSequence() + " chunking2.charSequence()=" + chunking2.charSequence();
            throw new IllegalArgumentException(msg);
        }
        ChunkingImpl chunking = new ChunkingImpl(chunking1.charSequence().toString());
        Chunk[] chunks1 = ChunkingImpl.sortedChunks(chunking1);
        Chunk[] chunks2 = ChunkingImpl.sortedChunks(chunking2);
        int pos1 = 0;
        Chunk lastChunk = null;
        for (int pos2 = 0; pos2 < chunks2.length; ++pos2) {
            while (ChunkingImpl.isBefore(chunks1, pos1, chunks2, pos2) || ChunkingImpl.overlap(chunks1, pos1, lastChunk)) {
                if (!ChunkingImpl.overlap(chunks1, pos1, lastChunk)) {
                    lastChunk = chunks1[pos1];
                    chunking.add(lastChunk);
                }
                ++pos1;
            }
            if (pos1 < chunks1.length && ChunkingImpl.overlap(chunks1[pos1], chunks2[pos2]) || ChunkingImpl.overlap(chunks2, pos2, lastChunk)) continue;
            lastChunk = chunks2[pos2];
            chunking.add(lastChunk);
        }
        while (pos1 < chunks1.length) {
            if (!ChunkingImpl.overlap(chunks1, pos1, lastChunk)) {
                lastChunk = chunks1[pos1];
                chunking.add(lastChunk);
            }
            ++pos1;
        }
        return chunking;
    }

    static boolean overlap(Chunk[] chunks, int pos, Chunk lastChunk) {
        return lastChunk != null && pos < chunks.length && ChunkingImpl.overlap(chunks[pos], lastChunk);
    }

    static boolean isBefore(Chunk[] chunks1, int pos1, Chunk[] chunks2, int pos2) {
        return pos1 < chunks1.length && chunks1[pos1].end() <= chunks2[pos2].start();
    }

    static boolean overlapOneWay(Chunk chunk1, Chunk chunk2) {
        return chunk1.start() <= chunk2.start() && chunk2.start() < chunk1.end();
    }

    static final Chunk[] sortedChunks(Chunking chunking) {
        Set<Chunk> chunkSet = chunking.chunkSet();
        Chunk[] chunks = chunkSet.toArray(EMPTY_CHUNK_ARRAY);
        Arrays.sort(chunks, Chunk.TEXT_ORDER_COMPARATOR);
        return chunks;
    }
}

