/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.chunk;

import com.aliasi.chunk.AbstractTagChunkCodec;
import com.aliasi.chunk.BioTagChunkCodec;
import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.tag.StringTagging;
import com.aliasi.tag.TagLattice;
import com.aliasi.tag.Tagging;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class IoTagChunkCodec
extends AbstractTagChunkCodec
implements Serializable {
    static final long serialVersionUID = 3871326314223465927L;
    final BioTagChunkCodec mBioCodec;

    public IoTagChunkCodec() {
        this(null, false);
    }

    public IoTagChunkCodec(TokenizerFactory tokenizerFactory, boolean enforceConsistency) {
        super(tokenizerFactory, enforceConsistency);
        this.mBioCodec = new BioTagChunkCodec(tokenizerFactory, enforceConsistency);
    }

    @Override
    boolean isEncodable(Chunking chunking, StringBuilder sb) {
        if (!this.mBioCodec.isEncodable(chunking, sb)) {
            return false;
        }
        Tagging<String> tagging = this.mBioCodec.toTagging(chunking);
        String lastTag = "O";
        for (String tag : tagging.tags()) {
            if (this.startSameType(lastTag, tag)) {
                if (sb != null) {
                    sb.append("Two consectuive chunks of type " + tag.substring(2));
                }
                return false;
            }
            lastTag = tag;
        }
        return true;
    }

    boolean startSameType(String lastTag, String tag) {
        return tag.startsWith("B_") && !"O".equals(lastTag) && lastTag.substring(2).equals(tag.substring(2));
    }

    @Override
    public Set<String> tagSet(Set<String> chunkTypes) {
        HashSet<String> tagSet = new HashSet<String>();
        tagSet.addAll(chunkTypes);
        tagSet.add("O");
        return tagSet;
    }

    @Override
    public boolean legalTagSubSequence(String ... tags) {
        return true;
    }

    @Override
    public boolean legalTags(String ... tags) {
        return true;
    }

    @Override
    public Chunking toChunking(StringTagging tagging) {
        this.enforceConsistency(tagging);
        ChunkingImpl chunking = new ChunkingImpl(tagging.characters());
        for (int n = 0; n < tagging.size(); ++n) {
            String tag = tagging.tag(n);
            if ("O".equals(tag)) continue;
            String type = tag;
            int start = tagging.tokenStart(n);
            while (n + 1 < tagging.size() && tagging.tag(n + 1).equals(type)) {
                ++n;
            }
            int end = tagging.tokenEnd(n);
            Chunk chunk = ChunkFactory.createChunk(start, end, type);
            chunking.add(chunk);
        }
        return chunking;
    }

    @Override
    public StringTagging toStringTagging(Chunking chunking) {
        if (this.mTokenizerFactory == null) {
            String msg = "Tokenizer factory must be non-null to convert chunking to tagging.";
            throw new UnsupportedOperationException(msg);
        }
        this.enforceConsistency(chunking);
        ArrayList<String> tokenList = new ArrayList<String>();
        ArrayList<String> tagList = new ArrayList<String>();
        ArrayList<Integer> tokenStartList = new ArrayList<Integer>();
        ArrayList<Integer> tokenEndList = new ArrayList<Integer>();
        this.mBioCodec.toTagging(chunking, tokenList, tagList, tokenStartList, tokenEndList);
        IoTagChunkCodec.transformTags(tagList);
        StringTagging tagging = new StringTagging(tokenList, tagList, chunking.charSequence(), tokenStartList, tokenEndList);
        return tagging;
    }

    @Override
    public Tagging<String> toTagging(Chunking chunking) {
        if (this.mTokenizerFactory == null) {
            String msg = "Tokenizer factory must be non-null to convert chunking to tagging.";
            throw new UnsupportedOperationException(msg);
        }
        this.enforceConsistency(chunking);
        ArrayList<String> tokens = new ArrayList<String>();
        ArrayList<String> tags = new ArrayList<String>();
        this.mBioCodec.toTagging(chunking, tokens, tags, null, null);
        IoTagChunkCodec.transformTags(tags);
        return new Tagging<String>(tokens, tags);
    }

    @Override
    public Iterator<Chunk> nBestChunks(TagLattice<String> lattice, int[] tokenStarts, int[] tokenEnds, int maxResults) {
        throw new UnsupportedOperationException("no n-best chunks yet for IO encodings");
    }

    public String toString() {
        return "IoTagChunkCodec";
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static void transformTags(List<String> tagList) {
        for (int i = 0; i < tagList.size(); ++i) {
            String tag = tagList.get(i);
            if ("O".equals(tag)) continue;
            String transformedTag = tag.substring(2);
            tagList.set(i, transformedTag);
        }
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = -3559983129637286794L;
        private final IoTagChunkCodec mCodec;

        public Serializer() {
            this(null);
        }

        public Serializer(IoTagChunkCodec codec) {
            this.mCodec = codec;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeBoolean(this.mCodec.mEnforceConsistency);
            out.writeObject(this.mCodec.mTokenizerFactory != null ? this.mCodec.mTokenizerFactory : Boolean.FALSE);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            boolean enforceConsistency = in.readBoolean();
            Object tfObj = in.readObject();
            TokenizerFactory tf = tfObj instanceof TokenizerFactory ? (TokenizerFactory)tfObj : null;
            return new IoTagChunkCodec(tf, enforceConsistency);
        }
    }
}

