/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.classify;

import com.aliasi.stats.Statistics;
import java.util.Set;

public class PrecisionRecallEvaluation {
    private long mTP;
    private long mFP;
    private long mTN;
    private long mFN;

    public PrecisionRecallEvaluation() {
        this(0L, 0L, 0L, 0L);
    }

    public PrecisionRecallEvaluation(long tp, long fn, long fp, long tn) {
        PrecisionRecallEvaluation.validateCount("tp", tp);
        PrecisionRecallEvaluation.validateCount("fp", fp);
        PrecisionRecallEvaluation.validateCount("tn", tn);
        PrecisionRecallEvaluation.validateCount("fn", fn);
        this.mTP = tp;
        this.mFP = fp;
        this.mTN = tn;
        this.mFN = fn;
    }

    public void addCase(boolean reference, boolean response) {
        if (reference && response) {
            ++this.mTP;
        } else if (reference && !response) {
            ++this.mFN;
        } else if (!reference && response) {
            ++this.mFP;
        } else {
            ++this.mTN;
        }
    }

    void addCase(boolean reference, boolean response, int count) {
        if (reference && response) {
            this.mTP += (long)count;
        } else if (reference && !response) {
            this.mFN += (long)count;
        } else if (!reference && response) {
            this.mFP += (long)count;
        } else {
            this.mTN += (long)count;
        }
    }

    public <T> void addCases(Set<T> referencePositives, Set<T> responsePositives) {
        for (T t : referencePositives) {
            if (responsePositives.contains(t)) {
                ++this.mTP;
                continue;
            }
            ++this.mFN;
        }
        for (T t : responsePositives) {
            if (referencePositives.contains(t)) continue;
            ++this.mFP;
        }
    }

    public long truePositive() {
        return this.mTP;
    }

    public long falsePositive() {
        return this.mFP;
    }

    public long trueNegative() {
        return this.mTN;
    }

    public long falseNegative() {
        return this.mFN;
    }

    public long positiveReference() {
        return this.truePositive() + this.falseNegative();
    }

    public long negativeReference() {
        return this.trueNegative() + this.falsePositive();
    }

    public double referenceLikelihood() {
        return PrecisionRecallEvaluation.div(this.positiveReference(), this.total());
    }

    public long positiveResponse() {
        return this.truePositive() + this.falsePositive();
    }

    public long negativeResponse() {
        return this.trueNegative() + this.falseNegative();
    }

    public double responseLikelihood() {
        return PrecisionRecallEvaluation.div(this.positiveResponse(), this.total());
    }

    public long correctResponse() {
        return this.truePositive() + this.trueNegative();
    }

    public long incorrectResponse() {
        return this.falsePositive() + this.falseNegative();
    }

    public long total() {
        return this.mTP + this.mFP + this.mTN + this.mFN;
    }

    public double accuracy() {
        return PrecisionRecallEvaluation.div(this.correctResponse(), this.total());
    }

    public double recall() {
        return PrecisionRecallEvaluation.div(this.truePositive(), this.positiveReference());
    }

    public double precision() {
        return PrecisionRecallEvaluation.div(this.truePositive(), this.positiveResponse());
    }

    public double rejectionRecall() {
        return PrecisionRecallEvaluation.div(this.trueNegative(), this.negativeReference());
    }

    public double rejectionPrecision() {
        return PrecisionRecallEvaluation.div(this.trueNegative(), this.negativeResponse());
    }

    public double fMeasure() {
        return this.fMeasure(1.0);
    }

    public double fMeasure(double beta) {
        return PrecisionRecallEvaluation.fMeasure(beta, this.recall(), this.precision());
    }

    public double jaccardCoefficient() {
        return PrecisionRecallEvaluation.div(this.truePositive(), this.truePositive() + this.falseNegative() + this.falsePositive());
    }

    public double chiSquared() {
        double tp = this.truePositive();
        double tn = this.trueNegative();
        double fp = this.falsePositive();
        double fn = this.falseNegative();
        double tot = this.total();
        double diff = tp * tn - fp * fn;
        return tot * diff * diff / ((tp + fn) * (fp + tn) * (tp + fp) * (fn + tn));
    }

    public double phiSquared() {
        return this.chiSquared() / (double)this.total();
    }

    public double yulesQ() {
        double tp = this.truePositive();
        double tn = this.trueNegative();
        double fp = this.falsePositive();
        double fn = this.falseNegative();
        return (tp * tn - fp * fn) / (tp * tn + fp * fn);
    }

    public double yulesY() {
        double tp = this.truePositive();
        double tn = this.trueNegative();
        double fp = this.falsePositive();
        double fn = this.falseNegative();
        return (Math.sqrt(tp * tn) - Math.sqrt(fp * fn)) / (Math.sqrt(tp * tn) + Math.sqrt(fp * fn));
    }

    public double fowlkesMallows() {
        double tp = this.truePositive();
        return tp / Math.sqrt(this.precision() * this.recall());
    }

    public double accuracyDeviation() {
        double p = this.accuracy();
        double total = this.total();
        double variance = p * (1.0 - p) / total;
        return Math.sqrt(variance);
    }

    public double randomAccuracy() {
        double ref = this.referenceLikelihood();
        double resp = this.responseLikelihood();
        return ref * resp + (1.0 - ref) * (1.0 - resp);
    }

    public double randomAccuracyUnbiased() {
        double avg = (this.referenceLikelihood() + this.responseLikelihood()) / 2.0;
        return avg * avg + (1.0 - avg) * (1.0 - avg);
    }

    public double kappa() {
        return Statistics.kappa(this.accuracy(), this.randomAccuracy());
    }

    public double kappaUnbiased() {
        return Statistics.kappa(this.accuracy(), this.randomAccuracyUnbiased());
    }

    public double kappaNoPrevalence() {
        return 2.0 * this.accuracy() - 1.0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(2048);
        sb.append("  Total=" + this.total() + '\n');
        sb.append("  True Positive=" + this.truePositive() + '\n');
        sb.append("  False Negative=" + this.falseNegative() + '\n');
        sb.append("  False Positive=" + this.falsePositive() + '\n');
        sb.append("  True Negative=" + this.trueNegative() + '\n');
        sb.append("  Positive Reference=" + this.positiveReference() + '\n');
        sb.append("  Positive Response=" + this.positiveResponse() + '\n');
        sb.append("  Negative Reference=" + this.negativeReference() + '\n');
        sb.append("  Negative Response=" + this.negativeResponse() + '\n');
        sb.append("  Accuracy=" + this.accuracy() + '\n');
        sb.append("  Recall=" + this.recall() + '\n');
        sb.append("  Precision=" + this.precision() + '\n');
        sb.append("  Rejection Recall=" + this.rejectionRecall() + '\n');
        sb.append("  Rejection Precision=" + this.rejectionPrecision() + '\n');
        sb.append("  F(1)=" + this.fMeasure(1.0) + '\n');
        sb.append("  Fowlkes-Mallows=" + this.fowlkesMallows() + '\n');
        sb.append("  Jaccard Coefficient=" + this.jaccardCoefficient() + '\n');
        sb.append("  Yule's Q=" + this.yulesQ() + '\n');
        sb.append("  Yule's Y=" + this.yulesY() + '\n');
        sb.append("  Reference Likelihood=" + this.referenceLikelihood() + '\n');
        sb.append("  Response Likelihood=" + this.responseLikelihood() + '\n');
        sb.append("  Random Accuracy=" + this.randomAccuracy() + '\n');
        sb.append("  Random Accuracy Unbiased=" + this.randomAccuracyUnbiased() + '\n');
        sb.append("  kappa=" + this.kappa() + '\n');
        sb.append("  kappa Unbiased=" + this.kappaUnbiased() + '\n');
        sb.append("  kappa No Prevalence=" + this.kappaNoPrevalence() + '\n');
        sb.append("  chi Squared=" + this.chiSquared() + '\n');
        sb.append("  phi Squared=" + this.phiSquared() + '\n');
        sb.append("  Accuracy Deviation=" + this.accuracyDeviation());
        return sb.toString();
    }

    public static double fMeasure(double beta, double recall, double precision) {
        double betaSq = beta * beta;
        return (1.0 + betaSq) * recall * precision / (recall + betaSq * precision);
    }

    private static void validateCount(String countName, long val) {
        if (val < 0L) {
            String msg = "Count must be non-negative. Found " + countName + "=" + val;
            throw new IllegalArgumentException(msg);
        }
    }

    static double div(double x, double y) {
        return x / y;
    }
}

