/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.dict;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.dict.Dictionary;
import com.aliasi.dict.DictionaryEntry;
import com.aliasi.tokenizer.LowerCaseTokenizerFactory;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Scored;
import com.aliasi.util.ScoredObject;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class ExactDictionaryChunker
implements Chunker,
Serializable {
    static final long serialVersionUID = -4380886361370971305L;
    final TrieNode mTrieRootNode;
    final TokenizerFactory mTokenizerFactory;
    final boolean mCaseSensitive;
    boolean mReturnAllMatches;
    int mMaxPhraseLength = 0;
    static final ScoredCat[] EMPTY_SCORED_CATS = new ScoredCat[0];
    static final Chunk[] EMPTY_CHUNK_ARRAY = new Chunk[0];

    public ExactDictionaryChunker(Dictionary<String> dict, TokenizerFactory factory) {
        this(dict, factory, true, true);
    }

    public ExactDictionaryChunker(Dictionary<String> dict, TokenizerFactory factory, boolean returnAllMatches, boolean caseSensitive) {
        this.mTokenizerFactory = factory;
        this.mReturnAllMatches = returnAllMatches;
        this.mCaseSensitive = caseSensitive;
        this.mTrieRootNode = this.compileTrie(dict);
    }

    private ExactDictionaryChunker(TrieNode rootNode, TokenizerFactory tokenizerFactory, boolean caseSensitive, boolean returnAllMatches, int maxPhraseLength) {
        this.mTrieRootNode = rootNode;
        this.mTokenizerFactory = tokenizerFactory;
        this.mCaseSensitive = caseSensitive;
        this.mReturnAllMatches = returnAllMatches;
        this.mMaxPhraseLength = maxPhraseLength;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.mTokenizerFactory;
    }

    public boolean caseSensitive() {
        return this.mCaseSensitive;
    }

    public boolean returnAllMatches() {
        return this.mReturnAllMatches;
    }

    public void setReturnAllMatches(boolean returnAllMatches) {
        this.mReturnAllMatches = returnAllMatches;
    }

    @Override
    public Chunking chunk(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.chunk(cs, 0, cs.length);
    }

    final Tokenizer tokenizer(char[] cs, int start, int end) {
        TokenizerFactory factory = this.mCaseSensitive ? this.mTokenizerFactory : new LowerCaseTokenizerFactory(this.mTokenizerFactory);
        return factory.tokenizer(cs, start, end - start);
    }

    @Override
    public Chunking chunk(char[] cs, int start, int end) {
        String token;
        ChunkingImpl chunking = new ChunkingImpl(cs, start, end);
        if (this.mMaxPhraseLength == 0) {
            return chunking;
        }
        CircularQueueInt queue = new CircularQueueInt(this.mMaxPhraseLength);
        Tokenizer tokenizer = this.tokenizer(cs, start, end);
        TrieNode node = this.mTrieRootNode;
        while ((token = tokenizer.nextToken()) != null) {
            int tokenStartPos = tokenizer.lastTokenStartPosition();
            int tokenEndPos = tokenizer.lastTokenEndPosition();
            queue.enqueue(tokenStartPos);
            while (true) {
                TrieNode daughterNode;
                if ((daughterNode = node.getDaughter(token)) != null) {
                    node = daughterNode;
                    break;
                }
                if (node.mSuffixNode == null) {
                    node = this.mTrieRootNode.getDaughter(token);
                    if (node != null) break;
                    node = this.mTrieRootNode;
                    break;
                }
                node = node.mSuffixNode;
            }
            this.emit(node, queue, tokenEndPos, chunking);
            TrieNode suffixNode = node.mSuffixNodeWithCategory;
            while (suffixNode != null) {
                this.emit(suffixNode, queue, tokenEndPos, chunking);
                suffixNode = suffixNode.mSuffixNodeWithCategory;
            }
        }
        return this.mReturnAllMatches ? chunking : ExactDictionaryChunker.restrictToLongest(chunking);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("ExactDictionaryChunker\n");
        sb.append("Tokenizer factory=" + this.mTokenizerFactory.getClass() + "\n");
        sb.append("(toString) mCaseSensitive=" + this.mCaseSensitive + "\n");
        sb.append("Return all matches=" + this.mReturnAllMatches + "\n\n");
        this.mTrieRootNode.toString(sb, 0);
        return sb.toString();
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    void emit(TrieNode node, CircularQueueInt queue, int end, ChunkingImpl chunking) {
        ScoredCat[] scoredCats = node.mCategories;
        for (int i = 0; i < scoredCats.length; ++i) {
            int start = queue.get(node.depth());
            String type = scoredCats[i].mCat;
            double score = scoredCats[i].mScore;
            Chunk chunk = ChunkFactory.createChunk(start, end, type, score);
            chunking.add(chunk);
        }
    }

    final TrieNode compileTrie(Dictionary<String> dict) {
        TrieNode rootNode = new TrieNode(0);
        for (DictionaryEntry dictionaryEntry : dict) {
            String phrase = dictionaryEntry.phrase();
            char[] cs = phrase.toCharArray();
            Tokenizer tokenizer = this.tokenizer(cs, 0, cs.length);
            int length = rootNode.add(tokenizer, dictionaryEntry);
            if (length <= this.mMaxPhraseLength) continue;
            this.mMaxPhraseLength = length;
        }
        ExactDictionaryChunker.computeSuffixes(rootNode, rootNode, new String[this.mMaxPhraseLength], 0);
        return rootNode;
    }

    static final void computeSuffixes(TrieNode node, TrieNode rootNode, String[] tokens, int length) {
        TrieNode suffixNode;
        int i;
        for (i = 1; i < length; ++i) {
            suffixNode = rootNode.getDaughter(tokens, i, length);
            if (suffixNode == null) continue;
            node.mSuffixNode = suffixNode;
            break;
        }
        for (i = 1; i < length; ++i) {
            suffixNode = rootNode.getDaughter(tokens, i, length);
            if (suffixNode == null || suffixNode.mCategories.length == 0) continue;
            node.mSuffixNodeWithCategory = suffixNode;
            break;
        }
        if (node.mDaughterMap == null) {
            return;
        }
        for (Map.Entry<String, TrieNode> entry : node.mDaughterMap.entrySet()) {
            tokens[length] = entry.getKey().toString();
            TrieNode dtrNode = entry.getValue();
            ExactDictionaryChunker.computeSuffixes(dtrNode, rootNode, tokens, length + 1);
        }
    }

    static Chunking restrictToLongest(Chunking chunking) {
        ChunkingImpl result = new ChunkingImpl(chunking.charSequence());
        Set<Chunk> chunkSet = chunking.chunkSet();
        if (chunkSet.size() == 0) {
            return chunking;
        }
        Chunk[] chunks = chunkSet.toArray(EMPTY_CHUNK_ARRAY);
        Arrays.sort(chunks, Chunk.LONGEST_MATCH_ORDER_COMPARATOR);
        int lastEnd = -1;
        for (int i = 0; i < chunks.length; ++i) {
            if (chunks[i].start() < lastEnd) continue;
            result.add(chunks[i]);
            lastEnd = chunks[i].end();
        }
        return result;
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = 5411870376342457513L;
        private final ExactDictionaryChunker mChunker;

        public Serializer() {
            this(null);
        }

        public Serializer(ExactDictionaryChunker chunker) {
            this.mChunker = chunker;
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            TrieNode rootNode = (TrieNode)in.readObject();
            TokenizerFactory tokenizerFactory = (TokenizerFactory)in.readObject();
            boolean caseSensitive = in.readBoolean();
            boolean returnAllMatches = in.readBoolean();
            int maxPhraseLength = in.readInt();
            return new ExactDictionaryChunker(rootNode, tokenizerFactory, caseSensitive, returnAllMatches, maxPhraseLength);
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mChunker.mTrieRootNode);
            out.writeObject(this.mChunker.mTokenizerFactory);
            out.writeBoolean(this.mChunker.mCaseSensitive);
            out.writeBoolean(this.mChunker.mReturnAllMatches);
            out.writeInt(this.mChunker.mMaxPhraseLength);
        }
    }

    static class CircularQueueInt {
        final int[] mQueue;
        int mNextPos = 0;

        public CircularQueueInt(int size) {
            this.mQueue = new int[size];
            Arrays.fill(this.mQueue, 0);
        }

        public void enqueue(int val) {
            this.mQueue[this.mNextPos] = val;
            if (++this.mNextPos == this.mQueue.length) {
                this.mNextPos = 0;
            }
        }

        public int get(int offset) {
            int pos = this.mNextPos - offset;
            if (pos < 0) {
                pos += this.mQueue.length;
            }
            return this.mQueue[pos];
        }
    }

    static class TrieNode
    implements Serializable {
        static final long serialVersionUID = -6412834366677374806L;
        int mDepth;
        Map<String, TrieNode> mDaughterMap = null;
        ScoredCat[] mCategories = EMPTY_SCORED_CATS;
        TrieNode mSuffixNode;
        TrieNode mSuffixNodeWithCategory;

        TrieNode(int depth) {
            this.mDepth = depth;
        }

        public int depth() {
            return this.mDepth;
        }

        public void addEntry(DictionaryEntry<String> entry) {
            ScoredCat[] newCats = new ScoredCat[this.mCategories.length + 1];
            System.arraycopy(this.mCategories, 0, newCats, 0, this.mCategories.length);
            newCats[newCats.length - 1] = new ScoredCat(entry.category().toString(), entry.score());
            Arrays.sort(newCats, ScoredObject.reverseComparator());
            this.mCategories = newCats;
        }

        public TrieNode getDaughter(String[] tokens, int start, int end) {
            TrieNode node = this;
            for (int i = start; i < end && node != null; node = node.getDaughter(tokens[i]), ++i) {
            }
            return node;
        }

        public TrieNode getDaughter(String token) {
            return this.mDaughterMap == null ? null : this.mDaughterMap.get(token);
        }

        public TrieNode getOrCreateDaughter(String token) {
            TrieNode existingDaughter = this.getDaughter(token);
            if (existingDaughter != null) {
                return existingDaughter;
            }
            TrieNode newDaughter = new TrieNode(this.depth() + 1);
            if (this.mDaughterMap == null) {
                this.mDaughterMap = new HashMap<String, TrieNode>(2);
            }
            this.mDaughterMap.put(token, newDaughter);
            return newDaughter;
        }

        public int add(Tokenizer tokenizer, DictionaryEntry<String> entry) {
            String token;
            TrieNode node = this;
            while ((token = tokenizer.nextToken()) != null) {
                node = node.getOrCreateDaughter(token);
            }
            node.addEntry(entry);
            return node.depth();
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            this.toString(sb, 0);
            return sb.toString();
        }

        String id() {
            return this.mDepth + ":" + Integer.toHexString(this.hashCode());
        }

        void toString(StringBuilder sb, int depth) {
            TrieNode.indent(sb, depth);
            sb.append(this.id());
            for (int i = 0; i < this.mCategories.length; ++i) {
                TrieNode.indent(sb, depth);
                sb.append("cat " + i + "=" + this.mCategories[i]);
            }
            if (this.mSuffixNode != null) {
                TrieNode.indent(sb, depth);
                sb.append("suffixNode=");
                sb.append(this.mSuffixNode.id());
            }
            if (this.mSuffixNodeWithCategory != null) {
                TrieNode.indent(sb, depth);
                sb.append("suffixNodeWithCat=");
                sb.append(this.mSuffixNodeWithCategory.id());
            }
            if (this.mDaughterMap == null) {
                return;
            }
            for (String token : this.mDaughterMap.keySet()) {
                TrieNode.indent(sb, depth);
                sb.append(token);
                this.getDaughter(token).toString(sb, depth + 1);
            }
        }

        Object writeReplace() {
            return new Serializer(this);
        }

        static void indent(StringBuilder sb, int depth) {
            sb.append("\n");
            for (int i = 0; i < depth; ++i) {
                sb.append("  ");
            }
        }

        static class Serializer
        extends AbstractExternalizable {
            static final long serialVersionUID = 4017335190312081213L;
            private final TrieNode mNode;

            public Serializer(TrieNode node) {
                this.mNode = node;
            }

            public Serializer() {
                this(null);
            }

            @Override
            public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
                int numToks;
                TrieNode rootNode = new TrieNode(0);
                int maxPhraseLength = 0;
                while ((numToks = in.readInt()) != -1) {
                    if (numToks > maxPhraseLength) {
                        maxPhraseLength = numToks;
                    }
                    TrieNode node = rootNode;
                    for (int i = 0; i < numToks; ++i) {
                        String tok = in.readUTF();
                        node = node.getOrCreateDaughter(tok);
                    }
                    ArrayList<ScoredCat> scoredCatList = new ArrayList<ScoredCat>();
                    int numCats = in.readInt();
                    for (int i = 0; i < numCats; ++i) {
                        String cat = in.readUTF();
                        double score = in.readDouble();
                        scoredCatList.add(new ScoredCat(cat, score));
                    }
                    ScoredCat[] scoredCats = scoredCatList.toArray(new ScoredCat[0]);
                    Arrays.sort(scoredCats, ScoredObject.reverseComparator());
                    node.mCategories = scoredCats;
                }
                ExactDictionaryChunker.computeSuffixes(rootNode, rootNode, new String[maxPhraseLength], 0);
                return rootNode;
            }

            @Override
            public void writeExternal(ObjectOutput out) throws IOException {
                ArrayList<String> tokenList = new ArrayList<String>();
                this.writeAll(this.mNode, tokenList, 0, out);
                out.writeInt(-1);
            }

            void writeAll(TrieNode node, List<String> tokens, int pos, ObjectOutput out) throws IOException {
                if (node.mCategories.length > 0) {
                    this.writeNode(node.mCategories, tokens, pos, out);
                }
                if (node.mDaughterMap != null) {
                    for (Map.Entry<String, TrieNode> entry : node.mDaughterMap.entrySet()) {
                        if (tokens.size() <= pos) {
                            tokens.add(entry.getKey());
                        } else {
                            tokens.set(pos, entry.getKey());
                        }
                        this.writeAll(entry.getValue(), tokens, pos + 1, out);
                    }
                }
            }

            void writeNode(ScoredCat[] cats, List<String> tokens, int numTokens, ObjectOutput out) throws IOException {
                int i;
                out.writeInt(numTokens);
                for (i = 0; i < numTokens; ++i) {
                    out.writeUTF(tokens.get(i));
                }
                out.writeInt(cats.length);
                for (i = 0; i < cats.length; ++i) {
                    out.writeUTF(cats[i].mCat);
                    out.writeDouble(cats[i].mScore);
                }
            }
        }
    }

    static class ScoredCat
    implements Scored {
        String mCat;
        double mScore;

        ScoredCat(String cat, double score) {
            this.mCat = cat;
            this.mScore = score;
        }

        @Override
        public double score() {
            return this.mScore;
        }

        public String toString() {
            return this.mCat + ":" + this.mScore;
        }
    }
}

