/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.lm;

import com.aliasi.corpus.ObjectHandler;
import com.aliasi.lm.CompiledTokenizedLM;
import com.aliasi.lm.IntNode;
import com.aliasi.lm.LanguageModel;
import com.aliasi.lm.NGramProcessLM;
import com.aliasi.lm.TrieIntSeqCounter;
import com.aliasi.lm.UniformBoundaryLM;
import com.aliasi.stats.BinomialDistribution;
import com.aliasi.stats.Statistics;
import com.aliasi.symbol.MapSymbolTable;
import com.aliasi.symbol.SymbolTable;
import com.aliasi.tokenizer.Tokenizer;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Arrays;
import com.aliasi.util.BoundedPriorityQueue;
import com.aliasi.util.Exceptions;
import com.aliasi.util.ScoredObject;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.SortedSet;

public class TokenizedLM
implements LanguageModel.Dynamic,
LanguageModel.Sequence,
LanguageModel.Tokenized,
ObjectHandler<CharSequence> {
    private final TokenizerFactory mTokenizerFactory;
    private final MapSymbolTable mSymbolTable;
    private final TrieIntSeqCounter mCounter;
    private final LanguageModel.Sequence mUnknownTokenModel;
    private final LanguageModel.Sequence mWhitespaceModel;
    private final double mLambdaFactor;
    private final LanguageModel.Dynamic mDynamicUnknownTokenModel;
    private final LanguageModel.Dynamic mDynamicWhitespaceModel;
    private final int mNGramOrder;
    public static final int UNKNOWN_TOKEN = -1;
    public static final int BOUNDARY_TOKEN = -2;
    static final ScoredObject[] EMPTY_SCORED_OBJECT_ARRAY = new ScoredObject[0];
    static final ScoredObject<String[]>[] EMPTY_SCORED_OBJECT_STRING_ARRAY_ARRAY = TokenizedLM.emptyScoredObjectArray();

    public TokenizedLM(TokenizerFactory factory, int nGramOrder) {
        this(factory, nGramOrder, new UniformBoundaryLM(), new UniformBoundaryLM(), nGramOrder);
    }

    public TokenizedLM(TokenizerFactory tokenizerFactory, int nGramOrder, LanguageModel.Sequence unknownTokenModel, LanguageModel.Sequence whitespaceModel, double lambdaFactor) {
        this(tokenizerFactory, nGramOrder, unknownTokenModel, whitespaceModel, lambdaFactor, true);
    }

    public TokenizedLM(TokenizerFactory tokenizerFactory, int nGramOrder, LanguageModel.Sequence unknownTokenModel, LanguageModel.Sequence whitespaceModel, double lambdaFactor, boolean initialIncrementBoundary) {
        NGramProcessLM.checkMaxNGram(nGramOrder);
        NGramProcessLM.checkLambdaFactor(lambdaFactor);
        this.mSymbolTable = new MapSymbolTable();
        this.mNGramOrder = nGramOrder;
        this.mTokenizerFactory = tokenizerFactory;
        this.mUnknownTokenModel = unknownTokenModel;
        this.mWhitespaceModel = whitespaceModel;
        this.mDynamicUnknownTokenModel = this.mUnknownTokenModel instanceof LanguageModel.Dynamic ? (LanguageModel.Dynamic)((Object)this.mUnknownTokenModel) : null;
        this.mDynamicWhitespaceModel = this.mWhitespaceModel instanceof LanguageModel.Dynamic ? (LanguageModel.Dynamic)((Object)this.mWhitespaceModel) : null;
        this.mCounter = new TrieIntSeqCounter(nGramOrder);
        this.mLambdaFactor = lambdaFactor;
        if (initialIncrementBoundary) {
            this.mCounter.incrementSubsequences(new int[]{-2}, 0, 1);
        }
    }

    public double lambdaFactor() {
        return this.mLambdaFactor;
    }

    public TrieIntSeqCounter sequenceCounter() {
        return this.mCounter;
    }

    public SymbolTable symbolTable() {
        return this.mSymbolTable;
    }

    public int nGramOrder() {
        return this.mNGramOrder;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.mTokenizerFactory;
    }

    public LanguageModel.Sequence unknownTokenLM() {
        return this.mUnknownTokenModel;
    }

    public LanguageModel.Sequence whitespaceLM() {
        return this.mWhitespaceModel;
    }

    @Override
    public void compileTo(ObjectOutput objOut) throws IOException {
        objOut.writeObject(new Externalizer(this));
    }

    public void handleNGrams(int nGramLength, int minCount, ObjectHandler<String[]> handler) {
        StringArrayAdapter adapter = new StringArrayAdapter(handler);
        this.mCounter.handleNGrams(nGramLength, minCount, adapter);
    }

    double lambda(int[] tokIds) {
        double numExtensionsD = this.mCounter.numExtensions(tokIds, 0, tokIds.length);
        double extCountD = this.mCounter.extensionCount(tokIds, 0, tokIds.length);
        return extCountD / (extCountD + this.mLambdaFactor * numExtensionsD);
    }

    @Override
    public void train(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        this.train(cs, 0, cs.length);
    }

    @Override
    public void train(CharSequence cSeq, int count) {
        if (count < 0) {
            String msg = "Counts must be non-negative. Found count=" + count;
            throw new IllegalArgumentException(msg);
        }
        if (count == 0) {
            return;
        }
        char[] cs = Strings.toCharArray(cSeq);
        this.train(cs, 0, cs.length, count);
    }

    @Override
    public void train(char[] cs, int start, int end) {
        Strings.checkArgsStartEnd(cs, start, end);
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, end - start);
        ArrayList<String> tokenList = new ArrayList<String>();
        while (true) {
            String token;
            if (this.mDynamicWhitespaceModel != null) {
                String whitespace = tokenizer.nextWhitespace();
                this.mDynamicWhitespaceModel.train(whitespace);
            }
            if ((token = tokenizer.nextToken()) == null) break;
            tokenList.add(token);
        }
        int[] tokIds = new int[tokenList.size() + 2];
        tokIds[0] = -2;
        tokIds[tokIds.length - 1] = -2;
        Iterator it = tokenList.iterator();
        int i = 1;
        while (it.hasNext()) {
            String token = (String)it.next();
            if (this.mDynamicUnknownTokenModel != null && this.mSymbolTable.symbolToID(token) < 0) {
                this.mDynamicUnknownTokenModel.train(token);
            }
            tokIds[i] = this.mSymbolTable.getOrAddSymbol(token);
            ++i;
        }
        this.mCounter.incrementSubsequences(tokIds, 0, tokIds.length);
        this.mCounter.decrementUnigram(-2);
    }

    @Override
    public void handle(CharSequence cs) {
        this.train(cs, 1);
    }

    @Override
    public void train(char[] cs, int start, int end, int count) {
        Strings.checkArgsStartEnd(cs, start, end);
        if (count < 0) {
            String msg = "Counts must be non-negative. Found count=" + count;
            throw new IllegalArgumentException(msg);
        }
        if (count == 0) {
            return;
        }
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, end - start);
        ArrayList<String> tokenList = new ArrayList<String>();
        while (true) {
            String token;
            if (this.mDynamicWhitespaceModel != null) {
                String whitespace = tokenizer.nextWhitespace();
                this.mDynamicWhitespaceModel.train(whitespace, count);
            }
            if ((token = tokenizer.nextToken()) == null) break;
            tokenList.add(token);
        }
        int[] tokIds = new int[tokenList.size() + 2];
        tokIds[0] = -2;
        tokIds[tokIds.length - 1] = -2;
        Iterator it = tokenList.iterator();
        int i = 1;
        while (it.hasNext()) {
            String token = (String)it.next();
            if (this.mDynamicUnknownTokenModel != null && this.mSymbolTable.symbolToID(token) < 0) {
                this.mDynamicUnknownTokenModel.train(token, count);
            }
            tokIds[i] = this.mSymbolTable.getOrAddSymbol(token);
            ++i;
        }
        this.mCounter.incrementSubsequences(tokIds, 0, tokIds.length, count);
        this.mCounter.decrementUnigram(-2, count);
    }

    void trainSequence(char[] cs, int start, int end, int count) {
        Strings.checkArgsStartEnd(cs, start, end);
        if (count < 0) {
            String msg = "Count must be non-negative.  Found count=" + count;
            throw new IllegalArgumentException(msg);
        }
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, end - start);
        String[] tokens = tokenizer.tokenize();
        int len = Math.min(tokens.length, this.nGramOrder());
        int offset = tokens.length - len;
        int[] tokIds = new int[len];
        for (int i = 0; i < len; ++i) {
            tokIds[i] = this.mSymbolTable.getOrAddSymbol(tokens[i + offset]);
        }
        this.mCounter.incrementSequence(tokIds, 0, len, count);
    }

    public void trainSequence(CharSequence cSeq, int count) {
        char[] cs = Strings.toCharArray(cSeq);
        this.trainSequence(cs, 0, cs.length, count);
    }

    @Override
    public double log2Estimate(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.log2Estimate(cs, 0, cs.length);
    }

    @Override
    public double log2Estimate(char[] cs, int start, int end) {
        Strings.checkArgsStartEnd(cs, start, end);
        double logEstimate = 0.0;
        Tokenizer tokenizer = this.mTokenizerFactory.tokenizer(cs, start, end - start);
        ArrayList<String> tokenList = new ArrayList<String>();
        while (true) {
            String whitespace = tokenizer.nextWhitespace();
            logEstimate += this.mWhitespaceModel.log2Estimate(whitespace);
            String token = tokenizer.nextToken();
            if (token == null) break;
            tokenList.add(token);
        }
        int[] tokIds = new int[tokenList.size() + 2];
        tokIds[0] = -2;
        tokIds[tokIds.length - 1] = -2;
        Iterator it = tokenList.iterator();
        int i = 1;
        while (it.hasNext()) {
            String token = (String)it.next();
            tokIds[i] = this.mSymbolTable.symbolToID(token);
            if (tokIds[i] < 0) {
                logEstimate += this.mUnknownTokenModel.log2Estimate(token);
            }
            ++i;
        }
        for (i = 2; i <= tokIds.length; ++i) {
            logEstimate += this.conditionalLog2TokenEstimate(tokIds, 0, i);
        }
        return logEstimate;
    }

    String[] nGramToTokens(int[] nGram) {
        String[] toks = new String[nGram.length];
        for (int i = 0; i < nGram.length; ++i) {
            toks[i] = nGram[i] >= 0 ? this.mSymbolTable.idToSymbol(nGram[i]) : (i == 0 ? "*BEGIN*" : "*END*");
        }
        return toks;
    }

    @Override
    public double tokenProbability(String[] tokens, int start, int end) {
        return Math.pow(2.0, this.tokenLog2Probability(tokens, start, end));
    }

    public double tokenLog2ProbCharSmooth(String[] tokens, int start, int end) {
        double logEstimate = 0.0;
        ArrayList<String> tokenList = new ArrayList<String>();
        for (int i = start; i < end; ++i) {
            tokenList.add(tokens[i]);
        }
        int[] tokIds = new int[tokenList.size() + 2];
        tokIds[0] = -2;
        tokIds[tokIds.length - 1] = -2;
        Iterator it = tokenList.iterator();
        int i = 1;
        while (it.hasNext()) {
            String token = (String)it.next();
            tokIds[i] = this.mSymbolTable.symbolToID(token);
            if (tokIds[i] < 0) {
                logEstimate += this.mUnknownTokenModel.log2Estimate(token);
            }
            ++i;
        }
        for (i = 2; i <= tokIds.length; ++i) {
            logEstimate += this.conditionalLog2TokenEstimate(tokIds, 0, i);
        }
        return logEstimate;
    }

    public double tokenProbCharSmooth(String[] tokens, int start, int end) {
        return Math.pow(2.0, this.tokenLog2ProbCharSmooth(tokens, start, end));
    }

    public double tokenLog2ProbCharSmoothNoBounds(String[] tokens, int start, int end) {
        int i;
        if (start >= end) {
            return 0.0;
        }
        double logEstimate = 0.0;
        int[] tokIds = new int[end - start];
        for (i = start; i < end; ++i) {
            tokIds[i] = this.mSymbolTable.symbolToID(tokens[i]);
            if (tokIds[i] >= 0) continue;
            logEstimate += this.mUnknownTokenModel.log2Estimate(tokens[i]);
        }
        for (i = 0; i < tokIds.length; ++i) {
            logEstimate += this.conditionalLog2TokenEstimate(tokIds, 0, i + 1);
        }
        return logEstimate;
    }

    public double tokenProbCharSmoothNoBounds(String[] tokens, int start, int end) {
        return Math.pow(2.0, this.tokenLog2ProbCharSmoothNoBounds(tokens, start, end));
    }

    @Override
    public double tokenLog2Probability(String[] tokens, int start, int end) {
        double log2Estimate = 0.0;
        int[] tokIds = new int[tokens.length];
        for (int i = start; i < end; ++i) {
            tokIds[i] = this.mSymbolTable.symbolToID(tokens[i]);
            double conditionalLog2TokenEstimate = this.conditionalLog2TokenEstimate(tokIds, 0, i + 1);
            if (Double.isInfinite(conditionalLog2TokenEstimate)) {
                double extCountD = this.mCounter.extensionCount(new int[0], 0, 0);
                double numTokensD = this.mSymbolTable.numSymbols();
                log2Estimate += com.aliasi.util.Math.log2(extCountD / (extCountD + numTokensD));
                log2Estimate += this.mUnknownTokenModel.log2Estimate(tokens[i]);
            } else {
                log2Estimate += conditionalLog2TokenEstimate;
            }
            if (!Double.isInfinite(log2Estimate)) continue;
            System.out.println("tokens[" + i + "]=" + tokens[i] + "\n     id=" + tokIds[i]);
        }
        return log2Estimate;
    }

    public double processLog2Probability(String[] tokens) {
        return this.tokenLog2Probability(tokens, 0, tokens.length);
    }

    public SortedSet<ScoredObject<String[]>> collocationSet(int nGram, int minCount, int maxReturned) {
        CollocationCollector collector = new CollocationCollector(maxReturned);
        this.mCounter.handleNGrams(nGram, minCount, collector);
        return collector.nGramSet();
    }

    public SortedSet<ScoredObject<String[]>> newTermSet(int nGram, int minCount, int maxReturned, LanguageModel.Tokenized backgroundLM) {
        return this.sigTermSet(nGram, minCount, maxReturned, backgroundLM, false);
    }

    public SortedSet<ScoredObject<String[]>> oldTermSet(int nGram, int minCount, int maxReturned, LanguageModel.Tokenized backgroundLM) {
        return this.sigTermSet(nGram, minCount, maxReturned, backgroundLM, true);
    }

    private ScoredObject<String[]>[] sigTerms(int nGram, int minCount, int maxReturned, LanguageModel.Tokenized backgroundLM, boolean reverse) {
        SigTermCollector collector = new SigTermCollector(maxReturned, backgroundLM, reverse);
        this.mCounter.handleNGrams(nGram, minCount, collector);
        return collector.nGrams();
    }

    private SortedSet<ScoredObject<String[]>> sigTermSet(int nGram, int minCount, int maxReturned, LanguageModel.Tokenized backgroundLM, boolean reverse) {
        SigTermCollector collector = new SigTermCollector(maxReturned, backgroundLM, reverse);
        this.mCounter.handleNGrams(nGram, minCount, collector);
        return collector.nGramSet();
    }

    public SortedSet<ScoredObject<String[]>> frequentTermSet(int nGram, int maxReturned) {
        return this.freqTermSet(nGram, maxReturned, false);
    }

    private ScoredObject<String[]>[] freqTerms(int nGram, int maxReturned, boolean reverse) {
        FreqTermCollector collector = new FreqTermCollector(maxReturned, reverse);
        this.mCounter.handleNGrams(nGram, 1, collector);
        return collector.nGrams();
    }

    private SortedSet<ScoredObject<String[]>> freqTermSet(int nGram, int maxReturned, boolean reverse) {
        FreqTermCollector collector = new FreqTermCollector(maxReturned, reverse);
        this.mCounter.handleNGrams(nGram, 1, collector);
        return collector.nGramSet();
    }

    public SortedSet<ScoredObject<String[]>> infrequentTermSet(int nGram, int maxReturned) {
        return this.freqTermSet(nGram, maxReturned, true);
    }

    public double chiSquaredIndependence(int[] nGram) {
        if (nGram.length < 2) {
            String msg = "Require n-gram >= 2 for chi square independence. Found nGram length=" + nGram.length;
            throw new IllegalArgumentException(msg);
        }
        if (nGram.length == 2) {
            return this.chiSquaredSplit(nGram, 1);
        }
        double bestScore = Double.NEGATIVE_INFINITY;
        int mid = 1;
        while (mid + 1 < nGram.length) {
            bestScore = Math.max(bestScore, this.chiSquaredSplit(nGram, mid));
            ++mid;
        }
        return bestScore;
    }

    public double z(int[] nGram, int nGramSampleCount, int totalSampleCount) {
        double totalCount = this.mCounter.count(nGram, 0, 0);
        double nGramCount = this.mCounter.count(nGram, 0, nGram.length);
        double successProbability = nGramCount / totalCount;
        return BinomialDistribution.z(successProbability, nGramSampleCount, totalSampleCount);
    }

    public String toString() {
        return this.mCounter.mRootNode.toString(this.mSymbolTable);
    }

    private double conditionalLog2TokenEstimate(int[] tokIds, int start, int end) {
        int numExtensions;
        if (end < 1) {
            return 0.0;
        }
        int maxLength = this.mCounter.maxLength();
        int contextEnd = end - 1;
        double estimate = tokIds[end - 1] == -1 ? 1.0 : 0.0;
        for (int contextStart = end - 1; contextStart >= start && end - contextStart <= maxLength && (numExtensions = this.mCounter.numExtensions(tokIds, contextStart, contextEnd)) != 0; --contextStart) {
            int count;
            double extCountD = this.mCounter.extensionCount(tokIds, contextStart, contextEnd);
            double lambda = extCountD / (extCountD + this.mLambdaFactor * (double)numExtensions);
            estimate *= 1.0 - lambda;
            if (tokIds[end - 1] == -1 || (count = this.mCounter.count(tokIds, contextStart, end)) <= 0) continue;
            estimate += lambda * (double)count / extCountD;
        }
        return com.aliasi.util.Math.log2(estimate);
    }

    private double chiSquaredSplit(int[] pair, int mid) {
        long count12 = this.mCounter.count(pair, 0, pair.length);
        long count1_ = this.mCounter.count(pair, 0, mid);
        long count_2 = this.mCounter.count(pair, mid, pair.length);
        long n = this.mCounter.extensionCount(pair, 0, 0);
        long countxy = n - count1_ - count_2 + count12;
        long countx2 = count_2 - count12;
        long count1y = count1_ - count12;
        return Statistics.chiSquaredIndependence(count12, count1y, countx2, countxy);
    }

    private int lastInternalNodeIndex() {
        int last = 1;
        LinkedList<IntNode> queue = new LinkedList<IntNode>();
        queue.add(this.mCounter.mRootNode);
        int i = 1;
        while (!queue.isEmpty()) {
            IntNode node = (IntNode)queue.removeFirst();
            if (node.numExtensions() > 0) {
                last = i;
            }
            node.addDaughters(queue);
            ++i;
        }
        return last - 1;
    }

    private static int[] concatenate(int[] is, int i) {
        int[] result = new int[is.length + 1];
        System.arraycopy(is, 0, result, 0, is.length);
        result[is.length] = i;
        return result;
    }

    static ScoredObject<String[]>[] emptyScoredObjectArray() {
        ScoredObject[] result = EMPTY_SCORED_OBJECT_ARRAY;
        return result;
    }

    static class Externalizer
    extends AbstractExternalizable {
        private static final long serialVersionUID = 6135272620545804504L;
        final TokenizedLM mLM;

        public Externalizer() {
            this(null);
        }

        public Externalizer(TokenizedLM lm) {
            this.mLM = lm;
        }

        @Override
        public Object read(ObjectInput in) throws IOException {
            try {
                return new CompiledTokenizedLM(in);
            }
            catch (ClassNotFoundException e) {
                throw Exceptions.toIO("TokenizedLM.Externalizer.read()", e);
            }
        }

        @Override
        public void writeExternal(ObjectOutput objOut) throws IOException {
            int i;
            if (this.mLM.mTokenizerFactory instanceof Serializable) {
                objOut.writeUTF("");
                objOut.writeObject(this.mLM.mTokenizerFactory);
            } else {
                objOut.writeUTF(this.mLM.mTokenizerFactory.getClass().getName());
            }
            objOut.writeObject(this.mLM.mSymbolTable);
            ((LanguageModel.Dynamic)((Object)this.mLM.mUnknownTokenModel)).compileTo(objOut);
            ((LanguageModel.Dynamic)((Object)this.mLM.mWhitespaceModel)).compileTo(objOut);
            objOut.writeInt(this.mLM.mNGramOrder);
            int numNodes = ((TokenizedLM)this.mLM).mCounter.mRootNode.trieSize();
            objOut.writeInt(numNodes);
            int lastInternalNodeIndex = this.mLM.lastInternalNodeIndex();
            objOut.writeInt(lastInternalNodeIndex);
            objOut.writeInt(Integer.MIN_VALUE);
            objOut.writeFloat(Float.NaN);
            objOut.writeFloat((float)com.aliasi.util.Math.log2(1.0 - this.mLM.lambda(Arrays.EMPTY_INT_ARRAY)));
            objOut.writeInt(1);
            LinkedList<int[]> queue = new LinkedList<int[]>();
            int[] outcomes = ((TokenizedLM)this.mLM).mCounter.mRootNode.integersFollowing(Arrays.EMPTY_INT_ARRAY, 0, 0);
            for (i = 0; i < outcomes.length; ++i) {
                queue.add(new int[]{outcomes[i]});
            }
            i = 1;
            while (!queue.isEmpty()) {
                int[] is = (int[])queue.removeFirst();
                objOut.writeInt(is[is.length - 1]);
                objOut.writeFloat((float)this.mLM.conditionalLog2TokenEstimate(is, 0, is.length));
                if (i <= lastInternalNodeIndex) {
                    objOut.writeFloat((float)com.aliasi.util.Math.log2(1.0 - this.mLM.lambda(is)));
                    objOut.writeInt(i + queue.size() + 1);
                }
                int[] followers = ((TokenizedLM)this.mLM).mCounter.mRootNode.integersFollowing(is, 0, is.length);
                for (int j = 0; j < followers.length; ++j) {
                    queue.add(TokenizedLM.concatenate(is, followers[j]));
                }
                ++i;
            }
        }
    }

    class SigTermCollector
    extends Collector {
        final LanguageModel.Tokenized mBGModel;

        SigTermCollector(int maxReturned, LanguageModel.Tokenized bgModel, boolean reverse) {
            super(maxReturned, reverse);
            this.mBGModel = bgModel;
        }

        @Override
        double scoreNGram(int[] nGram) {
            String[] tokens = TokenizedLM.this.nGramToTokens(nGram);
            int totalSampleCount = TokenizedLM.this.mCounter.count(nGram, 0, 0);
            int sampleCount = TokenizedLM.this.mCounter.count(nGram, 0, nGram.length);
            double bgProb = this.mBGModel.tokenProbability(tokens, 0, tokens.length);
            double score = BinomialDistribution.z(bgProb, sampleCount, totalSampleCount);
            return score;
        }
    }

    class CollocationCollector
    extends Collector {
        CollocationCollector(int maxReturned) {
            super(maxReturned, false);
        }

        @Override
        double scoreNGram(int[] nGram) {
            return TokenizedLM.this.chiSquaredIndependence(nGram);
        }
    }

    class FreqTermCollector
    extends Collector {
        FreqTermCollector(int maxReturned, boolean reverse) {
            super(maxReturned, reverse);
        }

        @Override
        double scoreNGram(int[] nGram) {
            return TokenizedLM.this.mCounter.count(nGram, 0, nGram.length);
        }
    }

    abstract class Collector
    implements ObjectHandler<int[]> {
        final BoundedPriorityQueue<ScoredObject<String[]>> mBPQ;

        Collector(int maxReturned, boolean reverse) {
            Comparator comparator = null;
            comparator = reverse ? ScoredObject.reverseComparator() : ScoredObject.comparator();
            this.mBPQ = new BoundedPriorityQueue(comparator, maxReturned);
        }

        SortedSet<ScoredObject<String[]>> nGramSet() {
            return this.mBPQ;
        }

        ScoredObject<String[]>[] nGrams() {
            return this.mBPQ.toArray(EMPTY_SCORED_OBJECT_STRING_ARRAY_ARRAY);
        }

        @Override
        public void handle(int[] nGram) {
            for (int i = 0; i < nGram.length; ++i) {
                if (nGram[i] >= 0) continue;
                return;
            }
            this.mBPQ.offer(new ScoredObject<String[]>(TokenizedLM.this.nGramToTokens(nGram), this.scoreNGram(nGram)));
        }

        abstract double scoreNGram(int[] var1);
    }

    class StringArrayAdapter
    implements ObjectHandler<int[]> {
        ObjectHandler<String[]> mHandler;

        public StringArrayAdapter(ObjectHandler<String[]> handler) {
            this.mHandler = handler;
        }

        @Override
        public void handle(int[] nGram) {
            this.mHandler.handle(this.simpleNGramToTokens(nGram));
        }

        String[] simpleNGramToTokens(int[] nGram) {
            String[] tokens = new String[nGram.length];
            for (int i = 0; i < tokens.length; ++i) {
                tokens[i] = nGram[i] >= 0 ? TokenizedLM.this.mSymbolTable.idToSymbol(nGram[i]) : null;
            }
            return tokens;
        }
    }
}

