/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.sentences;

import com.aliasi.sentences.AbstractSentenceModel;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class HeuristicSentenceModel
extends AbstractSentenceModel {
    Set<String> mPossibleStops;
    Set<String> mBadPrevious;
    Set<String> mBadFollowing;
    private final boolean mForceFinalStop;
    private final boolean mBalanceParens;

    public HeuristicSentenceModel(Set<String> possibleStops, Set<String> impossiblePenultimate, Set<String> impossibleStarts) {
        this(possibleStops, impossiblePenultimate, impossibleStarts, false, false);
    }

    public HeuristicSentenceModel(Set<String> possibleStops, Set<String> impossiblePenultimate, Set<String> impossibleStarts, boolean forceFinalStop, boolean balanceParens) {
        this.mPossibleStops = HeuristicSentenceModel.toLowerCase(possibleStops);
        this.mBadPrevious = HeuristicSentenceModel.toLowerCase(impossiblePenultimate);
        this.mBadFollowing = HeuristicSentenceModel.toLowerCase(impossibleStarts);
        this.mForceFinalStop = forceFinalStop;
        this.mBalanceParens = balanceParens;
    }

    public boolean forceFinalStop() {
        return this.mForceFinalStop;
    }

    public boolean balanceParens() {
        return this.mBalanceParens;
    }

    @Override
    public void boundaryIndices(String[] tokens, String[] whitespaces, int start, int length, Collection<Integer> indices) {
        if (length == 0) {
            return;
        }
        if (length == 1) {
            if (this.mForceFinalStop || this.mPossibleStops.contains(tokens[start].toLowerCase())) {
                indices.add(start);
            }
            return;
        }
        boolean inParens = false;
        if (tokens[start].equals("(")) {
            inParens = true;
        }
        boolean inBrackets = false;
        if (tokens[start].equals("[")) {
            inBrackets = true;
        }
        int end = start + length - 1;
        for (int i = start + 1; i < end; ++i) {
            if (this.mBalanceParens) {
                if (tokens[i].equals("(")) {
                    inParens = true;
                    continue;
                }
                if (tokens[i].equals(")")) {
                    inParens = false;
                    continue;
                }
                if (tokens[i].equals("[")) {
                    inBrackets = true;
                    continue;
                }
                if (tokens[i].equals("]")) {
                    inBrackets = false;
                    continue;
                }
                if (inParens || inBrackets) continue;
            }
            if (!this.mPossibleStops.contains(tokens[i].toLowerCase()) || whitespaces[i + 1].length() == 0 || this.mBadPrevious.contains(tokens[i - 1].toLowerCase()) || this.mBadFollowing.contains(tokens[i + 1].toLowerCase()) || !this.possibleStart(tokens, whitespaces, i + 1, end)) continue;
            indices.add(i);
        }
        if (this.mForceFinalStop || this.mPossibleStops.contains(tokens[end].toLowerCase()) && !this.mBadPrevious.contains(tokens[end - 1].toLowerCase())) {
            indices.add(end);
        }
    }

    protected boolean possibleStart(String[] tokens, String[] whitespaces, int start, int end) {
        String tok = tokens[start];
        return tok.length() > 0 && !Character.isLowerCase(tok.charAt(0));
    }

    static Set<String> toLowerCase(Set<String> xs) {
        HashSet<String> result = new HashSet<String>();
        for (String s : xs) {
            result.add(s.toLowerCase());
        }
        return result;
    }
}

