/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.sentences;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.sentences.SentenceModel;
import com.aliasi.tokenizer.Tokenization;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Strings;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;

public class SentenceChunker
implements Chunker,
Serializable {
    static final long serialVersionUID = 2296001471469838378L;
    private final TokenizerFactory mTokenizerFactory;
    private final SentenceModel mSentenceModel;
    public static final String SENTENCE_CHUNK_TYPE = "S";

    public SentenceChunker(TokenizerFactory tf, SentenceModel sm) {
        this.mTokenizerFactory = tf;
        this.mSentenceModel = sm;
    }

    public TokenizerFactory tokenizerFactory() {
        return this.mTokenizerFactory;
    }

    public SentenceModel sentenceModel() {
        return this.mSentenceModel;
    }

    @Override
    public Chunking chunk(CharSequence cSeq) {
        char[] cs = Strings.toCharArray(cSeq);
        return this.chunk(cs, 0, cs.length);
    }

    @Override
    public Chunking chunk(char[] cs, int start, int end) {
        Tokenization toks = new Tokenization(cs, start, end - start, this.mTokenizerFactory);
        String[] tokens = toks.tokens();
        String[] whitespaces = toks.whitespaces();
        ChunkingImpl chunking = new ChunkingImpl(cs, start, end);
        if (tokens.length == 0) {
            return chunking;
        }
        int[] sentenceBoundaries = this.mSentenceModel.boundaryIndices(tokens, whitespaces);
        if (sentenceBoundaries.length < 1) {
            return chunking;
        }
        int startToken = 0;
        for (int i = 0; i < sentenceBoundaries.length; ++i) {
            int endToken = sentenceBoundaries[i];
            Chunk chunk = ChunkFactory.createChunk(toks.tokenStart(startToken), toks.tokenEnd(endToken), SENTENCE_CHUNK_TYPE);
            chunking.add(chunk);
            startToken = endToken + 1;
        }
        return chunking;
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    static class Serializer
    extends AbstractExternalizable {
        static final long serialVersionUID = -8566130480755448404L;
        final SentenceChunker mChunker;

        public Serializer() {
            this(null);
        }

        public Serializer(SentenceChunker chunker) {
            this.mChunker = chunker;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(this.mChunker.mTokenizerFactory);
            out.writeObject(this.mChunker.mSentenceModel);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            TokenizerFactory tokenizerFactory = (TokenizerFactory)in.readObject();
            SentenceModel sentenceModel = (SentenceModel)in.readObject();
            return new SentenceChunker(tokenizerFactory, sentenceModel);
        }
    }
}

