/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

import com.aliasi.stats.DiscreteDistribution;
import com.aliasi.util.Math;

public abstract class AbstractDiscreteDistribution
implements DiscreteDistribution {
    @Override
    public abstract double probability(long var1);

    @Override
    public double cumulativeProbabilityLess(long upperBound) {
        return this.cumulativeProbability(Long.MIN_VALUE, upperBound);
    }

    @Override
    public double cumulativeProbabilityGreater(long lowerBound) {
        return this.cumulativeProbability(lowerBound, Long.MAX_VALUE);
    }

    @Override
    public double cumulativeProbability(long lowerBound, long upperBound) {
        double sum = 0.0;
        long start = java.lang.Math.max(lowerBound, this.minOutcome());
        long last = java.lang.Math.min(upperBound, this.maxOutcome());
        for (long i = start; i <= last; ++i) {
            sum += this.probability(i);
        }
        return sum;
    }

    @Override
    public double log2Probability(long outcome) {
        return Math.log2(this.probability(outcome));
    }

    @Override
    public long minOutcome() {
        return Long.MIN_VALUE;
    }

    @Override
    public long maxOutcome() {
        return Long.MAX_VALUE;
    }

    @Override
    public double mean() {
        double mean = 0.0;
        long maxOutcome = this.maxOutcome();
        for (long i = this.minOutcome(); i <= maxOutcome; ++i) {
            mean += (double)i * this.probability(i);
        }
        return mean;
    }

    @Override
    public double variance() {
        double mean = this.mean();
        double variance = 0.0;
        long maxOutcome = this.maxOutcome();
        for (long i = this.minOutcome(); i <= maxOutcome; ++i) {
            double diff = mean - (double)i;
            variance += this.probability(i) * diff * diff;
        }
        return variance;
    }

    @Override
    public double entropy() {
        double sum = 0.0;
        long maxOutcome = this.maxOutcome();
        for (long i = this.minOutcome(); i <= maxOutcome; ++i) {
            sum += this.probability(i) * this.log2Probability(i);
        }
        return -sum;
    }

    void checkOutcome(long outcome) {
        if (this.outcomeOutOfRange(outcome)) {
            String msg = "Outcome must be in range.  Minimum = 0. Maximum=" + this.maxOutcome() + " Found outcome=" + outcome;
            throw new IllegalArgumentException(msg);
        }
    }

    boolean outcomeOutOfRange(long outcome) {
        return outcome < 0L || outcome > this.maxOutcome();
    }

    void validateProbability(double p) {
        if (p >= 0.0 && p <= 1.0) {
            return;
        }
        String msg = "Probabilities must be between 0 and 1 inclusive. Found probability=" + p;
        throw new IllegalArgumentException(msg);
    }
}

