/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

public abstract class AnnealingSchedule {
    public boolean allowsRejection() {
        return true;
    }

    public abstract double learningRate(int var1);

    public boolean receivedError(int epoch, double rate, double error) {
        return true;
    }

    public static AnnealingSchedule inverse(double initialLearningRate, double annealingRate) {
        return new InverseAnnealingSchedule(initialLearningRate, annealingRate);
    }

    public static AnnealingSchedule exponential(double initialLearningRate, double base) {
        return new ExponentialAnnealingSchedule(initialLearningRate, base);
    }

    public static AnnealingSchedule constant(double learningRate) {
        return new ConstantAnnealingSchedule(learningRate);
    }

    static void verifyFinitePositive(String varName, double val) {
        if (Double.isNaN(val) || Double.isInfinite(val) || val <= 0.0) {
            String msg = varName + " must be finite and positive. Found " + varName + "=" + val;
            throw new IllegalArgumentException(msg);
        }
    }

    static class ExponentialAnnealingSchedule
    extends AnnealingScheduleImpl {
        private final double mExponentBase;

        ExponentialAnnealingSchedule(double initialLearningRate, double base) {
            super(initialLearningRate);
            if (Double.isNaN(base) || Double.isInfinite(base) || base <= 0.0 || base > 1.0) {
                String msg = "Base must be between 0.0 (exclusive) and 1.0 (inclusive) Found base=" + base;
                throw new IllegalArgumentException(msg);
            }
            this.mExponentBase = base;
        }

        @Override
        public double learningRate(int epoch) {
            return this.mInitialLearningRate * Math.pow(this.mExponentBase, epoch);
        }

        public String toString() {
            return "Exponential(initialLearningRate=" + this.mInitialLearningRate + ", base=" + this.mExponentBase + ")";
        }
    }

    static class InverseAnnealingSchedule
    extends AnnealingScheduleImpl {
        private final double mAnnealingRate;

        InverseAnnealingSchedule(double initialLearningRate, double annealingRate) {
            super(initialLearningRate);
            InverseAnnealingSchedule.verifyFinitePositive("annealing rate", annealingRate);
            this.mAnnealingRate = annealingRate;
        }

        @Override
        public double learningRate(int epoch) {
            return this.mInitialLearningRate / (1.0 + (double)epoch / this.mAnnealingRate);
        }

        public String toString() {
            return "Inverse(initialLearningRate=" + this.mInitialLearningRate + ", annealingRate=" + this.mAnnealingRate + ")";
        }
    }

    static class ConstantAnnealingSchedule
    extends AnnealingScheduleImpl {
        ConstantAnnealingSchedule(double learningRate) {
            super(learningRate);
        }

        @Override
        public double learningRate(int epoch) {
            return this.mInitialLearningRate;
        }

        public String toString() {
            return "AnnealingSchedule.constant(" + this.mInitialLearningRate + ")";
        }
    }

    static abstract class AnnealingScheduleImpl
    extends AnnealingSchedule {
        final double mInitialLearningRate;

        AnnealingScheduleImpl(double initialLearningRate) {
            AnnealingScheduleImpl.verifyFinitePositive("initial learning rate", initialLearningRate);
            this.mInitialLearningRate = initialLearningRate;
        }

        @Override
        public boolean allowsRejection() {
            return false;
        }
    }
}

