/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

import com.aliasi.stats.AbstractDiscreteDistribution;
import com.aliasi.stats.BernoulliDistribution;
import com.aliasi.util.Math;

public class BinomialDistribution
extends AbstractDiscreteDistribution {
    private final BernoulliDistribution mBernoulliDistribution;
    private final int mNumTrials;

    public BinomialDistribution(BernoulliDistribution distribution, int numTrials) {
        if (numTrials < 0) {
            String msg = "Number of trials must be non-negative. Found num trials=" + numTrials;
            throw new IllegalArgumentException(msg);
        }
        this.mBernoulliDistribution = distribution;
        this.mNumTrials = numTrials;
    }

    public BernoulliDistribution bernoulliDistribution() {
        return this.mBernoulliDistribution;
    }

    @Override
    public long minOutcome() {
        return 0L;
    }

    @Override
    public long maxOutcome() {
        return this.mNumTrials;
    }

    public long numTrials() {
        return this.mNumTrials;
    }

    @Override
    public double probability(long outcome) {
        return java.lang.Math.pow(2.0, this.log2Probability(outcome));
    }

    @Override
    public double log2Probability(long outcome) {
        if (outcome < 0L || outcome > this.maxOutcome()) {
            return Double.NEGATIVE_INFINITY;
        }
        return BinomialDistribution.log2BinomialCoefficient(this.mNumTrials, outcome) + (double)outcome * this.mBernoulliDistribution.log2Probability(1L) + (double)((long)this.mNumTrials - outcome) * this.mBernoulliDistribution.log2Probability(0L);
    }

    public double z(int numSuccesses) {
        return BinomialDistribution.z(this.mBernoulliDistribution.successProbability(), numSuccesses, this.mNumTrials);
    }

    @Override
    public double variance() {
        double successProb = this.mBernoulliDistribution.successProbability();
        return successProb * (1.0 - successProb) * (double)this.mNumTrials;
    }

    public static double z(double successProbability, int numSuccesses, int numTrials) {
        if (successProbability < 0.0 || successProbability > 1.0 || Double.isNaN(successProbability)) {
            String msg = "Require probability between 0 and 1 for success. Found success probability=" + successProbability;
            throw new IllegalArgumentException(msg);
        }
        if (numSuccesses < 0 || numSuccesses > numTrials) {
            String msg = "Require 0 <= num successes <= num trials Found num successes= " + numSuccesses + " num successes=" + numTrials;
            throw new IllegalArgumentException(msg);
        }
        double numTrialsD = numTrials;
        double numSuccessesD = numSuccesses;
        double expectedSuccesses = successProbability * numTrialsD;
        return (numSuccessesD - expectedSuccesses) / java.lang.Math.sqrt(numTrialsD * successProbability * (1.0 - successProbability));
    }

    public static double log2BinomialCoefficient(long n, long m) {
        if (n < m) {
            String msg = "Require n > m for binomial coefficient. Found n= " + n + " m = " + m;
            throw new IllegalArgumentException(msg);
        }
        return Math.log2Factorial(n) - Math.log2Factorial(m) - Math.log2Factorial(n - m);
    }
}

