/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.stats;

import com.aliasi.stats.AbstractDiscreteDistribution;

public class ZipfDistribution
extends AbstractDiscreteDistribution {
    private final double[] mEstimates;

    public ZipfDistribution(int numOutcomes) {
        if (numOutcomes <= 0) {
            String msg = "Number of outcomes must be postive. Found numOutcomes=" + numOutcomes;
            throw new IllegalArgumentException(msg);
        }
        this.mEstimates = ZipfDistribution.zipfDistribution(numOutcomes);
    }

    @Override
    public long minOutcome() {
        return 1L;
    }

    @Override
    public long maxOutcome() {
        return this.mEstimates.length;
    }

    public int numOutcomes() {
        return this.mEstimates.length;
    }

    @Override
    public double probability(long rank) {
        if (rank <= 0L || rank > (long)this.mEstimates.length) {
            return 0.0;
        }
        return this.mEstimates[(int)rank - 1];
    }

    public static double[] zipfDistribution(int numOutcomes) {
        int i;
        double[] ratio = new double[numOutcomes];
        for (int i2 = 1; i2 <= numOutcomes; ++i2) {
            ratio[i2 - 1] = 1.0 / (double)i2;
        }
        double sum = 0.0;
        for (i = 0; i < ratio.length; ++i) {
            sum += ratio[i];
        }
        i = 0;
        while (i < ratio.length) {
            int n = i++;
            ratio[n] = ratio[n] / sum;
        }
        return ratio;
    }
}

