/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.tag;

import com.aliasi.classify.BaseClassifier;
import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.tag.Tagger;
import com.aliasi.tag.Tagging;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class ClassifierTagger<E>
implements Tagger<E>,
Compilable,
Serializable {
    static final long serialVersionUID = -3999881235621306119L;
    private final BaseClassifier<State<E>> mClassifier;

    public ClassifierTagger(BaseClassifier<State<E>> classifier) {
        this.mClassifier = classifier;
    }

    public BaseClassifier<State<E>> classifier() {
        return this.mClassifier;
    }

    @Override
    public Tagging<E> tag(List<E> tokens) {
        ArrayList<String> tags = new ArrayList<String>(tokens.size());
        for (int i = 0; i < tokens.size(); ++i) {
            State<E> state = new State<E>(tokens, tags, i);
            String tag = this.mClassifier.classify(state).bestCategory();
            tags.add(tag);
        }
        return new Tagging<E>(tokens, tags);
    }

    @Override
    public void compileTo(ObjectOutput out) throws IOException {
        if (!(this.mClassifier instanceof Compilable)) {
            String msg = "Base classifier is not compilable. Found base classifier class=" + this.mClassifier.getClass();
            throw new NotSerializableException(msg);
        }
        out.writeObject(new Compiler(this));
    }

    Object writeReplace() {
        return new Serializer(this);
    }

    public static <F> Corpus<ObjectHandler<Classified<State<F>>>> toClassifiedCorpus(Corpus<ObjectHandler<Tagging<F>>> taggingCorpus) {
        return new StateCorpus<F>(taggingCorpus);
    }

    static class ScSerializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = -4849217701670674035L;
        final StateCorpus<F> mCorpus;

        public ScSerializer() {
            this(null);
        }

        ScSerializer(StateCorpus<F> corpus) {
            this.mCorpus = corpus;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(((StateCorpus)this.mCorpus).mTaggingCorpus);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            Corpus taggingCorpus = (Corpus)in.readObject();
            return new StateCorpus(taggingCorpus);
        }
    }

    static class HandlerAdapter<F>
    implements ObjectHandler<Tagging<F>> {
        final ObjectHandler<Classified<State<F>>> mHandler;

        HandlerAdapter(ObjectHandler<Classified<State<F>>> handler) {
            this.mHandler = handler;
        }

        @Override
        public void handle(Tagging<F> tagging) {
            List<F> tokens = tagging.tokens();
            List<String> tags = tagging.tags();
            for (int i = 0; i < tagging.size(); ++i) {
                State<F> state = new State<F>(tokens, tags.subList(0, i), i);
                Classification c = new Classification(tags.get(i));
                Classified<State<F>> classified = new Classified<State<F>>(state, c);
                this.mHandler.handle(classified);
            }
        }
    }

    static class StateCorpus<F>
    extends Corpus<ObjectHandler<Classified<State<F>>>>
    implements Serializable {
        static final long serialVersionUID = -8545927933382605392L;
        private final Corpus<ObjectHandler<Tagging<F>>> mTaggingCorpus;

        public StateCorpus(Corpus<ObjectHandler<Tagging<F>>> taggingCorpus) {
            this.mTaggingCorpus = taggingCorpus;
        }

        @Override
        public void visitTrain(ObjectHandler<Classified<State<F>>> handler) throws IOException {
            this.mTaggingCorpus.visitTrain(new HandlerAdapter<F>(handler));
        }

        @Override
        public void visitTest(ObjectHandler<Classified<State<F>>> handler) throws IOException {
            this.mTaggingCorpus.visitTest(new HandlerAdapter<F>(handler));
        }

        Object writeReplace() {
            return new ScSerializer(this);
        }
    }

    static class Compiler<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = -1204364907641769096L;
        private final ClassifierTagger<F> mTagger;

        public Compiler() {
            this(null);
        }

        public Compiler(ClassifierTagger<F> tagger) {
            this.mTagger = tagger;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            ((Compilable)((Object)((ClassifierTagger)this.mTagger).mClassifier)).compileTo(out);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            BaseClassifier classifier = (BaseClassifier)in.readObject();
            return new ClassifierTagger(classifier);
        }
    }

    static class Serializer<F>
    extends AbstractExternalizable {
        static final long serialVersionUID = -6902579802924987108L;
        private final ClassifierTagger<F> mTagger;

        public Serializer() {
            this(null);
        }

        public Serializer(ClassifierTagger<F> tagger) {
            this.mTagger = tagger;
        }

        @Override
        public void writeExternal(ObjectOutput out) throws IOException {
            out.writeObject(((ClassifierTagger)this.mTagger).mClassifier);
        }

        @Override
        public Object read(ObjectInput in) throws IOException, ClassNotFoundException {
            BaseClassifier classifier = (BaseClassifier)in.readObject();
            return new ClassifierTagger(classifier);
        }
    }

    public static class State<F> {
        private final List<F> mTokens;
        private final List<String> mTags;
        private final int mPosition;

        State(List<F> tokens, List<String> tags, int position) {
            this.mTokens = Collections.unmodifiableList(tokens);
            this.mTags = Collections.unmodifiableList(tags);
            this.mPosition = position;
        }

        public int numTokens() {
            return this.mTokens.size();
        }

        public int position() {
            return this.mPosition;
        }

        public List<F> tokens() {
            return this.mTokens;
        }

        public List<String> tags() {
            return this.mTags;
        }

        public F token(int pos) {
            return this.mTokens.get(pos);
        }

        public String tag(int pos) {
            return this.mTags.get(pos);
        }
    }
}

