/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit;

import com.aliasi.util.AbstractExternalizable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Comparator;
import java.util.Iterator;
import junit.framework.Assert;

public class Asserts {
    private static String EMPTY_MSG = "";

    private Asserts() {
    }

    public static void assertNotSerializable(Object x) {
        if (!(x instanceof Serializable)) {
            return;
        }
        try {
            AbstractExternalizable.serializeDeserialize((Serializable)x);
            Assert.fail((String)"Should have serialized");
        }
        catch (NotSerializableException e) {
            Asserts.succeed();
        }
        catch (IOException e) {
            Assert.fail((String)"Found IO exception instead of NotSerializableException");
        }
    }

    public static void assertNotEquals(Object x, Object y) {
        Asserts.assertNotEquals("", x, y);
    }

    public static void assertNotEquals(String msg, Object x, Object y) {
        if (x == null) {
            Assert.assertNotNull((String)msg, (Object)y);
            return;
        }
        if (y == null) {
            return;
        }
        Assert.assertFalse((String)msg, (boolean)x.equals(y));
    }

    public static void assertEqualsArray(double[] xs, double[] ys, double tolerance) {
        Asserts.assertEqualsArray("", xs, ys, tolerance);
    }

    public static void assertEqualsArray2D(double[][] xss, double[][] yss, double tolerance) {
        Assert.assertEquals((int)xss.length, (int)yss.length);
        for (int i = 0; i < xss.length; ++i) {
            Asserts.assertEqualsArray(xss[i], yss[i], tolerance);
        }
    }

    public static void assertEqualsArray(String msg, double[] xs, double[] ys, double tolerance) {
        Assert.assertNotNull((String)("Null first array. " + msg), (Object)xs);
        Assert.assertNotNull((String)("Null second array. " + msg), (Object)ys);
        Assert.assertEquals((String)("Arrays have different lengths. " + msg), (int)xs.length, (int)ys.length);
        for (int i = 0; i < xs.length; ++i) {
            Assert.assertEquals((String)("row + " + i + ": " + msg), (double)xs[i], (double)ys[i], (double)tolerance);
        }
    }

    public static void assertFullEquals(Object x, Object y) {
        Asserts.assertFullEquals(EMPTY_MSG, x, y);
    }

    public static void assertFullNotEquals(Object x, Object y) {
        Asserts.assertFullNotEquals(EMPTY_MSG, x, y);
    }

    public static void assertFullSerialization(Object x) {
        Asserts.assertFullSerialization(EMPTY_MSG, x);
    }

    public static void assertFullLessThan(Comparable x, Comparable y) {
        Asserts.assertFullLessThan(EMPTY_MSG, x, y);
    }

    public static void assertComparableSelf(Comparable xc) {
        Asserts.assertComparableSelf("", xc);
    }

    public static void assertEqualsIterations(Iterator it1, Iterator it2) {
        Asserts.assertEqualsIterations("", it1, it2);
    }

    public static void assertEqualsIterations(String msg, Iterator it1, Iterator it2) {
        int i = 0;
        while (it1.hasNext()) {
            Assert.assertTrue((String)(msg + "First iterator longer"), (boolean)it2.hasNext());
            Assert.assertEquals((String)(msg + "Differ on element=" + i), it1.next(), it2.next());
            ++i;
        }
        Assert.assertFalse((String)(msg + "Second iterator longer"), (boolean)it2.hasNext());
    }

    public static void assertFullEquals(String msg, Object x, Object y) {
        Assert.assertNotNull((String)"First object null.", (Object)x);
        Assert.assertNotNull((String)"Second object null.", (Object)y);
        Assert.assertEquals((String)(msg + "Forward Equality Failure as Object."), (Object)x, (Object)y);
        Assert.assertEquals((String)(msg + "Backward Equality Failure as Object."), (Object)y, (Object)x);
        Assert.assertEquals((String)(msg + "Hash Code Equality Failure."), (int)x.hashCode(), (int)y.hashCode());
        Assert.assertFalse((String)(msg + "First object equals null failure."), (boolean)x.equals(null));
        Assert.assertFalse((String)(msg + "Second object equals null failure."), (boolean)y.equals(null));
        if (x instanceof Comparable) {
            Comparable xc = (Comparable)x;
            Assert.assertEquals((String)(msg + "First object's atural ordering incompatible with equals."), (int)0, (int)xc.compareTo(y));
        }
        if (y instanceof Comparable) {
            Comparable yc = (Comparable)y;
            Assert.assertEquals((String)(msg + "Second object's natural ordering incompatible with equals"), (int)0, (int)yc.compareTo(x));
        }
    }

    public static void assertFullNotEquals(String msg, Object x, Object y) {
        Assert.assertNotNull((String)"First object null.", (Object)x);
        Assert.assertNotNull((String)"Second object null.", (Object)y);
        Assert.assertFalse((String)(msg + "Forward Inequality Failure as Object."), (boolean)x.equals(y));
        Assert.assertFalse((String)(msg + "Backward Inequality Failure as Object."), (boolean)y.equals(x));
        if (x instanceof Comparable) {
            Asserts.assertComparableNotEquals(msg + "Forwards. ", (Comparable)x, y);
        }
        if (y instanceof Comparable) {
            Asserts.assertComparableNotEquals(msg + "Backwards. ", (Comparable)y, x);
        }
    }

    private static void assertComparableNotEquals(String msg, Comparable xc, Object y) {
        try {
            int comp = xc.compareTo(y);
            Assert.assertFalse((String)(msg + "Compare to Equals."), (comp == 0 ? 1 : 0) != 0);
        }
        catch (ClassCastException e) {
            Asserts.succeed(msg);
        }
    }

    public static void assertFullSerialization(String msg, Object x) {
        Assert.assertNotNull((String)"Object null.", (Object)x);
        try {
            ByteArrayOutputStream outBytes = new ByteArrayOutputStream();
            ObjectOutputStream out = new ObjectOutputStream(outBytes);
            out.writeObject(x);
            ObjectInputStream in = new ObjectInputStream(new ByteArrayInputStream(outBytes.toByteArray()));
            Object y = in.readObject();
            Asserts.assertFullEquals(msg + "After Serialization: ", x, y);
        }
        catch (IOException e) {
            Assert.fail((String)("IOException during serialization: " + e));
        }
        catch (ClassNotFoundException e) {
            Assert.fail((String)("ClassNotFoundException during serialization: " + e));
        }
    }

    public static void assertFullLessThan(String msg, Comparable x, Comparable y) {
        Assert.assertNotNull((String)(msg + "First argument null."), (Object)x);
        Assert.assertNotNull((String)(msg + "Second argument null."), (Object)y);
        Assert.assertTrue((String)(msg + "First argument not less than second argument via compareTo."), (x.compareTo(y) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((String)(msg + "Second argument not greater than first argument via compareTo."), (y.compareTo(x) > 0 ? 1 : 0) != 0);
    }

    public static void assertComparableSelf(String msg, Comparable xc) {
        Assert.assertNotNull((String)(msg + "Object null."), (Object)xc);
        Assert.assertEquals((String)(msg + "Object not equal to self via compareTo."), (int)0, (int)xc.compareTo(xc));
        try {
            int result = xc.compareTo(new Object());
            Assert.assertFalse((String)(msg + "Object compares to fresh object with equality."), (0 == result ? 1 : 0) != 0);
        }
        catch (ClassCastException e) {
            Asserts.succeed(msg);
        }
    }

    public static void succeed() {
        Asserts.succeed("");
    }

    public static void succeed(String msg) {
        Assert.assertTrue((String)msg, (boolean)true);
    }

    public static <E> void assertLess(Comparator<? super E> comp, E o1, E o2) {
        Assert.assertTrue((comp.compare(o1, o2) < 0 ? 1 : 0) != 0);
        Assert.assertTrue((comp.compare(o2, o1) > 0 ? 1 : 0) != 0);
    }

    public static <E> void assertSame(Comparator<? super E> comp, E o1, E o2) {
        Assert.assertEquals((int)0, (int)comp.compare(o1, o2));
    }
}

