/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.chunk;

import com.aliasi.chunk.CharLmHmmChunker;
import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunker;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.hmm.HmmCharLmEstimator;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Compilable;
import java.io.IOException;
import junit.framework.Assert;
import org.junit.Test;

public class CharLmHmmChunkerTest {
    @Test
    public void testDictionaryTraining() throws IOException, ClassNotFoundException {
        IndoEuropeanTokenizerFactory factory = IndoEuropeanTokenizerFactory.INSTANCE;
        HmmCharLmEstimator estimator = new HmmCharLmEstimator(5, 128, 5.0, false);
        CharLmHmmChunker chunkerEstimator = new CharLmHmmChunker(factory, estimator, true);
        chunkerEstimator.trainDictionary("John Smith", "PERSON");
        chunkerEstimator.trainDictionary("Washington, D.C.", "LOCATION");
        chunkerEstimator.trainDictionary("Alias-i", "ORGANIZATION");
        Chunking chunking = chunkerEstimator.chunk("John Smith");
        Assert.assertEquals((int)1, (int)chunking.chunkSet().size());
        Chunk chunk = chunking.chunkSet().iterator().next();
        Assert.assertEquals((int)0, (int)chunk.start());
        Assert.assertEquals((int)10, (int)chunk.end());
        Assert.assertEquals((String)"PERSON", (String)chunk.type());
    }

    @Test
    public void testDefectiveTraining() throws IOException, ClassNotFoundException {
        IndoEuropeanTokenizerFactory factory = IndoEuropeanTokenizerFactory.INSTANCE;
        HmmCharLmEstimator estimator = new HmmCharLmEstimator(5, 128, 5.0);
        CharLmHmmChunker chunkerEstimator = new CharLmHmmChunker((TokenizerFactory)factory, estimator);
        Assert.assertEquals((Object)new ChunkingImpl("hello"), (Object)chunkerEstimator.chunk("hello"));
        CharLmHmmChunkerTest.assertChunkingCompile(chunkerEstimator, new ChunkingImpl(""));
        CharLmHmmChunkerTest.assertChunkingCompile(chunkerEstimator, new ChunkingImpl("hello"));
        CharLmHmmChunkerTest.assertChunkingCompile(chunkerEstimator, new ChunkingImpl("John Smith lives in Washington."));
    }

    @Test
    public void testDefectiveTags() throws IOException, ClassNotFoundException {
        IndoEuropeanTokenizerFactory factory = IndoEuropeanTokenizerFactory.INSTANCE;
        HmmCharLmEstimator estimator = new HmmCharLmEstimator(5, 128, 5.0);
        CharLmHmmChunker chunkerEstimator = new CharLmHmmChunker((TokenizerFactory)factory, estimator);
        String text1 = "John Smith lives in Washington.";
        ChunkingImpl chunking1 = new ChunkingImpl(text1);
        Chunk chunk11 = ChunkFactory.createChunk(0, 10, "PER");
        Chunk chunk12 = ChunkFactory.createChunk(20, 30, "LOC");
        chunking1.add(chunk11);
        chunking1.add(chunk12);
        for (int i = 0; i < 10; ++i) {
            chunkerEstimator.handle(chunking1);
        }
        CharLmHmmChunkerTest.assertChunkingCompile(chunkerEstimator, chunking1);
    }

    @Test
    public void testDefectiveTags2() throws IOException, ClassNotFoundException {
        IndoEuropeanTokenizerFactory factory = IndoEuropeanTokenizerFactory.INSTANCE;
        HmmCharLmEstimator estimator = new HmmCharLmEstimator(5, 128, 5.0);
        CharLmHmmChunker chunkerEstimator = new CharLmHmmChunker((TokenizerFactory)factory, estimator);
        String text1 = "John";
        ChunkingImpl chunking1 = new ChunkingImpl(text1);
        Chunk chunk11 = ChunkFactory.createChunk(0, 4, "PER");
        chunking1.add(chunk11);
        for (int i = 0; i < 10; ++i) {
            chunkerEstimator.handle(chunking1);
        }
        CharLmHmmChunkerTest.assertChunkingCompile(chunkerEstimator, chunking1);
    }

    @Test
    public void testChunkHandler() throws IOException, ClassNotFoundException {
        IndoEuropeanTokenizerFactory factory = IndoEuropeanTokenizerFactory.INSTANCE;
        HmmCharLmEstimator estimator = new HmmCharLmEstimator(5, 128, 5.0);
        CharLmHmmChunker chunkerEstimator = new CharLmHmmChunker((TokenizerFactory)factory, estimator);
        String text1 = "John J. Smith lives in Washington.";
        ChunkingImpl chunking1 = new ChunkingImpl(text1);
        Chunk chunk11 = ChunkFactory.createChunk(0, 13, "PER");
        Chunk chunk12 = ChunkFactory.createChunk(23, 33, "LOC");
        chunking1.add(chunk11);
        chunking1.add(chunk12);
        for (int i = 0; i < 10; ++i) {
            chunkerEstimator.handle(chunking1);
        }
        CharLmHmmChunkerTest.assertChunkingCompile(chunkerEstimator, chunking1);
        String text2 = "Washington is near John";
        ChunkingImpl chunking2 = new ChunkingImpl(text2);
        Chunk chunk21 = ChunkFactory.createChunk(0, 10, "LOC");
        Chunk chunk22 = ChunkFactory.createChunk(19, 23, "PER");
        chunking2.add(chunk21);
        chunking2.add(chunk22);
        for (int i = 0; i < 10; ++i) {
            chunkerEstimator.handle(chunking2);
        }
        CharLmHmmChunkerTest.assertChunkingCompile(chunkerEstimator, chunking2);
        String text3 = "Washington D.C. is near Frank Jones.";
        ChunkingImpl chunking3 = new ChunkingImpl(text3);
        Chunk chunk31 = ChunkFactory.createChunk(0, 15, "LOC");
        Chunk chunk32 = ChunkFactory.createChunk(24, 36, "PER");
        chunking3.add(chunk31);
        chunking3.add(chunk32);
        for (int i = 0; i < 10; ++i) {
            chunkerEstimator.handle(chunking3);
        }
        CharLmHmmChunkerTest.assertChunkingCompile(chunkerEstimator, chunking3);
    }

    public static <C extends Chunker & Compilable> void assertChunkingCompile(C chunkerEstimator, Chunking expectedChunking) throws IOException, ClassNotFoundException {
        CharLmHmmChunkerTest.assertChunking(chunkerEstimator, expectedChunking);
        CharLmHmmChunkerTest.assertChunking((Chunker)AbstractExternalizable.compile(chunkerEstimator), expectedChunking);
    }

    public static void assertChunking(Chunker chunker, Chunking expectedChunking) {
        CharSequence text = expectedChunking.charSequence();
        Chunking chunking = chunker.chunk(text);
        CharLmHmmChunkerTest.assertEqualsChunking(expectedChunking, chunking);
    }

    public static void assertEqualsChunking(Chunking expectedChunking, Chunking chunking) {
        Assert.assertEquals((Object)expectedChunking.charSequence(), (Object)chunking.charSequence());
        Assert.assertEquals(expectedChunking.chunkSet(), chunking.chunkSet());
    }
}

