/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.chunk;

import com.aliasi.chunk.Chunk;
import com.aliasi.chunk.ChunkFactory;
import com.aliasi.chunk.Chunking;
import com.aliasi.chunk.ChunkingImpl;
import com.aliasi.chunk.IoTagChunkCodec;
import com.aliasi.chunk.TagChunkCodec;
import com.aliasi.crf.ForwardBackwardTagLattice;
import com.aliasi.tag.StringTagging;
import com.aliasi.test.unit.Asserts;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import junit.framework.Assert;
import org.junit.Test;

public class IoTagChunkCodecTest {
    @Test(expected=UnsupportedOperationException.class)
    public void testNBestChunks() {
        IoTagChunkCodec codec = new IoTagChunkCodec(IndoEuropeanTokenizerFactory.INSTANCE, false);
        ForwardBackwardTagLattice<String> lattice = new ForwardBackwardTagLattice<String>(Collections.emptyList(), Collections.emptyList(), new double[0][0], new double[0][0], new double[0][0][0], 0.0);
        Iterator<Chunk> it = codec.nBestChunks(lattice, new int[0], new int[0], 100);
    }

    @Test
    public void testLegalTagSubSequence() {
        IoTagChunkCodec codec = new IoTagChunkCodec(IndoEuropeanTokenizerFactory.INSTANCE, false);
        Assert.assertTrue((boolean)codec.legalTagSubSequence("O"));
        Assert.assertTrue((boolean)codec.legalTagSubSequence("PER"));
        Assert.assertTrue((boolean)codec.legalTagSubSequence("LOC"));
        Assert.assertTrue((boolean)codec.legalTagSubSequence("O", "PER"));
        Assert.assertTrue((boolean)codec.legalTagSubSequence("PER", "O"));
        Assert.assertTrue((boolean)codec.legalTagSubSequence("PER", "PER"));
        Assert.assertTrue((boolean)codec.legalTagSubSequence("PER", "LOC"));
        Assert.assertTrue((boolean)codec.legalTagSubSequence("O", "PER", "PER", "PER", "ORG", "O"));
    }

    @Test
    public void testLegalTags() {
        IoTagChunkCodec codec = new IoTagChunkCodec(IndoEuropeanTokenizerFactory.INSTANCE, false);
        Assert.assertTrue((boolean)codec.legalTags("O"));
        Assert.assertTrue((boolean)codec.legalTags("PER"));
        Assert.assertTrue((boolean)codec.legalTags("LOC"));
        Assert.assertTrue((boolean)codec.legalTags("O", "PER"));
        Assert.assertTrue((boolean)codec.legalTags("PER", "O"));
        Assert.assertTrue((boolean)codec.legalTags("PER", "PER"));
        Assert.assertTrue((boolean)codec.legalTags("PER", "LOC"));
        Assert.assertTrue((boolean)codec.legalTags("O", "PER", "PER", "PER", "ORG", "O"));
    }

    @Test
    public void testBioCodecTagSet() {
        IoTagChunkCodec codec = new IoTagChunkCodec(IndoEuropeanTokenizerFactory.INSTANCE, false);
        HashSet<String> chunkTypes = new HashSet<String>(Arrays.asList("PER", "LOC"));
        HashSet<String> expectedTags = new HashSet<String>(Arrays.asList("O", "PER", "LOC"));
        Assert.assertEquals(expectedTags, codec.tagSet(chunkTypes));
    }

    @Test
    public void testEncodable() throws IOException, ClassNotFoundException {
        IoTagChunkCodec codec = new IoTagChunkCodec(IndoEuropeanTokenizerFactory.INSTANCE, true);
        ChunkingImpl chunkingOk = new ChunkingImpl("John Jones Mary and Mr. J. J. Jones ran to Washington.");
        this.assertEncodable(codec, chunkingOk);
        Chunk chunk1 = ChunkFactory.createChunk(0, 10, "PER");
        Chunk chunk2 = ChunkFactory.createChunk(11, 15, "PER");
        Chunk chunk3 = ChunkFactory.createChunk(24, 35, "PER");
        Chunk chunk4 = ChunkFactory.createChunk(43, 53, "LOC");
        chunkingOk.add(chunk4);
        this.assertEncodable(codec, chunkingOk);
        chunkingOk.add(chunk3);
        this.assertEncodable(codec, chunkingOk);
        chunkingOk.add(chunk1);
        this.assertEncodable(codec, chunkingOk);
        chunkingOk.add(chunk2);
        this.assertNotEncodable(codec, chunkingOk);
        ChunkingImpl chunkingBad = new ChunkingImpl("John ran");
        Chunk chunk2_1 = ChunkFactory.createChunk(0, 4, "PER");
        Chunk chunk2_2 = ChunkFactory.createChunk(0, 8, "LOC");
        chunkingBad.add(chunk2_1);
        chunkingBad.add(chunk2_2);
        this.assertNotEncodable(codec, chunkingBad);
        ChunkingImpl chunkingBad3 = new ChunkingImpl("John ran");
        Chunk chunk3_1 = ChunkFactory.createChunk(0, 5, "PER");
        chunkingBad3.add(chunk3_1);
        this.assertNotEncodable(codec, chunkingBad3);
        ChunkingImpl chunkingBad4 = new ChunkingImpl("John ran");
        Chunk chunk4_1 = ChunkFactory.createChunk(1, 4, "PER");
        chunkingBad4.add(chunk4_1);
        this.assertNotEncodable(codec, chunkingBad4);
        this.assertNotEncodable(codec, chunkingBad4);
        ChunkingImpl chunkingBad5 = new ChunkingImpl("John ran");
        Chunk chunk5_1 = ChunkFactory.createChunk(5, 5, "LOC");
        chunkingBad5.add(chunk5_1);
        this.assertNotEncodable(codec, chunkingBad5);
        ChunkingImpl chunkingOk2 = new ChunkingImpl("John ran");
        Assert.assertTrue((boolean)codec.isEncodable(chunkingOk2));
        Chunk chunk6_1 = ChunkFactory.createChunk(0, 8, "LOC");
        chunkingOk2.add(chunk6_1);
        this.assertEncodable(codec, chunkingOk2);
        ChunkingImpl chunkingOk3 = new ChunkingImpl("Mr. John Jones ran to Washington.");
        Chunk jj = ChunkFactory.createChunk(4, 14, "PER");
        Chunk w = ChunkFactory.createChunk(22, 32, "LOC");
        chunkingOk3.add(jj);
        chunkingOk3.add(w);
        this.assertEncodable(codec, chunkingOk3);
    }

    @Test
    public void testDecodable() throws IOException, ClassNotFoundException {
        IoTagChunkCodec codec = new IoTagChunkCodec(IndoEuropeanTokenizerFactory.INSTANCE, true);
        StringTagging taggingOk = new StringTagging(Arrays.asList("John", "ran", "to", "Washington", "DC"), Arrays.asList("PER", "O", "O", "LOC", "LOC"), (CharSequence)"John ran to Washington DC", new int[]{0, 5, 9, 12, 23}, new int[]{4, 8, 11, 22, 25});
        this.assertDecodable(codec, taggingOk);
        StringTagging taggingBad = new StringTagging(Arrays.asList("John", "ny", "ran", "."), Arrays.asList("PER", "PER", "O", "O"), (CharSequence)"Johnny ran.", new int[]{0, 4, 7, 10}, new int[]{4, 6, 10, 11});
        this.assertNotDecodable(codec, taggingBad);
    }

    void assertEncodable(TagChunkCodec codec, Chunking chunking) throws IOException, ClassNotFoundException {
        this.assertEncodable2(codec, chunking);
        TagChunkCodec codec2 = (TagChunkCodec)AbstractExternalizable.serializeDeserialize((Serializable)((Object)codec));
        this.assertEncodable2(codec2, chunking);
    }

    void assertEncodable2(TagChunkCodec codec, Chunking chunking) {
        Assert.assertTrue((boolean)codec.isEncodable(chunking));
        StringTagging tagging = codec.toStringTagging(chunking);
        Assert.assertTrue((boolean)codec.isDecodable(tagging));
        Chunking chunking2 = codec.toChunking(tagging);
        Assert.assertEquals((Object)chunking, (Object)chunking2);
        StringTagging tagging2 = codec.toStringTagging(chunking2);
        Assert.assertEquals((Object)tagging, (Object)tagging2);
    }

    void assertNotEncodable(TagChunkCodec codec, Chunking chunking) {
        Assert.assertFalse((boolean)codec.isEncodable(chunking));
        try {
            codec.toTagging(chunking);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }

    void assertDecodable(TagChunkCodec codec, StringTagging tagging) throws IOException, ClassNotFoundException {
        this.assertDecodable2(codec, tagging);
        TagChunkCodec codec2 = (TagChunkCodec)AbstractExternalizable.serializeDeserialize((Serializable)((Object)codec));
        this.assertDecodable2(codec2, tagging);
    }

    void assertDecodable2(TagChunkCodec codec, StringTagging tagging) {
        Assert.assertTrue((boolean)codec.isDecodable(tagging));
        Chunking chunking = codec.toChunking(tagging);
        Assert.assertTrue((boolean)codec.isEncodable(chunking));
        StringTagging tagging2 = codec.toStringTagging(chunking);
        Assert.assertEquals((Object)tagging, (Object)tagging2);
        Chunking chunking2 = codec.toChunking(tagging2);
        Assert.assertEquals((Object)chunking, (Object)chunking2);
    }

    void assertNotDecodable(TagChunkCodec codec, StringTagging tagging) {
        Assert.assertFalse((boolean)codec.isDecodable(tagging));
        try {
            codec.toChunking(tagging);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
    }
}

