/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.classify;

import com.aliasi.classify.BinaryLMClassifier;
import com.aliasi.lm.NGramBoundaryLM;
import com.aliasi.lm.NGramProcessLM;
import junit.framework.Assert;
import org.junit.Test;

public class BinaryLMClassifierTest {
    @Test
    public void testNeg() {
        NGramBoundaryLM lm = new NGramBoundaryLM(5);
        BinaryLMClassifier classifier = new BinaryLMClassifier(lm, 10.0);
        classifier.train("true", "Hello", 1);
        classifier.train("false", "Goodbye", 1);
    }

    @Test
    public void testOne() {
        NGramBoundaryLM lm = new NGramBoundaryLM(5);
        BinaryLMClassifier classifier = new BinaryLMClassifier(lm, 10.0);
        for (int i = 0; i < 100; ++i) {
            classifier.train("true", "Kilroy was here.", 1);
        }
        Assert.assertEquals((String)"false", (String)classifier.classify("John Smith").bestCategory());
        Assert.assertEquals((String)"true", (String)classifier.classify("Kilroy").bestCategory());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testUnsupExc() {
        NGramBoundaryLM lm = new NGramBoundaryLM(5);
        BinaryLMClassifier classifier = new BinaryLMClassifier(lm, 10.0);
        classifier.resetCategory("true", new NGramBoundaryLM(5), 15);
    }

    @Test
    public void testTwo() {
        NGramProcessLM lm = new NGramProcessLM(5);
        BinaryLMClassifier classifier = new BinaryLMClassifier(lm, 12.0);
        Assert.assertEquals((String)"false", (String)classifier.classify("").bestCategory());
        Assert.assertEquals((String)"false", (String)classifier.classify("abcdefghijklmnop").bestCategory());
    }

    @Test
    public void testThree() {
        NGramProcessLM lm = new NGramProcessLM(5);
        BinaryLMClassifier classifier = new BinaryLMClassifier(lm, 18.0);
        Assert.assertEquals((String)"true", (String)classifier.classify("abcdefghijklmnop").bestCategory());
    }
}

