/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.classify;

import com.aliasi.classify.ConfusionMatrix;
import com.aliasi.classify.PrecisionRecallEvaluation;
import org.junit.Assert;
import org.junit.Test;

public class ConfusionMatrixTest {
    private static String[] BINARY_CATS = new String[]{"0", "1"};
    private static String[] WINE_CATS = new String[]{"Cab", "Syr", "Pin"};

    @Test(expected=IllegalArgumentException.class)
    public void testExcIncrement() {
        ConfusionMatrix matrix = new ConfusionMatrix(WINE_CATS);
        matrix.incrementByN(0, 0, -1);
    }

    @Test
    public void testInit() {
        ConfusionMatrix matrix = new ConfusionMatrix(BINARY_CATS);
        Assert.assertArrayEquals((Object[])BINARY_CATS, (Object[])matrix.categories());
        int[][] initMatrix = matrix.matrix();
        junit.framework.Assert.assertEquals((int)2, (int)initMatrix.length);
        junit.framework.Assert.assertEquals((int)2, (int)initMatrix[0].length);
        for (int i = 0; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                junit.framework.Assert.assertEquals((int)0, (int)initMatrix[i][j]);
            }
        }
        junit.framework.Assert.assertEquals((int)0, (int)matrix.getIndex("0"));
        junit.framework.Assert.assertEquals((int)1, (int)matrix.getIndex("1"));
        junit.framework.Assert.assertEquals((int)-1, (int)matrix.getIndex("2"));
        junit.framework.Assert.assertEquals((int)1, (int)matrix.chiSquaredDegreesOfFreedom());
        junit.framework.Assert.assertEquals((int)2, (int)matrix.numCategories());
    }

    @Test
    public void testIncrement() {
        ConfusionMatrix matrix = new ConfusionMatrix(WINE_CATS);
        matrix.increment("Cab", "Cab");
        junit.framework.Assert.assertEquals((int)1, (int)matrix.count(0, 0));
        matrix.increment(0, 0);
        junit.framework.Assert.assertEquals((int)2, (int)matrix.count(0, 0));
        matrix.increment(1, 2);
        matrix.increment("Syr", "Pin");
        junit.framework.Assert.assertEquals((int)2, (int)matrix.count(1, 2));
        junit.framework.Assert.assertEquals((int)0, (int)matrix.count(2, 1));
        int[][] expectedMatrix = new int[][]{{2, 0, 0}, {0, 0, 2}, {0, 0, 0}};
        int[][] foundMatrix = matrix.matrix();
        junit.framework.Assert.assertEquals((int)expectedMatrix.length, (int)foundMatrix.length);
        for (int i = 0; i < foundMatrix.length; ++i) {
            Assert.assertArrayEquals((int[])expectedMatrix[i], (int[])foundMatrix[i]);
        }
    }

    @Test
    public void testStats() {
        int[][] counts = new int[][]{{9, 3, 0}, {3, 5, 1}, {1, 1, 4}};
        ConfusionMatrix matrix = new ConfusionMatrix(WINE_CATS, counts);
        junit.framework.Assert.assertEquals((int)9, (int)matrix.count(0, 0));
        junit.framework.Assert.assertEquals((int)3, (int)matrix.count(0, 1));
        junit.framework.Assert.assertEquals((int)1, (int)matrix.count(2, 0));
        junit.framework.Assert.assertEquals((int)27, (int)matrix.totalCount());
        junit.framework.Assert.assertEquals((int)18, (int)matrix.totalCorrect());
        junit.framework.Assert.assertEquals((double)0.6667, (double)matrix.totalAccuracy(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.1778, (double)matrix.confidence95(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.2341, (double)matrix.confidence99(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.3663, (double)matrix.randomAccuracy(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.3669, (double)matrix.randomAccuracyUnbiased(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.474, (double)matrix.kappa(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.4735, (double)matrix.kappaUnbiased(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.3333, (double)matrix.kappaNoPrevalence(), (double)0.005);
        junit.framework.Assert.assertEquals((double)1.5305, (double)matrix.referenceEntropy(), (double)0.005);
        junit.framework.Assert.assertEquals((double)1.4865, (double)matrix.responseEntropy(), (double)0.005);
        junit.framework.Assert.assertEquals((double)1.5376, (double)matrix.crossEntropy(), (double)0.005);
        PrecisionRecallEvaluation ova0 = matrix.oneVsAll(0);
        PrecisionRecallEvaluation ova1 = matrix.oneVsAll(1);
        PrecisionRecallEvaluation ova2 = matrix.oneVsAll(2);
        junit.framework.Assert.assertEquals((long)12L, (long)ova0.positiveReference());
        junit.framework.Assert.assertEquals((long)9L, (long)ova1.positiveReference());
        junit.framework.Assert.assertEquals((long)6L, (long)ova2.positiveReference());
        junit.framework.Assert.assertEquals((double)0.4414, (double)ova0.referenceLikelihood(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.3333, (double)ova1.referenceLikelihood(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.2222, (double)ova2.referenceLikelihood(), (double)0.005);
        junit.framework.Assert.assertEquals((long)13L, (long)ova0.positiveResponse());
        junit.framework.Assert.assertEquals((long)9L, (long)ova1.positiveResponse());
        junit.framework.Assert.assertEquals((long)5L, (long)ova2.positiveResponse());
        junit.framework.Assert.assertEquals((double)0.4815, (double)ova0.responseLikelihood(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.3333, (double)ova1.responseLikelihood(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.1852, (double)ova2.responseLikelihood(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.6923, (double)ova0.precision(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.5555, (double)ova1.precision(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.8, (double)ova2.precision(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.75, (double)ova0.recall(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.5555, (double)ova1.recall(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.6666, (double)ova2.recall(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.72, (double)ova0.fMeasure(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.5555, (double)ova1.fMeasure(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.7273, (double)ova2.fMeasure(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.7333, (double)ova0.rejectionRecall(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.7778, (double)ova1.rejectionRecall(), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)0.9524, (double)ova2.rejectionRecall(), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)0.7857, (double)ova0.rejectionPrecision(), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)0.7778, (double)ova1.rejectionPrecision(), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)0.9091, (double)ova2.rejectionPrecision(), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)0.5625, (double)ova0.jaccardCoefficient(), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)0.3846, (double)ova1.jaccardCoefficient(), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)0.5714, (double)ova2.jaccardCoefficient(), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)0.7407, (double)ova0.accuracy(), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)0.7037, (double)ova1.accuracy(), (double)1.0E-4);
        junit.framework.Assert.assertEquals((double)0.8889, (double)ova2.accuracy(), (double)1.0E-4);
        junit.framework.Assert.assertEquals((int)4, (int)matrix.chiSquaredDegreesOfFreedom());
        junit.framework.Assert.assertEquals((int)3, (int)matrix.numCategories());
        junit.framework.Assert.assertEquals((double)15.5256, (double)matrix.chiSquared(), (double)0.005);
        junit.framework.Assert.assertEquals((double)6.2382, (double)ova0.chiSquared(), (double)0.005);
        junit.framework.Assert.assertEquals((double)3.0, (double)ova1.chiSquared(), (double)0.005);
        junit.framework.Assert.assertEquals((double)11.8519, (double)ova2.chiSquared(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.6826, (double)matrix.macroAvgPrecision(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.6574, (double)matrix.macroAvgRecall(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.6676, (double)matrix.macroAvgFMeasure(), (double)0.005);
        PrecisionRecallEvaluation microAvg = matrix.microAverage();
        junit.framework.Assert.assertEquals((double)0.6666, (double)microAvg.precision(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.6666, (double)microAvg.recall(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.6666, (double)microAvg.fMeasure(), (double)0.005);
        junit.framework.Assert.assertEquals((double)2.6197, (double)matrix.jointEntropy(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.8113, (double)matrix.conditionalEntropy(0), (double)0.005);
        junit.framework.Assert.assertEquals((double)1.3516, (double)matrix.conditionalEntropy(1), (double)0.005);
        junit.framework.Assert.assertEquals((double)1.2516, (double)matrix.conditionalEntropy(2), (double)0.005);
        junit.framework.Assert.assertEquals((double)1.0892, (double)matrix.conditionalEntropy(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.575, (double)matrix.phiSquared(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.5362, (double)matrix.cramersV(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.7838, (double)ova0.yulesQ(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.6279, (double)ova1.yulesQ(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.9512, (double)ova2.yulesQ(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.4835, (double)ova0.yulesY(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.3531, (double)ova1.yulesY(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.7269, (double)ova2.yulesY(), (double)0.005);
        junit.framework.Assert.assertEquals((double)12.49, (double)ova0.fowlkesMallows(), (double)0.05);
        junit.framework.Assert.assertEquals((double)9.0, (double)ova1.fowlkesMallows(), (double)0.05);
        junit.framework.Assert.assertEquals((double)5.48, (double)ova2.fowlkesMallows(), (double)0.05);
        junit.framework.Assert.assertEquals((double)0.4, (double)matrix.lambdaA(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.3571, (double)matrix.lambdaB(), (double)0.005);
        junit.framework.Assert.assertEquals((double)(matrix.responseEntropy() - matrix.conditionalEntropy()), (double)matrix.mutualInformation(), (double)0.005);
        junit.framework.Assert.assertEquals((double)0.007129, (double)matrix.klDivergence(), (double)5.0E-5);
    }
}

