/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.classify;

import com.aliasi.classify.PrecisionRecallEvaluation;
import com.aliasi.util.CollectionUtils;
import junit.framework.Assert;
import org.junit.Test;

public class PrecisionRecallEvaluationTest {
    @Test
    public void testSetCases() {
        PrecisionRecallEvaluation eval = new PrecisionRecallEvaluation();
        eval.addCases(CollectionUtils.asSet("a", "b", "c"), CollectionUtils.asSet("b", "c", "d", "e", "f"));
        Assert.assertEquals((long)2L, (long)eval.truePositive());
        Assert.assertEquals((long)1L, (long)eval.falseNegative());
        Assert.assertEquals((long)3L, (long)eval.falsePositive());
        Assert.assertEquals((long)0L, (long)eval.trueNegative());
    }

    @Test
    public void testOne() {
        PrecisionRecallEvaluation eval = new PrecisionRecallEvaluation(9L, 3L, 4L, 11L);
        Assert.assertEquals((long)12L, (long)eval.positiveReference());
        Assert.assertEquals((long)15L, (long)eval.negativeReference());
        Assert.assertEquals((long)13L, (long)eval.positiveResponse());
        Assert.assertEquals((long)14L, (long)eval.negativeResponse());
        Assert.assertEquals((long)27L, (long)eval.total());
        Assert.assertEquals((double)0.7407, (double)eval.accuracy(), (double)0.001);
        Assert.assertEquals((double)0.75, (double)eval.recall(), (double)0.001);
        Assert.assertEquals((double)0.6923, (double)eval.precision(), (double)0.001);
        Assert.assertEquals((double)0.7333, (double)eval.rejectionRecall(), (double)0.001);
        Assert.assertEquals((double)0.7858, (double)eval.rejectionPrecision(), (double)0.001);
        Assert.assertEquals((double)0.72, (double)eval.fMeasure(), (double)0.001);
        Assert.assertEquals((double)12.49, (double)eval.fowlkesMallows(), (double)0.001);
        Assert.assertEquals((double)0.5625, (double)eval.jaccardCoefficient(), (double)0.001);
        Assert.assertEquals((double)0.7838, (double)eval.yulesQ(), (double)0.001);
        Assert.assertEquals((double)0.4835, (double)eval.yulesY(), (double)0.001);
        Assert.assertEquals((double)0.4444, (double)eval.referenceLikelihood(), (double)0.001);
        Assert.assertEquals((double)0.4815, (double)eval.responseLikelihood(), (double)0.001);
        Assert.assertEquals((double)0.5021, (double)eval.randomAccuracy(), (double)0.001);
        Assert.assertEquals((double)0.4792, (double)eval.kappa(), (double)0.001);
        Assert.assertEquals((double)0.5027, (double)eval.randomAccuracyUnbiased(), (double)0.001);
        Assert.assertEquals((double)0.4789, (double)eval.kappaUnbiased(), (double)0.001);
        Assert.assertEquals((double)0.4814, (double)eval.kappaNoPrevalence(), (double)0.001);
        Assert.assertEquals((double)6.2382, (double)eval.chiSquared(), (double)0.001);
        Assert.assertEquals((double)0.231, (double)eval.phiSquared(), (double)0.001);
        Assert.assertEquals((double)0.0843, (double)eval.accuracyDeviation(), (double)0.001);
    }

    @Test
    public void testTwo() {
        PrecisionRecallEvaluation eval = new PrecisionRecallEvaluation(5L, 4L, 4L, 14L);
        Assert.assertEquals((long)9L, (long)eval.positiveReference());
        Assert.assertEquals((long)18L, (long)eval.negativeReference());
        Assert.assertEquals((long)9L, (long)eval.positiveResponse());
        Assert.assertEquals((long)18L, (long)eval.negativeResponse());
        Assert.assertEquals((long)27L, (long)eval.total());
        Assert.assertEquals((double)0.7037, (double)eval.accuracy(), (double)0.001);
        Assert.assertEquals((double)0.5555, (double)eval.recall(), (double)0.001);
        Assert.assertEquals((double)0.5555, (double)eval.precision(), (double)0.001);
        Assert.assertEquals((double)0.7778, (double)eval.rejectionRecall(), (double)0.001);
        Assert.assertEquals((double)0.7778, (double)eval.rejectionPrecision(), (double)0.001);
        Assert.assertEquals((double)0.5555, (double)eval.fMeasure(), (double)0.001);
        Assert.assertEquals((double)9.0, (double)eval.fowlkesMallows(), (double)0.001);
        Assert.assertEquals((double)0.3846, (double)eval.jaccardCoefficient(), (double)0.001);
        Assert.assertEquals((double)0.6279, (double)eval.yulesQ(), (double)0.001);
        Assert.assertEquals((double)0.3531, (double)eval.yulesY(), (double)0.001);
        Assert.assertEquals((double)0.3333, (double)eval.referenceLikelihood(), (double)0.001);
        Assert.assertEquals((double)0.3333, (double)eval.responseLikelihood(), (double)0.001);
        Assert.assertEquals((double)0.5556, (double)eval.randomAccuracy(), (double)0.001);
        Assert.assertEquals((double)0.3333, (double)eval.kappa(), (double)0.001);
        Assert.assertEquals((double)0.5556, (double)eval.randomAccuracyUnbiased(), (double)0.001);
        Assert.assertEquals((double)0.333, (double)eval.kappaUnbiased(), (double)0.001);
        Assert.assertEquals((double)0.4074, (double)eval.kappaNoPrevalence(), (double)0.001);
        Assert.assertEquals((double)3.0, (double)eval.chiSquared(), (double)0.001);
        Assert.assertEquals((double)0.1111, (double)eval.phiSquared(), (double)0.001);
        Assert.assertEquals((double)0.0879, (double)eval.accuracyDeviation(), (double)0.001);
    }

    @Test
    public void testThree() {
        PrecisionRecallEvaluation eval = new PrecisionRecallEvaluation(4L, 2L, 1L, 20L);
        Assert.assertEquals((long)6L, (long)eval.positiveReference());
        Assert.assertEquals((long)21L, (long)eval.negativeReference());
        Assert.assertEquals((long)5L, (long)eval.positiveResponse());
        Assert.assertEquals((long)22L, (long)eval.negativeResponse());
        Assert.assertEquals((long)27L, (long)eval.total());
        Assert.assertEquals((double)0.8889, (double)eval.accuracy(), (double)0.001);
        Assert.assertEquals((double)0.6666, (double)eval.recall(), (double)0.001);
        Assert.assertEquals((double)0.8, (double)eval.precision(), (double)0.001);
        Assert.assertEquals((double)0.9524, (double)eval.rejectionRecall(), (double)0.001);
        Assert.assertEquals((double)0.9091, (double)eval.rejectionPrecision(), (double)0.001);
        Assert.assertEquals((double)0.7272, (double)eval.fMeasure(), (double)0.001);
        Assert.assertEquals((double)5.4772, (double)eval.fowlkesMallows(), (double)0.001);
        Assert.assertEquals((double)0.5714, (double)eval.jaccardCoefficient(), (double)0.001);
        Assert.assertEquals((double)0.9512, (double)eval.yulesQ(), (double)0.001);
        Assert.assertEquals((double)0.7269, (double)eval.yulesY(), (double)0.001);
        Assert.assertEquals((double)0.2222, (double)eval.referenceLikelihood(), (double)0.001);
        Assert.assertEquals((double)0.1852, (double)eval.responseLikelihood(), (double)0.001);
        Assert.assertEquals((double)0.6749, (double)eval.randomAccuracy(), (double)0.001);
        Assert.assertEquals((double)0.6583, (double)eval.kappa(), (double)0.001);
        Assert.assertEquals((double)0.6756, (double)eval.randomAccuracyUnbiased(), (double)0.001);
        Assert.assertEquals((double)0.6575, (double)eval.kappaUnbiased(), (double)0.001);
        Assert.assertEquals((double)0.7778, (double)eval.kappaNoPrevalence(), (double)0.001);
        Assert.assertEquals((double)11.8519, (double)eval.chiSquared(), (double)0.001);
        Assert.assertEquals((double)0.439, (double)eval.phiSquared(), (double)0.001);
        Assert.assertEquals((double)0.0605, (double)eval.accuracyDeviation(), (double)0.001);
    }
}

