/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.classify;

import com.aliasi.classify.ScoredPrecisionRecallEvaluation;
import com.aliasi.test.unit.Asserts;
import junit.framework.Assert;
import org.junit.Test;

public class ScoredPrecisionRecallEvaluationTest {
    static ScoredPrecisionRecallEvaluation testCase() {
        ScoredPrecisionRecallEvaluation eval = new ScoredPrecisionRecallEvaluation();
        eval.addCase(false, -1.21);
        eval.addCase(true, -1.27);
        eval.addCase(false, -1.39);
        eval.addCase(true, -1.47);
        eval.addCase(true, -1.6);
        eval.addCase(false, -1.65);
        eval.addCase(false, -1.79);
        eval.addCase(false, -1.8);
        eval.addCase(true, -2.01);
        eval.addCase(false, -3.7);
        eval.addMisses(1);
        return eval;
    }

    static ScoredPrecisionRecallEvaluation testCaseWithTies() {
        ScoredPrecisionRecallEvaluation eval = new ScoredPrecisionRecallEvaluation();
        eval.addCase(false, -1.21);
        eval.addCase(true, -1.21);
        eval.addCase(false, -1.39);
        eval.addCase(true, -1.47);
        eval.addCase(true, -1.6);
        eval.addCase(false, -1.5999999999995);
        eval.addCase(false, -1.79);
        eval.addCase(false, -1.8);
        eval.addCase(true, -2.01);
        eval.addCase(false, -2.01);
        eval.addMisses(1);
        return eval;
    }

    static ScoredPrecisionRecallEvaluation rocTestCaseWithTies() {
        ScoredPrecisionRecallEvaluation eval = new ScoredPrecisionRecallEvaluation();
        eval.addCase(true, 1.0);
        eval.addCase(false, 1.0);
        eval.addCase(true, 0.3);
        eval.addCase(false, 0.2);
        eval.addCase(true, 0.2);
        eval.addCase(true, 0.1);
        eval.addCase(false, 0.0);
        eval.addCase(true, 0.0);
        return eval;
    }

    static ScoredPrecisionRecallEvaluation rocInvertedTestCaseWithTies() {
        ScoredPrecisionRecallEvaluation eval = new ScoredPrecisionRecallEvaluation();
        eval.addCase(false, 0.0);
        eval.addCase(true, 0.0);
        eval.addCase(false, 0.7);
        eval.addCase(true, 0.8);
        eval.addCase(false, 0.8000000000005001);
        eval.addCase(false, 0.9);
        eval.addCase(true, 1.0);
        eval.addCase(false, 1.0);
        return eval;
    }

    @Test
    public void rPrecisionTest() {
        ScoredPrecisionRecallEvaluation eval = ScoredPrecisionRecallEvaluationTest.testCase();
        double rPrecision = eval.rPrecision();
        double expRPrecision = 0.6;
        Assert.assertEquals((double)expRPrecision, (double)rPrecision, (double)1.0E-4);
    }

    @Test
    public void elevenPtInterpPrecTest() {
        ScoredPrecisionRecallEvaluation eval = ScoredPrecisionRecallEvaluationTest.testCase();
        double[] precs = eval.elevenPtInterpPrecision();
        double[] expectedPrecs = new double[]{1.0, 0.6, 0.6, 0.6, 0.6, 0.6, 0.6, 0.444, 0.444, 0.0, 0.0};
        Asserts.assertEqualsArray(expectedPrecs, precs, 0.01);
    }

    @Test
    public void averagePrecisionTest() {
        ScoredPrecisionRecallEvaluation eval = ScoredPrecisionRecallEvaluationTest.testCase();
        double[][] rps = eval.prCurve(false);
        double expectedAvgPrecision = 0.40888;
        double avgPrecision = eval.averagePrecision();
        Assert.assertEquals((double)expectedAvgPrecision, (double)avgPrecision, (double)0.001);
    }

    @Test
    public void rocCurveTest() {
        ScoredPrecisionRecallEvaluation eval = ScoredPrecisionRecallEvaluationTest.testCase();
        double[][] expectedRocCurve = new double[][]{{0.0, 0.0}, {0.16700000000000004, 0.0}, {0.16700000000000004, 0.2}, {0.33299999999999996, 0.2}, {0.33299999999999996, 0.4}, {0.33299999999999996, 0.6}, {0.5, 0.6}, {0.667, 0.6}, {0.833, 0.6}, {0.833, 0.8}, {1.0, 0.8}, {1.0, 1.0}};
        double[][] rocCurve = eval.rocCurve(false);
        Asserts.assertEqualsArray2D(expectedRocCurve, rocCurve, 0.01);
        double[][] expectedInterpolatedRocCurve = new double[][]{{0.0, 0.0}, {0.16700000000000004, 0.2}, {0.33299999999999996, 0.6}, {0.5, 0.6}, {0.667, 0.6}, {0.833, 0.8}, {1.0, 1.0}};
        double[][] interpolatedRocCurve = eval.rocCurve(true);
        Asserts.assertEqualsArray2D(expectedInterpolatedRocCurve, interpolatedRocCurve, 0.01);
        Assert.assertEquals((double)0.55, (double)eval.areaUnderRocCurve(true), (double)0.001);
        ScoredPrecisionRecallEvaluation evalWithTies = ScoredPrecisionRecallEvaluationTest.rocTestCaseWithTies();
        ScoredPrecisionRecallEvaluation evalWithTiesInverted = ScoredPrecisionRecallEvaluationTest.rocInvertedTestCaseWithTies();
        Assert.assertEquals((double)0.5, (double)evalWithTies.areaUnderRocCurve(false), (double)0.001);
        Assert.assertEquals((double)evalWithTiesInverted.areaUnderRocCurve(false), (double)evalWithTies.areaUnderRocCurve(false), (double)0.001);
    }

    static void print(String msg, double[][] rocCurve) {
        System.out.println("\n" + msg);
        for (double[] rs : rocCurve) {
            System.out.printf("sens=%5.3f spec=%5.3f\n", rs[0], rs[1]);
        }
    }

    @Test
    public void prCurveTest() {
        ScoredPrecisionRecallEvaluation eval = ScoredPrecisionRecallEvaluationTest.testCase();
        double[][] expectedRps = new double[][]{{0.0, 1.0}, {0.2, 0.5}, {0.2, 0.33}, {0.4, 0.5}, {0.6, 0.6}, {0.6, 0.5}, {0.6, 0.43}, {0.6, 0.38}, {0.8, 0.44}, {0.8, 0.4}, {1.0, 0.0}};
        double[][] rps = eval.prCurve(false);
        Asserts.assertEqualsArray2D(expectedRps, rps, 0.01);
        double[][] expectedInterpolatedPrs = new double[][]{{0.0, 1.0}, {0.2, 0.6}, {0.4, 0.6}, {0.6, 0.6}, {0.8, 0.44}, {1.0, 0.0}};
        double[][] interpolatedRps = eval.prCurve(true);
        Asserts.assertEqualsArray2D(expectedInterpolatedPrs, interpolatedRps, 0.01);
        ScoredPrecisionRecallEvaluation eval2 = ScoredPrecisionRecallEvaluationTest.testCaseWithTies();
        double[][] expectedRps2 = new double[][]{{0.0, 1.0}, {0.2, 0.5}, {0.2, 0.33}, {0.4, 0.5}, {0.6, 0.5}, {0.6, 0.43}, {0.6, 0.38}, {0.8, 0.4}, {1.0, 0.0}};
        double[][] rps2 = eval2.prCurve(false);
        Asserts.assertEqualsArray2D(expectedRps2, rps2, 0.01);
        double[][] expectedInterpolatedRps2 = new double[][]{{0.0, 1.0}, {0.2, 0.5}, {0.4, 0.5}, {0.6, 0.5}, {0.8, 0.4}, {1.0, 0.0}};
        double[][] rps2Interpolated = eval2.prCurve(true);
        Asserts.assertEqualsArray2D(expectedInterpolatedRps2, rps2Interpolated, 0.01);
    }

    @Test
    public void testMaxF() {
        ScoredPrecisionRecallEvaluation eval = ScoredPrecisionRecallEvaluationTest.testCase();
        double maxF = eval.maximumFMeasure();
        double expectedMaxF = 0.6;
        Assert.assertEquals((double)expectedMaxF, (double)maxF, (double)0.001);
    }

    @Test
    public void testPrecisionAtN() {
        ScoredPrecisionRecallEvaluation eval = ScoredPrecisionRecallEvaluationTest.testCase();
        Assert.assertEquals((double)1.0, (double)eval.precisionAt(0), (double)0.001);
        Assert.assertEquals((double)0.0, (double)eval.precisionAt(1), (double)0.001);
        Assert.assertEquals((double)0.6, (double)eval.precisionAt(5), (double)0.001);
        Assert.assertEquals((double)0.4, (double)eval.precisionAt(10), (double)0.001);
        Assert.assertEquals((double)0.2, (double)eval.precisionAt(20), (double)0.001);
        Assert.assertEquals((double)0.04, (double)eval.precisionAt(100), (double)0.001);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPrecisionAtNExc() {
        ScoredPrecisionRecallEvaluation eval = ScoredPrecisionRecallEvaluationTest.testCase();
        eval.precisionAt(-1);
    }

    @Test
    public void testReciprocalRank() {
        ScoredPrecisionRecallEvaluation eval = ScoredPrecisionRecallEvaluationTest.testCase();
        Assert.assertEquals((double)0.5, (double)eval.reciprocalRank(), (double)0.001);
    }

    @Test
    public void testRPrecision() {
        ScoredPrecisionRecallEvaluation eval = ScoredPrecisionRecallEvaluationTest.testCase();
        Assert.assertEquals((double)0.6, (double)eval.rPrecision(), (double)0.001);
    }
}

