/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.classify;

import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.ScoredClassification;
import com.aliasi.classify.ScoredClassifier;
import com.aliasi.classify.TfIdfClassifierTrainer;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.TokenFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import junit.framework.Assert;
import org.junit.Test;

public class TfIdfClassifierTrainerTest {
    @Test
    public void testTf() {
        TokenFeatureExtractor featureExtractor = new TokenFeatureExtractor(IndoEuropeanTokenizerFactory.INSTANCE);
        TfIdfClassifierTrainer<CharSequence> trainer = new TfIdfClassifierTrainer<CharSequence>(featureExtractor);
        TfIdfClassifierTrainerTest.handle(trainer, "a b b", "cat1");
        TfIdfClassifierTrainerTest.handle(trainer, "b c c c d", "cat2");
        TfIdfClassifierTrainerTest.handle(trainer, "c c c c c", "cat3");
        TfIdfClassifierTrainerTest.handle(trainer, "a d", "cat1");
        Assert.assertEquals((Object)Math.sqrt(2.0), (Object)trainer.tf("a", "cat1"));
        Assert.assertEquals((Object)0.0, (Object)trainer.tf("c", "cat1"));
        Assert.assertEquals((Object)Math.sqrt(5.0), (Object)trainer.tf("c", "cat3"));
        Assert.assertEquals((Object)0.0, (Object)trainer.tf("foo", "cat1"));
    }

    @Test
    public void testIdf() {
        TokenFeatureExtractor featureExtractor = new TokenFeatureExtractor(IndoEuropeanTokenizerFactory.INSTANCE);
        TfIdfClassifierTrainer<CharSequence> trainer = new TfIdfClassifierTrainer<CharSequence>(featureExtractor);
        TfIdfClassifierTrainerTest.handle(trainer, "a b b", "cat1");
        TfIdfClassifierTrainerTest.handle(trainer, "b c c c d", "cat2");
        TfIdfClassifierTrainerTest.handle(trainer, "b c c c c c", "cat3");
        Assert.assertEquals((Object)Math.log(3.0), (Object)trainer.idf("a"));
        Assert.assertEquals((Object)Math.log(1.5), (Object)trainer.idf("c"));
        Assert.assertEquals((Object)Math.log(1.0), (Object)trainer.idf("b"));
        Assert.assertEquals((Object)0.0, (Object)trainer.idf("foo"));
    }

    @Test
    public void testTfIdf() {
        TokenFeatureExtractor featureExtractor = new TokenFeatureExtractor(IndoEuropeanTokenizerFactory.INSTANCE);
        TfIdfClassifierTrainer<CharSequence> trainer = new TfIdfClassifierTrainer<CharSequence>(featureExtractor);
        TfIdfClassifierTrainerTest.handle(trainer, "a b b", "cat1");
        TfIdfClassifierTrainerTest.handle(trainer, "b c c c d", "cat2");
        TfIdfClassifierTrainerTest.handle(trainer, "b c c c c c", "cat3");
        Assert.assertEquals((Object)0.0, (Object)trainer.tfIdf("foo", "bar"));
        Assert.assertEquals((Object)0.0, (Object)trainer.tfIdf("a", "bar"));
        Assert.assertEquals((Object)0.0, (Object)trainer.tfIdf("foo", "cat1"));
        Assert.assertEquals((Object)Math.sqrt(1.0), (Object)trainer.tf("a", "cat1"));
        Assert.assertEquals((Object)Math.log(3.0), (Object)trainer.idf("a"));
        Assert.assertEquals((Object)(Math.sqrt(1.0) * Math.log(3.0)), (Object)trainer.tfIdf("a", "cat1"));
        Assert.assertEquals((Object)(Math.sqrt(2.0) * Math.log(1.0)), (Object)trainer.tfIdf("b", "cat1"));
        Assert.assertEquals((Object)0.0, (Object)trainer.tfIdf("c", "cat1"));
        Assert.assertEquals((Object)0.0, (Object)trainer.tfIdf("d", "cat1"));
        Assert.assertEquals((Object)(Math.sqrt(0.0) * Math.log(3.0)), (Object)trainer.tfIdf("a", "cat2"));
        Assert.assertEquals((Object)(Math.sqrt(2.0) * Math.log(1.0)), (Object)trainer.tfIdf("b", "cat2"));
        Assert.assertEquals((Object)(Math.sqrt(3.0) * Math.log(1.5)), (Object)trainer.tfIdf("c", "cat2"));
        Assert.assertEquals((Object)(Math.sqrt(1.0) * Math.log(3.0)), (Object)trainer.tfIdf("d", "cat2"));
        Assert.assertEquals((Object)(Math.sqrt(0.0) * Math.log(3.0)), (Object)trainer.tfIdf("a", "cat3"));
        Assert.assertEquals((Object)(Math.sqrt(1.0) * Math.log(1.0)), (Object)trainer.tfIdf("b", "cat3"));
        Assert.assertEquals((Object)(Math.sqrt(5.0) * Math.log(1.5)), (Object)trainer.tfIdf("c", "cat3"));
        Assert.assertEquals((Object)0.0, (Object)trainer.tfIdf("d", "cat3"));
    }

    static void handle(TfIdfClassifierTrainer classifier, String input, Classification c) {
        classifier.handle(new Classified<String>(input, c));
    }

    static void handle(TfIdfClassifierTrainer classifier, String input, String cat) {
        TfIdfClassifierTrainerTest.handle(classifier, input, new Classification(cat));
    }

    @Test
    public void testOne() throws Exception {
        TokenFeatureExtractor featureExtractor = new TokenFeatureExtractor(IndoEuropeanTokenizerFactory.INSTANCE);
        TfIdfClassifierTrainer<CharSequence> trainer = new TfIdfClassifierTrainer<CharSequence>(featureExtractor);
        TfIdfClassifierTrainerTest.handle(trainer, "a b b", new Classification("cat1"));
        TfIdfClassifierTrainerTest.handle(trainer, "b c c c d", new Classification("cat2"));
        TfIdfClassifierTrainerTest.handle(trainer, "c c c c c", new Classification("cat3"));
        double cat1_a = Math.sqrt(1.0) * Math.log(3.0);
        double cat1_b = Math.sqrt(2.0) * Math.log(1.5);
        double len1 = Math.sqrt(cat1_a * cat1_a + cat1_b * cat1_b);
        double cat1_a_n = cat1_a / len1;
        double cat1_b_n = cat1_b / len1;
        double cat2_b = Math.sqrt(1.0) * Math.log(1.5);
        double cat2_c = Math.sqrt(3.0) * Math.log(1.5);
        double cat2_d = Math.sqrt(1.0) * Math.log(3.0);
        double len2 = Math.sqrt(cat2_b * cat2_b + cat2_c * cat2_c + cat2_d * cat2_d);
        double cat2_b_n = cat2_b / len2;
        double cat2_c_n = cat2_c / len2;
        double cat2_d_n = cat2_d / len2;
        double cat3_c = Math.sqrt(5.0) * Math.log(1.5);
        double len3 = Math.sqrt(cat3_c * cat3_c);
        double cat3_c_n = cat3_c / len3;
        ScoredClassifier classifier = (ScoredClassifier)AbstractExternalizable.compile(trainer);
        ScoredClassification classification = classifier.classify("a b b");
        Assert.assertEquals((String)"cat1", (String)classification.bestCategory());
        Assert.assertEquals((String)"cat1", (String)classification.category(0));
        Assert.assertEquals((double)1.0, (double)classification.score(0), (double)0.001);
        Assert.assertEquals((String)"cat2", (String)classification.category(1));
        Assert.assertEquals((double)(cat1_b_n * cat2_b_n), (double)classification.score(1), (double)0.05);
        Assert.assertEquals((String)"cat3", (String)classification.category(2));
        Assert.assertEquals((double)0.0, (double)classification.score(2), (double)0.001);
        TfIdfClassifierTrainer trainer2 = (TfIdfClassifierTrainer)AbstractExternalizable.serializeDeserialize(trainer);
        ScoredClassifier classifier2 = (ScoredClassifier)AbstractExternalizable.compile(trainer2);
        Assert.assertEquals((String)"cat1", (String)classification.bestCategory());
        Assert.assertEquals((String)"cat1", (String)classification.category(0));
        Assert.assertEquals((double)1.0, (double)classification.score(0), (double)0.001);
        Assert.assertEquals((String)"cat2", (String)classification.category(1));
        Assert.assertEquals((double)(cat1_b_n * cat2_b_n), (double)classification.score(1), (double)0.05);
        Assert.assertEquals((String)"cat3", (String)classification.category(2));
        Assert.assertEquals((double)0.0, (double)classification.score(2), (double)0.001);
    }
}

