/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.classify;

import com.aliasi.classify.Classification;
import com.aliasi.classify.Classified;
import com.aliasi.classify.ConditionalClassification;
import com.aliasi.classify.ConditionalClassifier;
import com.aliasi.classify.JointClassification;
import com.aliasi.classify.JointClassifier;
import com.aliasi.classify.TradNaiveBayesClassifier;
import com.aliasi.test.unit.Asserts;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.TokenizerFactory;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.Math;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class TradNaiveBayesClassifierTest {
    static final String[] CATS_2 = new String[]{"a", "b"};
    static final Set<String> CAT_SET_2 = TradNaiveBayesClassifierTest.listToSet(CATS_2);
    static final TokenizerFactory TOKENIZER_FACTORY = IndoEuropeanTokenizerFactory.INSTANCE;

    @Test
    public void testSetLengthNorm() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(TradNaiveBayesClassifierTest.listToSet(new String[]{"a", "b"}), TOKENIZER_FACTORY, 1.0, 1.0, 10.0);
        Assert.assertEquals((double)10.0, (double)classifier.lengthNorm(), (double)1.0E-4);
        classifier.setLengthNorm(Double.NaN);
        Assert.assertTrue((boolean)Double.isNaN(classifier.lengthNorm()));
        classifier.setLengthNorm(20.0);
        Assert.assertEquals((double)20.0, (double)classifier.lengthNorm(), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetLengthNormNegExc() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(TradNaiveBayesClassifierTest.listToSet(new String[]{"a", "b"}), TOKENIZER_FACTORY, 1.0, 1.0, -1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetLengthNormNegExc2() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(TradNaiveBayesClassifierTest.listToSet(new String[]{"a", "b"}), TOKENIZER_FACTORY, 1.0, 1.0, 10.0);
        classifier.setLengthNorm(Double.POSITIVE_INFINITY);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetLengthNormInfExc() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(TradNaiveBayesClassifierTest.listToSet(new String[]{"a", "b"}), TOKENIZER_FACTORY, 1.0, 1.0, Double.POSITIVE_INFINITY);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetLengthNormInfExc2() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(TradNaiveBayesClassifierTest.listToSet(new String[]{"a", "b"}), TOKENIZER_FACTORY, 1.0, 1.0, 10.0);
        classifier.setLengthNorm(Double.POSITIVE_INFINITY);
    }

    @Test
    public void testTrain() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(TradNaiveBayesClassifierTest.listToSet(new String[]{"a", "b"}), TOKENIZER_FACTORY, 1.0, 1.0, Double.NaN);
        try {
            classifier.train("", new Classification("a"), -1.0);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        classifier.train("john ran", new Classification("a"), 2.0);
        classifier.train("john ran", new Classification("a"), -1.0);
        classifier.train("john ran", new Classification("a"), -1.0);
        classifier.train("run, mary, run", new Classification("b"), 3.0);
        classifier.train("john jumped", new Classification("a"), 3.0);
        try {
            classifier.train("john ran", new Classification("a"), -1.0);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            classifier.train("mary hopscotched", new Classification("a"), -1.0);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        classifier.train("john ran", new Classification("a"), 3.0);
        classifier.train("mary ran", new Classification("b"), 3.0);
        classifier.train("john ran", new Classification("a"), -2.0);
        classifier.train("john jumped", new Classification("a"), -2.0);
        classifier.train("mary ran", new Classification("b"), -2.0);
        classifier.train("run, mary, run", new Classification("b"), -2.0);
        classifier.setLengthNorm(10.0);
        Assert.assertEquals((double)0.3, (double)classifier.probToken("john", "a"), (double)0.001);
        Assert.assertEquals((double)0.15384615384615385, (double)classifier.probToken("ran", "b"), (double)0.001);
        Assert.assertEquals((double)0.1, (double)classifier.probToken("run", "a"), (double)0.001);
        Assert.assertEquals((double)0.5, (double)classifier.probCat("a"), (double)0.001);
        Assert.assertEquals((double)0.5, (double)classifier.probCat("b"), (double)0.001);
    }

    @Test
    public void testLengthNormStore() throws IOException {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(TradNaiveBayesClassifierTest.listToSet(new String[]{"a", "b"}), TOKENIZER_FACTORY, 1.0, 1.0, 42.0);
        Assert.assertEquals((double)42.0, (double)classifier.lengthNorm(), (double)1.0E-4);
        TradNaiveBayesClassifier classifier2 = (TradNaiveBayesClassifier)AbstractExternalizable.serializeDeserialize(classifier);
        Assert.assertEquals((double)42.0, (double)classifier2.lengthNorm(), (double)1.0E-4);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCatsEmpty() {
        new TradNaiveBayesClassifier(TradNaiveBayesClassifierTest.listToSet(new String[0]), TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testCats1() {
        String[] cats = new String[]{"foo"};
        new TradNaiveBayesClassifier(TradNaiveBayesClassifierTest.listToSet(cats), TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegCatPrior() {
        new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, -1.0, 1.0, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNaNCatPrior() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, Double.NaN, 1.0, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testInfCatPrior() {
        new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, Double.POSITIVE_INFINITY, 1.0, 1.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testNegWordPrior() {
        new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, -1.0, 1.0);
    }

    @Test
    public void testCatSet() {
        String[] cats = new String[]{"a", "c", "d", "b"};
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(TradNaiveBayesClassifierTest.listToSet(cats), TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
        Assert.assertEquals(new HashSet<String>(Arrays.asList(cats)), classifier.categorySet());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLengthNormInf() {
        new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, Double.POSITIVE_INFINITY);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLengthNormZero() {
        new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testLengthNormNeg() {
        new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, -12.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testUnknownCatTrainException() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
        classifier.handle(new Classified<CharSequence>("any old string", new Classification("unknownCat")));
    }

    @Test
    public void knownTokenTest() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
        classifier.handle(new Classified<CharSequence>("john ran", new Classification("a")));
        Assert.assertTrue((boolean)classifier.isKnownToken("john"));
        Assert.assertTrue((boolean)classifier.isKnownToken("ran"));
        Assert.assertFalse((boolean)classifier.isKnownToken("unknownTok"));
    }

    static void handle(TradNaiveBayesClassifier classifier, String input, Classification c) {
        classifier.handle(new Classified<CharSequence>(input, c));
    }

    @Test
    public void log2CaseProbTest() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, Double.NaN);
        classifier.handle(new Classified<CharSequence>("john ran", new Classification("a")));
        TradNaiveBayesClassifierTest.handle(classifier, "john jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "run, mary, run", new Classification("b"));
        Assert.assertEquals((double)Math.log2(classifier.probCat("a") * classifier.probToken("mary", "a") * classifier.probToken("jumped", "a") + classifier.probCat("b") * classifier.probToken("mary", "b") * classifier.probToken("jumped", "b")), (double)classifier.log2CaseProb("mary jumped"), (double)0.001);
        Assert.assertEquals((double)Math.log2(classifier.probCat("a") + classifier.probCat("b")), (double)classifier.log2CaseProb(""), (double)1.0E-4);
    }

    @Test
    public void probTokenTest() throws IOException {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, Double.NaN);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "run, mary, run", new Classification("b"));
        Assert.assertEquals((double)0.3, (double)classifier.probToken("john", "a"), (double)0.001);
        Assert.assertEquals((double)0.15384615384615385, (double)classifier.probToken("ran", "b"), (double)0.001);
        Assert.assertEquals((double)0.1, (double)classifier.probToken("run", "a"), (double)0.001);
        TradNaiveBayesClassifier classifier2 = (TradNaiveBayesClassifier)AbstractExternalizable.serializeDeserialize(classifier);
        Assert.assertEquals((double)0.3, (double)classifier2.probToken("john", "a"), (double)0.001);
        Assert.assertEquals((double)0.15384615384615385, (double)classifier2.probToken("ran", "b"), (double)0.001);
        Assert.assertEquals((double)0.1, (double)classifier2.probToken("run", "a"), (double)0.001);
        Assert.assertEquals(classifier.categorySet(), classifier2.categorySet());
        Assert.assertEquals(classifier.knownTokenSet(), classifier2.knownTokenSet());
        Assert.assertFalse((boolean)classifier2.isKnownToken("thisisoneidon'tknow"));
        for (String token : classifier.knownTokenSet()) {
            Assert.assertTrue((boolean)classifier.isKnownToken(token));
            Assert.assertTrue((boolean)classifier2.isKnownToken(token));
        }
    }

    @Test(expected=IllegalArgumentException.class)
    public void probTokenTestUnknownToken() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        classifier.probToken("unknownTok", "a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void probTokenTestUnknownTokenSerDeser() throws IOException {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifier classifier2 = (TradNaiveBayesClassifier)AbstractExternalizable.serializeDeserialize(classifier);
        classifier2.probToken("unknownTok", "a");
    }

    @Test(expected=IllegalArgumentException.class)
    public void probTokenTestUnknownCat() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        classifier.probToken("john", "unknownCat");
    }

    @Test(expected=IllegalArgumentException.class)
    public void probTokenTestUnknownCatSerDeser() throws IOException {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifier classifier2 = (TradNaiveBayesClassifier)AbstractExternalizable.serializeDeserialize(classifier);
        classifier2.probToken("john", "unknownCat");
    }

    @Test
    public void testKnownTokenSet() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
        Set<String> knownTokenSet = classifier.knownTokenSet();
        HashSet<String> expectedTokenSet = new HashSet<String>();
        Assert.assertEquals(expectedTokenSet, knownTokenSet);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        expectedTokenSet.add("john");
        expectedTokenSet.add("ran");
        Assert.assertEquals(expectedTokenSet, knownTokenSet);
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        expectedTokenSet.add("mary");
        Assert.assertEquals(expectedTokenSet, knownTokenSet);
        for (String token : knownTokenSet) {
            Assert.assertTrue((boolean)classifier.isKnownToken(token));
        }
    }

    @Test
    public void testProbCat() throws IOException {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, Double.NaN);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john ran and jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "run, mary, run", new Classification("b"));
        Assert.assertEquals((double)0.5714285714285714, (double)classifier.probCat("a"), (double)1.0E-5);
        Assert.assertEquals((double)0.4285714285714286, (double)classifier.probCat("b"), (double)1.0E-5);
        TradNaiveBayesClassifier classifier2 = (TradNaiveBayesClassifier)AbstractExternalizable.serializeDeserialize(classifier);
        Assert.assertEquals((double)0.5714285714285714, (double)classifier2.probCat("a"), (double)1.0E-5);
        Assert.assertEquals((double)0.4285714285714286, (double)classifier2.probCat("b"), (double)1.0E-5);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testProbCatUnknownCatExc() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john ran and jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "run, mary, run", new Classification("b"));
        classifier.probCat("unknownCat");
    }

    @Test(expected=IllegalArgumentException.class)
    public void testProbCatUnknownCatExcSerDeser() throws IOException {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, 1.0);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john ran and jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "run, mary, run", new Classification("b"));
        TradNaiveBayesClassifier classifier2 = (TradNaiveBayesClassifier)AbstractExternalizable.serializeDeserialize(classifier);
        classifier2.probCat("unknownCat");
    }

    @Test
    public void testClassification() {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, Double.NaN);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "run, mary, run", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary run", new Classification("b"));
        JointClassification c = classifier.classify("");
        Assert.assertEquals((int)2, (int)c.size());
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"b", (String)c.category(0));
        Assert.assertEquals((double)0.42857142857142855, (double)c.conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((double)0.5714285714285714, (double)c.conditionalProbability(0), (double)1.0E-4);
        JointClassification c2 = classifier.classify("backbends");
        Assert.assertEquals((int)2, (int)c2.size());
        Assert.assertEquals((String)"a", (String)c2.category(1));
        Assert.assertEquals((String)"b", (String)c2.category(0));
        Assert.assertEquals((double)0.42857142857142855, (double)c2.conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((double)0.5714285714285714, (double)c2.conditionalProbability(0), (double)1.0E-4);
        JointClassification c3 = classifier.classify("john");
        Assert.assertEquals((String)"a", (String)c3.category(0));
        Assert.assertEquals((String)"b", (String)c3.category(1));
        double z3 = 0.16666666666666666;
        Assert.assertEquals((double)(0.12857142857142856 / z3), (double)c3.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)(0.0380952380952381 / z3), (double)c3.conditionalProbability(1), (double)1.0E-4);
        JointClassification c4 = classifier.classify("john smith was here");
        Assert.assertEquals((String)"a", (String)c4.category(0));
        Assert.assertEquals((String)"b", (String)c4.category(1));
        double z4 = 0.16666666666666666;
        Assert.assertEquals((double)(0.12857142857142856 / z4), (double)c4.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)(0.0380952380952381 / z4), (double)c4.conditionalProbability(1), (double)1.0E-4);
        JointClassification c5 = classifier.classify("john saw mary");
        Assert.assertEquals((String)"a", (String)c5.category(0));
        Assert.assertEquals((String)"b", (String)c5.category(1));
        double z5 = 0.023015873015873017;
        Assert.assertEquals((double)(0.012857142857142857 / z5), (double)c5.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)(0.010158730158730159 / z5), (double)c5.conditionalProbability(1), (double)1.0E-4);
    }

    @Test
    public void testClassificationSerDeser() throws IOException {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, Double.NaN);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "run, mary, run", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary run", new Classification("b"));
        TradNaiveBayesClassifier classifier2 = (TradNaiveBayesClassifier)AbstractExternalizable.serializeDeserialize(classifier);
        JointClassification c = classifier2.classify("");
        Assert.assertEquals((int)2, (int)c.size());
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"b", (String)c.category(0));
        Assert.assertEquals((double)0.42857142857142855, (double)c.conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((double)0.5714285714285714, (double)c.conditionalProbability(0), (double)1.0E-4);
        JointClassification c2 = classifier2.classify("backbends");
        Assert.assertEquals((int)2, (int)c2.size());
        Assert.assertEquals((String)"a", (String)c2.category(1));
        Assert.assertEquals((String)"b", (String)c2.category(0));
        Assert.assertEquals((double)0.42857142857142855, (double)c2.conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((double)0.5714285714285714, (double)c2.conditionalProbability(0), (double)1.0E-4);
        JointClassification c3 = classifier2.classify("john");
        Assert.assertEquals((String)"a", (String)c3.category(0));
        Assert.assertEquals((String)"b", (String)c3.category(1));
        double z3 = 0.16666666666666666;
        Assert.assertEquals((double)(0.12857142857142856 / z3), (double)c3.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)(0.0380952380952381 / z3), (double)c3.conditionalProbability(1), (double)1.0E-4);
        JointClassification c4 = classifier2.classify("john smith was here");
        Assert.assertEquals((String)"a", (String)c4.category(0));
        Assert.assertEquals((String)"b", (String)c4.category(1));
        double z4 = 0.16666666666666666;
        Assert.assertEquals((double)(0.12857142857142856 / z4), (double)c4.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)(0.0380952380952381 / z4), (double)c4.conditionalProbability(1), (double)1.0E-4);
        JointClassification c5 = classifier2.classify("john saw mary");
        Assert.assertEquals((String)"a", (String)c5.category(0));
        Assert.assertEquals((String)"b", (String)c5.category(1));
        double z5 = 0.023015873015873017;
        Assert.assertEquals((double)(0.012857142857142857 / z5), (double)c5.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)(0.010158730158730159 / z5), (double)c5.conditionalProbability(1), (double)1.0E-4);
    }

    @Test
    public void testClassificationCompile() throws ClassNotFoundException, IOException {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, Double.NaN);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "run, mary, run", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary run", new Classification("b"));
        ConditionalClassifier classifier2 = (ConditionalClassifier)AbstractExternalizable.compile(classifier);
        ConditionalClassification c = classifier2.classify("");
        Assert.assertEquals((int)2, (int)c.size());
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"b", (String)c.category(0));
        Assert.assertEquals((double)0.42857142857142855, (double)c.conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((double)0.5714285714285714, (double)c.conditionalProbability(0), (double)1.0E-4);
        ConditionalClassification c2 = classifier2.classify("backbends");
        Assert.assertEquals((int)2, (int)c2.size());
        Assert.assertEquals((String)"a", (String)c2.category(1));
        Assert.assertEquals((String)"b", (String)c2.category(0));
        Assert.assertEquals((double)0.42857142857142855, (double)c2.conditionalProbability(1), (double)1.0E-4);
        Assert.assertEquals((double)0.5714285714285714, (double)c2.conditionalProbability(0), (double)1.0E-4);
        ConditionalClassification c3 = classifier2.classify("john");
        Assert.assertEquals((String)"a", (String)c3.category(0));
        Assert.assertEquals((String)"b", (String)c3.category(1));
        double z3 = 0.16666666666666666;
        Assert.assertEquals((double)(0.12857142857142856 / z3), (double)c3.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)(0.0380952380952381 / z3), (double)c3.conditionalProbability(1), (double)1.0E-4);
        ConditionalClassification c4 = classifier2.classify("john smith was here");
        Assert.assertEquals((String)"a", (String)c4.category(0));
        Assert.assertEquals((String)"b", (String)c4.category(1));
        double z4 = 0.16666666666666666;
        Assert.assertEquals((double)(0.12857142857142856 / z4), (double)c4.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)(0.0380952380952381 / z4), (double)c4.conditionalProbability(1), (double)1.0E-4);
        ConditionalClassification c5 = classifier2.classify("john saw mary");
        Assert.assertEquals((String)"a", (String)c5.category(0));
        Assert.assertEquals((String)"b", (String)c5.category(1));
        double z5 = 0.023015873015873017;
        Assert.assertEquals((double)(0.012857142857142857 / z5), (double)c5.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)(0.010158730158730159 / z5), (double)c5.conditionalProbability(1), (double)1.0E-4);
    }

    @Test
    public void testLengthNorm() throws IOException, ClassNotFoundException {
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(CAT_SET_2, TOKENIZER_FACTORY, 1.0, 1.0, Double.NaN);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "run, mary, run", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary run", new Classification("b"));
        classifier.setLengthNorm(10.0);
        JointClassifier classifierSer = (JointClassifier)AbstractExternalizable.serializeDeserialize(classifier);
        ConditionalClassifier classifierComp = (ConditionalClassifier)AbstractExternalizable.compile(classifier);
        JointClassification c1 = classifier.classify("");
        Assert.assertEquals((String)"b", (String)c1.category(0));
        Assert.assertEquals((String)"a", (String)c1.category(1));
        Assert.assertEquals((double)0.5714285714285714, (double)c1.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.42857142857142855, (double)c1.conditionalProbability(1), (double)1.0E-4);
        ConditionalClassification c1c = classifierComp.classify("unknownToken");
        Assert.assertEquals((String)"b", (String)c1c.category(0));
        Assert.assertEquals((String)"a", (String)c1c.category(1));
        Assert.assertEquals((double)0.5714285714285714, (double)c1c.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.42857142857142855, (double)c1c.conditionalProbability(1), (double)1.0E-4);
        JointClassification c1s = classifierSer.classify("unknownToken unknownToken");
        Assert.assertEquals((String)"b", (String)c1s.category(0));
        Assert.assertEquals((String)"a", (String)c1s.category(1));
        Assert.assertEquals((double)0.5714285714285714, (double)c1s.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)0.42857142857142855, (double)c1s.conditionalProbability(1), (double)1.0E-4);
        double jointA = 0.42857142857142855 * java.lang.Math.pow(0.3, 10.0);
        double jointB = 0.5714285714285714 * java.lang.Math.pow(0.06666666666666667, 10.0);
        double expA = jointA / (jointA + jointB);
        double expB = jointB / (jointA + jointB);
        JointClassification c2 = classifier.classify("john");
        Assert.assertEquals((int)2, (int)c2.size());
        Assert.assertEquals((String)"a", (String)c2.category(0));
        Assert.assertEquals((String)"b", (String)c2.category(1));
        Assert.assertEquals((double)expA, (double)c2.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)expB, (double)c2.conditionalProbability(1), (double)1.0E-4);
        JointClassification c2s = classifierSer.classify("john");
        Assert.assertEquals((int)2, (int)c2s.size());
        Assert.assertEquals((String)"a", (String)c2s.category(0));
        Assert.assertEquals((String)"b", (String)c2s.category(1));
        Assert.assertEquals((double)expA, (double)c2s.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)expB, (double)c2s.conditionalProbability(1), (double)1.0E-4);
        ConditionalClassification c2c = classifierComp.classify("john");
        Assert.assertEquals((int)2, (int)c2c.size());
        Assert.assertEquals((String)"a", (String)c2c.category(0));
        Assert.assertEquals((String)"b", (String)c2c.category(1));
        Assert.assertEquals((double)expA, (double)c2c.conditionalProbability(0), (double)1.0E-4);
        Assert.assertEquals((double)expB, (double)c2c.conditionalProbability(1), (double)1.0E-4);
        jointA = 0.42857142857142855 * java.lang.Math.pow(0.06, 5.0);
        jointB = 0.5714285714285714 * java.lang.Math.pow(0.013333333333333332, 5.0);
        expA = jointA / (jointA + jointB);
        expB = jointB / (jointA + jointB);
        JointClassification c3 = classifier.classify("john");
        Assert.assertEquals((int)2, (int)c3.size());
        Assert.assertEquals((String)"a", (String)c3.category(0));
        Assert.assertEquals((String)"b", (String)c3.category(1));
        Assert.assertEquals((double)expA, (double)c3.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expB, (double)c3.conditionalProbability(1), (double)0.001);
        JointClassification c3s = classifierSer.classify("john");
        Assert.assertEquals((int)2, (int)c3s.size());
        Assert.assertEquals((String)"a", (String)c3s.category(0));
        Assert.assertEquals((String)"b", (String)c3s.category(1));
        Assert.assertEquals((double)expA, (double)c3s.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expB, (double)c3s.conditionalProbability(1), (double)0.001);
        ConditionalClassification c3c = classifierComp.classify("john");
        Assert.assertEquals((int)2, (int)c3c.size());
        Assert.assertEquals((String)"a", (String)c3c.category(0));
        Assert.assertEquals((String)"b", (String)c3c.category(1));
        Assert.assertEquals((double)expA, (double)c3c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expB, (double)c3c.conditionalProbability(1), (double)0.001);
    }

    @Test
    public void testLengthNormTernary() throws IOException, ClassNotFoundException {
        HashSet<String> catSet3 = new HashSet<String>(Arrays.asList("a", "b", "c"));
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(catSet3, TOKENIZER_FACTORY, 1.0, 1.0, Double.NaN);
        TradNaiveBayesClassifierTest.handle(classifier, "john ran", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "john jumped", new Classification("a"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary ran", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "run, mary, run", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "mary run", new Classification("b"));
        TradNaiveBayesClassifierTest.handle(classifier, "bill ran", new Classification("c"));
        classifier.setLengthNorm(10.0);
        JointClassifier classifierSer = (JointClassifier)AbstractExternalizable.serializeDeserialize(classifier);
        ConditionalClassifier classifierComp = (ConditionalClassifier)AbstractExternalizable.compile(classifier);
        double jointA = 0.3333333333333333;
        double jointB = 0.4444444444444444;
        double jointC = 0.2222222222222222;
        double expA = jointA / (jointA + jointB + jointC);
        double expB = jointB / (jointA + jointB + jointC);
        double expC = jointC / (jointA + jointB + jointC);
        ConditionalClassification c = classifier.classify("");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"b", (String)c.category(0));
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"c", (String)c.category(2));
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(2), (double)0.001);
        c = classifierSer.classify("");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"b", (String)c.category(0));
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"c", (String)c.category(2));
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(2), (double)0.001);
        c = classifierComp.classify("");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"b", (String)c.category(0));
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"c", (String)c.category(2));
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(2), (double)0.001);
        c = classifier.classify("blah blah");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"b", (String)c.category(0));
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"c", (String)c.category(2));
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(2), (double)0.001);
        c = classifierSer.classify("blah blah blah");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"b", (String)c.category(0));
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"c", (String)c.category(2));
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(2), (double)0.001);
        c = classifierComp.classify("blah blah blah blah blah");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"b", (String)c.category(0));
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"c", (String)c.category(2));
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(2), (double)0.001);
        jointA = 0.3333333333333333 * java.lang.Math.pow(0.18181818181818182, 10.0);
        jointB = 0.4444444444444444 * java.lang.Math.pow(0.125, 10.0);
        jointC = 0.2222222222222222 * java.lang.Math.pow(0.2222222222222222, 10.0);
        expA = jointA / (jointA + jointB + jointC);
        expB = jointB / (jointA + jointB + jointC);
        expC = jointC / (jointA + jointB + jointC);
        c = classifier.classify("ran");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"c", (String)c.category(0));
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"b", (String)c.category(2));
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(2), (double)0.001);
        c = classifierSer.classify("ran");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"c", (String)c.category(0));
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"b", (String)c.category(2));
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(2), (double)0.001);
        c = classifierComp.classify("ran");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"c", (String)c.category(0));
        Assert.assertEquals((String)"a", (String)c.category(1));
        Assert.assertEquals((String)"b", (String)c.category(2));
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(2), (double)0.001);
        jointA = 0.3333333333333333 * java.lang.Math.pow(0.008264462809917356, 5.0);
        jointB = 0.4444444444444444 * java.lang.Math.pow(0.015625, 5.0);
        jointC = 0.2222222222222222 * java.lang.Math.pow(0.024691358024691357, 5.0);
        expA = jointA / (jointA + jointB + jointC);
        expB = jointB / (jointA + jointB + jointC);
        expC = jointC / (jointA + jointB + jointC);
        c = classifier.classify("bill run");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"c", (String)c.category(0));
        Assert.assertEquals((String)"b", (String)c.category(1));
        Assert.assertEquals((String)"a", (String)c.category(2));
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(2), (double)0.001);
        c = classifierSer.classify("bill run");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"c", (String)c.category(0));
        Assert.assertEquals((String)"b", (String)c.category(1));
        Assert.assertEquals((String)"a", (String)c.category(2));
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(2), (double)0.001);
        c = classifierComp.classify("bill run");
        Assert.assertEquals((int)3, (int)c.size());
        Assert.assertEquals((String)"c", (String)c.category(0));
        Assert.assertEquals((String)"b", (String)c.category(1));
        Assert.assertEquals((String)"a", (String)c.category(2));
        Assert.assertEquals((double)expC, (double)c.conditionalProbability(0), (double)0.001);
        Assert.assertEquals((double)expB, (double)c.conditionalProbability(1), (double)0.001);
        Assert.assertEquals((double)expA, (double)c.conditionalProbability(2), (double)0.001);
    }

    @Test
    public void testNormTrain() {
        HashSet<String> catSet2 = new HashSet<String>(Arrays.asList("A", "B"));
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(catSet2, TOKENIZER_FACTORY, 10.0, 0.5, 1.0);
        classifier.train("aa aa bb bb", new Classification("A"), 1.0);
        classifier.train("aa aa aa", new Classification("A"), 1.0);
        classifier.train("bb bb bb", new Classification("B"), 1.0);
        classifier.train("bb cc cc bb", new Classification("B"), 1.0);
        classifier.train("bb bb bb dd", new Classification("B"), 1.0);
        Assert.assertEquals((double)0.48, (double)classifier.probCat("A"), (double)1.0E-4);
        Assert.assertEquals((double)0.52, (double)classifier.probCat("B"), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)classifier.probToken("aa", "A"), (double)1.0E-4);
        Assert.assertEquals((double)0.25, (double)classifier.probToken("bb", "A"), (double)1.0E-4);
        Assert.assertEquals((double)0.125, (double)classifier.probToken("cc", "A"), (double)1.0E-4);
        Assert.assertEquals((double)0.125, (double)classifier.probToken("dd", "A"), (double)1.0E-4);
        Assert.assertEquals((double)0.1, (double)classifier.probToken("aa", "B"), (double)1.0E-4);
        Assert.assertEquals((double)0.55, (double)classifier.probToken("bb", "B"), (double)1.0E-4);
        Assert.assertEquals((double)0.2, (double)classifier.probToken("cc", "B"), (double)1.0E-4);
        Assert.assertEquals((double)0.15, (double)classifier.probToken("dd", "B"), (double)1.0E-4);
    }

    @Test
    public void testTrainConditional() {
        HashSet<String> catSet2 = new HashSet<String>(Arrays.asList("A", "B"));
        TradNaiveBayesClassifier classifier = new TradNaiveBayesClassifier(catSet2, TOKENIZER_FACTORY, 0.5, 0.5, Double.NaN);
        ConditionalClassification c1 = new ConditionalClassification(new String[]{"A", "B"}, new double[]{0.75, 0.25});
        classifier.trainConditional("aa", c1, 4.0, 0.0);
        ConditionalClassification c2 = new ConditionalClassification(new String[]{"B", "A"}, new double[]{0.9, 0.1});
        classifier.trainConditional("bb", c2, 4.0, 0.0);
        Assert.assertEquals((double)0.43333333333333335, (double)classifier.probCat("A"), (double)1.0E-4);
        Assert.assertEquals((double)0.5666666666666667, (double)classifier.probCat("B"), (double)1.0E-4);
        Assert.assertEquals((double)0.7954545454545454, (double)classifier.probToken("aa", "A"), (double)1.0E-4);
        Assert.assertEquals((double)0.20454545454545453, (double)classifier.probToken("bb", "A"), (double)1.0E-4);
        Assert.assertEquals((double)0.26785714285714285, (double)classifier.probToken("aa", "B"), (double)1.0E-4);
        Assert.assertEquals((double)0.7321428571428571, (double)classifier.probToken("bb", "B"), (double)1.0E-4);
    }

    static Set<String> listToSet(String[] xs) {
        return new HashSet<String>(Arrays.asList(xs));
    }
}

