/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.cluster;

import com.aliasi.classify.PrecisionRecallEvaluation;
import com.aliasi.cluster.ClusterScore;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class ClusterScoreTest {
    Set elts1 = ClusterScoreTest.set(new Object[]{"1"});
    Set elts2 = ClusterScoreTest.set(new Object[]{"2"});
    Set elts12 = ClusterScoreTest.set(new Object[]{"1", "2"});
    Set elts12345 = ClusterScoreTest.set(new Object[]{"1", "2", "3", "4", "5"});
    Set elts67 = ClusterScoreTest.set(new Object[]{"6", "7"});
    Set elts89ABC = ClusterScoreTest.set(new Object[]{"8", "9", "A", "B", "C"});
    Set elts6789ABC = ClusterScoreTest.set(new Object[]{"6", "7", "8", "9", "A", "B", "C"});
    Set elts1234589ABC = ClusterScoreTest.set(new Object[]{"1", "2", "3", "4", "5", "8", "9", "A", "B", "C"});
    Set partition1 = ClusterScoreTest.set(new Object[]{this.elts1});
    Set partition2 = ClusterScoreTest.set(new Object[]{this.elts2});
    Set partition12 = ClusterScoreTest.set(new Object[]{this.elts12});
    Set partition1_2 = ClusterScoreTest.set(new Object[]{this.elts1, this.elts2});
    Set partition12345_67_89ABC = ClusterScoreTest.set(new Object[]{this.elts12345, this.elts67, this.elts89ABC});
    Set partition12345_6789ABC = ClusterScoreTest.set(new Object[]{this.elts12345, this.elts6789ABC});
    Set partition1234589ABC_67 = ClusterScoreTest.set(new Object[]{this.elts1234589ABC, this.elts67});
    Set bogusPartition = ClusterScoreTest.set(new Object[]{this.elts1, this.elts12});

    static Set set(Object[] xs) {
        HashSet<Object> set = new HashSet<Object>();
        for (int i = 0; i < xs.length; ++i) {
            set.add(xs[i]);
        }
        return set;
    }

    @Test
    public void testStandard() {
        ClusterScore scorer = new ClusterScore(this.partition1, this.partition1);
        PrecisionRecallEvaluation prEval = scorer.equivalenceEvaluation();
        Assert.assertEquals((double)1.0, (double)prEval.precision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)prEval.recall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)prEval.fMeasure(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucF(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementF(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterF(), (double)1.0E-4);
        scorer = new ClusterScore(this.partition12, this.partition12);
        prEval = scorer.equivalenceEvaluation();
        Assert.assertEquals((double)1.0, (double)prEval.precision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)prEval.recall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)prEval.fMeasure(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucF(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementF(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterF(), (double)1.0E-4);
        scorer = new ClusterScore(this.partition1_2, this.partition1_2);
        prEval = scorer.equivalenceEvaluation();
        Assert.assertEquals((double)1.0, (double)prEval.precision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)prEval.recall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)prEval.fMeasure(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucF(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementF(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterF(), (double)1.0E-4);
        scorer = new ClusterScore(this.partition1234589ABC_67, this.partition1234589ABC_67);
        prEval = scorer.equivalenceEvaluation();
        Assert.assertEquals((double)1.0, (double)prEval.precision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)prEval.recall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)prEval.fMeasure(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucF(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementF(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterF(), (double)1.0E-4);
        scorer = new ClusterScore(this.partition1_2, this.partition12);
        prEval = scorer.equivalenceEvaluation();
        Assert.assertEquals((double)0.5, (double)prEval.precision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)prEval.recall(), (double)1.0E-4);
        Assert.assertEquals((double)0.66666, (double)prEval.fMeasure(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)scorer.mucPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucRecall(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)scorer.mucF(), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)scorer.b3ElementPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementRecall(), (double)1.0E-4);
        Assert.assertEquals((double)0.6666666666666666, (double)scorer.b3ElementF(), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)scorer.b3ClusterPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterRecall(), (double)1.0E-4);
        Assert.assertEquals((double)0.6666666666666666, (double)scorer.b3ClusterF(), (double)1.0E-4);
        scorer = new ClusterScore(this.partition12, this.partition1_2);
        prEval = scorer.equivalenceEvaluation();
        Assert.assertEquals((double)1.0, (double)prEval.precision(), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)prEval.recall(), (double)1.0E-4);
        Assert.assertEquals((double)0.66666, (double)prEval.fMeasure(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)scorer.mucRecall(), (double)1.0E-4);
        Assert.assertEquals((double)0.0, (double)scorer.mucF(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)scorer.b3ElementRecall(), (double)1.0E-4);
        Assert.assertEquals((double)0.6666666666666666, (double)scorer.b3ElementF(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)scorer.b3ClusterRecall(), (double)1.0E-4);
        Assert.assertEquals((double)0.6666666666666666, (double)scorer.b3ClusterF(), (double)1.0E-4);
        scorer = new ClusterScore(this.partition12345_67_89ABC, this.partition12345_6789ABC);
        prEval = scorer.equivalenceEvaluation();
        Assert.assertEquals((double)0.729729729, (double)prEval.precision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)prEval.recall(), (double)1.0E-4);
        Assert.assertEquals((double)0.9, (double)scorer.mucPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucRecall(), (double)1.0E-4);
        Assert.assertEquals((double)0.7619, (double)scorer.b3ElementPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementRecall(), (double)1.0E-4);
        Assert.assertEquals((double)0.7959, (double)scorer.b3ClusterPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterRecall(), (double)1.0E-4);
        scorer = new ClusterScore(this.partition12345_6789ABC, this.partition12345_67_89ABC);
        prEval = scorer.equivalenceEvaluation();
        Assert.assertEquals((double)1.0, (double)prEval.precision(), (double)1.0E-4);
        Assert.assertEquals((double)0.729729729, (double)prEval.recall(), (double)1.0E-4);
        Assert.assertEquals((double)0.843749999512207, (double)prEval.fMeasure(), (double)1.0E-4);
        Assert.assertEquals((long)20L, (long)prEval.falseNegative());
        Assert.assertEquals((double)1.0, (double)scorer.mucPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)0.9, (double)scorer.mucRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)0.7619, (double)scorer.b3ElementRecall(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)0.7959, (double)scorer.b3ClusterRecall(), (double)1.0E-4);
        scorer = new ClusterScore(this.partition12345_67_89ABC, this.partition1234589ABC_67);
        prEval = scorer.equivalenceEvaluation();
        Assert.assertEquals((double)0.519230769, (double)prEval.precision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)prEval.recall(), (double)1.0E-4);
        Assert.assertEquals((double)0.9, (double)scorer.mucPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.mucRecall(), (double)1.0E-4);
        Assert.assertEquals((double)0.9473684210526316, (double)scorer.mucF(), (double)1.0E-4);
        Assert.assertEquals((double)0.58333, (double)scorer.b3ElementPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ElementRecall(), (double)1.0E-4);
        Assert.assertEquals((double)0.75, (double)scorer.b3ClusterPrecision(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)scorer.b3ClusterRecall(), (double)1.0E-4);
    }
}

