/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.cluster;

import com.aliasi.cluster.Dendrogram;
import com.aliasi.cluster.LeafDendrogram;
import com.aliasi.cluster.LinkDendrogram;
import com.aliasi.test.unit.Asserts;
import com.aliasi.util.CollectionUtils;
import com.aliasi.util.SmallSet;
import java.util.HashSet;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class DendrogramTest {
    @Test
    public void testEquivalence() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("1");
        LeafDendrogram<String> leaf2 = new LeafDendrogram<String>("2");
        LinkDendrogram<String> link1_2 = new LinkDendrogram<String>(leaf1, leaf2, 1.0);
        LeafDendrogram<String> leaf3 = new LeafDendrogram<String>("3");
        LinkDendrogram<String> link12_3 = new LinkDendrogram<String>(leaf3, link1_2, 2.0);
        LeafDendrogram<String> leaf4 = new LeafDendrogram<String>("4");
        LeafDendrogram<String> leaf5 = new LeafDendrogram<String>("5");
        LinkDendrogram<String> link4_5 = new LinkDendrogram<String>(leaf4, leaf5, 1.5);
        LeafDendrogram<String> leaf6 = new LeafDendrogram<String>("6");
        LinkDendrogram<String> link45_6 = new LinkDendrogram<String>(leaf6, link4_5, 3.0);
        LinkDendrogram<String> link123_456 = new LinkDendrogram<String>(link12_3, link45_6, 4.0);
        LeafDendrogram<String> leaf1_B = new LeafDendrogram<String>("1");
        LeafDendrogram<String> leaf2_B = new LeafDendrogram<String>("2");
        LinkDendrogram<String> link1_2_B = new LinkDendrogram<String>(leaf2_B, leaf1_B, 1.0);
        LeafDendrogram<String> leaf3_B = new LeafDendrogram<String>("3");
        LinkDendrogram<String> link12_3_B = new LinkDendrogram<String>(leaf3_B, link1_2_B, 2.0);
        LeafDendrogram<String> leaf4_B = new LeafDendrogram<String>("4");
        LeafDendrogram<String> leaf5_B = new LeafDendrogram<String>("5");
        LinkDendrogram<String> link4_5_B = new LinkDendrogram<String>(leaf5_B, leaf4_B, 1.5);
        LeafDendrogram<String> leaf6_B = new LeafDendrogram<String>("6");
        LinkDendrogram<String> link45_6_B = new LinkDendrogram<String>(leaf6_B, link4_5_B, 3.0);
        LinkDendrogram<String> link123_456_B = new LinkDendrogram<String>(link45_6_B, link12_3_B, 4.0);
        Assert.assertTrue((boolean)Dendrogram.structurallyEquivalent(leaf1, leaf1));
        Assert.assertTrue((boolean)Dendrogram.structurallyEquivalent(leaf1, leaf1_B));
        Assert.assertFalse((boolean)Dendrogram.structurallyEquivalent(leaf1, leaf2_B));
        Assert.assertFalse((boolean)Dendrogram.structurallyEquivalent(leaf1, link1_2_B));
        Assert.assertTrue((boolean)Dendrogram.structurallyEquivalent(link1_2, link1_2));
        Assert.assertTrue((boolean)Dendrogram.structurallyEquivalent(link1_2, link1_2_B));
        Assert.assertFalse((boolean)Dendrogram.structurallyEquivalent(link1_2, leaf1_B));
        Assert.assertFalse((boolean)Dendrogram.structurallyEquivalent(link1_2, link12_3));
        Assert.assertFalse((boolean)Dendrogram.structurallyEquivalent(link1_2, link12_3_B));
        Assert.assertTrue((boolean)Dendrogram.structurallyEquivalent(link123_456, link123_456));
        Assert.assertTrue((boolean)Dendrogram.structurallyEquivalent(link123_456, link123_456_B));
        Assert.assertFalse((boolean)Dendrogram.structurallyEquivalent(link123_456, leaf1_B));
        Assert.assertFalse((boolean)Dendrogram.structurallyEquivalent(link123_456, link1_2));
    }

    @Test
    public void testPartition() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("1");
        LeafDendrogram<String> leaf2 = new LeafDendrogram<String>("2");
        LinkDendrogram<String> link1_2 = new LinkDendrogram<String>(leaf1, leaf2, 1.0);
        LeafDendrogram<String> leaf3 = new LeafDendrogram<String>("3");
        LinkDendrogram<String> link12_3 = new LinkDendrogram<String>(leaf3, link1_2, 2.0);
        LeafDendrogram<String> leaf4 = new LeafDendrogram<String>("4");
        LeafDendrogram<String> leaf5 = new LeafDendrogram<String>("5");
        LinkDendrogram<String> link4_5 = new LinkDendrogram<String>(leaf4, leaf5, 1.5);
        LeafDendrogram<String> leaf6 = new LeafDendrogram<String>("6");
        LinkDendrogram<String> link45_6 = new LinkDendrogram<String>(leaf6, link4_5, 3.0);
        LinkDendrogram<String> link123_456 = new LinkDendrogram<String>(link12_3, link45_6, 4.0);
        Assert.assertEquals((int)6, (int)link123_456.size());
        this.assertEqualPartition(new Dendrogram[]{link12_3, link45_6}, link123_456.partitionK(2));
        this.assertEqualPartition(new Dendrogram[]{link12_3, link4_5, leaf6}, link123_456.partitionK(3));
        this.assertEqualPartition(new Dendrogram[]{link1_2, leaf3, link4_5, leaf6}, link123_456.partitionK(4));
        this.assertEqualPartition(new Dendrogram[]{link1_2, leaf3, leaf4, leaf5, leaf6}, link123_456.partitionK(5));
        this.assertEqualPartition(new Dendrogram[]{leaf1, leaf2, leaf3, leaf4, leaf5, leaf6}, link123_456.partitionK(6));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPartitionExc1() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("1");
        LeafDendrogram<String> leaf2 = new LeafDendrogram<String>("2");
        LinkDendrogram<String> link1_2 = new LinkDendrogram<String>(leaf1, leaf2, 1.0);
        LeafDendrogram<String> leaf3 = new LeafDendrogram<String>("3");
        LinkDendrogram<String> link12_3 = new LinkDendrogram<String>(leaf3, link1_2, 2.0);
        LeafDendrogram<String> leaf4 = new LeafDendrogram<String>("4");
        LeafDendrogram<String> leaf5 = new LeafDendrogram<String>("5");
        LinkDendrogram<String> link4_5 = new LinkDendrogram<String>(leaf4, leaf5, 1.5);
        LeafDendrogram<String> leaf6 = new LeafDendrogram<String>("6");
        LinkDendrogram<String> link45_6 = new LinkDendrogram<String>(leaf6, link4_5, 3.0);
        LinkDendrogram<String> link123_456 = new LinkDendrogram<String>(link12_3, link45_6, 4.0);
        link123_456.partitionK(7);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPartitionExc2() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("1");
        LeafDendrogram<String> leaf2 = new LeafDendrogram<String>("2");
        LinkDendrogram<String> link1_2 = new LinkDendrogram<String>(leaf1, leaf2, 1.0);
        LeafDendrogram<String> leaf3 = new LeafDendrogram<String>("3");
        LinkDendrogram<String> link12_3 = new LinkDendrogram<String>(leaf3, link1_2, 2.0);
        LeafDendrogram<String> leaf4 = new LeafDendrogram<String>("4");
        LeafDendrogram<String> leaf5 = new LeafDendrogram<String>("5");
        LinkDendrogram<String> link4_5 = new LinkDendrogram<String>(leaf4, leaf5, 1.5);
        LeafDendrogram<String> leaf6 = new LeafDendrogram<String>("6");
        LinkDendrogram<String> link45_6 = new LinkDendrogram<String>(leaf6, link4_5, 3.0);
        LinkDendrogram<String> link123_456 = new LinkDendrogram<String>(link12_3, link45_6, 4.0);
        link123_456.partitionK(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testPartitionExc3() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("1");
        LeafDendrogram<String> leaf2 = new LeafDendrogram<String>("2");
        LinkDendrogram<String> link1_2 = new LinkDendrogram<String>(leaf1, leaf2, 1.0);
        LeafDendrogram<String> leaf3 = new LeafDendrogram<String>("3");
        LinkDendrogram<String> link12_3 = new LinkDendrogram<String>(leaf3, link1_2, 2.0);
        LeafDendrogram<String> leaf4 = new LeafDendrogram<String>("4");
        LeafDendrogram<String> leaf5 = new LeafDendrogram<String>("5");
        LinkDendrogram<String> link4_5 = new LinkDendrogram<String>(leaf4, leaf5, 1.5);
        LeafDendrogram<String> leaf6 = new LeafDendrogram<String>("6");
        LinkDendrogram<String> link45_6 = new LinkDendrogram<String>(leaf6, link4_5, 3.0);
        LinkDendrogram<String> link123_456 = new LinkDendrogram<String>(link12_3, link45_6, 4.0);
        link123_456.partitionK(-10);
    }

    private void assertEqualPartition(Dendrogram[] ds1, Set ds2) {
        HashSet expected = new HashSet();
        for (int i = 0; i < ds1.length; ++i) {
            expected.add(ds1[i].memberSet());
        }
        Assert.assertEquals(expected, (Object)ds2);
    }

    @Test
    public void testPartitionByMax() {
        LeafDendrogram<String> leafaa = new LeafDendrogram<String>("aa");
        LeafDendrogram<String> leafaaa = new LeafDendrogram<String>("aaa");
        LeafDendrogram<String> leafaaaaa = new LeafDendrogram<String>("aaaaa");
        LeafDendrogram<String> leafbbb = new LeafDendrogram<String>("bbb");
        LeafDendrogram<String> leafbbbb = new LeafDendrogram<String>("bbbb");
        LinkDendrogram<String> link_bs = new LinkDendrogram<String>(leafbbb, leafbbbb, 1.0);
        LinkDendrogram<String> link_aa_aaa = new LinkDendrogram<String>(leafaa, leafaaa, 1.0);
        LinkDendrogram<String> link_as = new LinkDendrogram<String>(leafaaaaa, link_aa_aaa, 2.0);
        LinkDendrogram<String> dendro = new LinkDendrogram<String>(link_as, link_bs, 3.0);
        Set part0 = dendro.partitionDistance(0.0);
        Set part1 = dendro.partitionDistance(1.0);
        Set part2 = dendro.partitionDistance(2.0);
        Set part3 = dendro.partitionDistance(3.0);
        Set part4 = dendro.partitionDistance(4.0);
        HashSet eqClasses0 = new HashSet();
        eqClasses0.add(((Dendrogram)leafaa).memberSet());
        eqClasses0.add(((Dendrogram)leafaaa).memberSet());
        eqClasses0.add(((Dendrogram)leafaaaaa).memberSet());
        eqClasses0.add(((Dendrogram)leafbbb).memberSet());
        eqClasses0.add(((Dendrogram)leafbbbb).memberSet());
        Assert.assertEquals(eqClasses0, part0);
        HashSet eqClasses1 = new HashSet();
        eqClasses1.add(((Dendrogram)link_aa_aaa).memberSet());
        eqClasses1.add(((Dendrogram)link_bs).memberSet());
        eqClasses1.add(((Dendrogram)leafaaaaa).memberSet());
        Assert.assertEquals(eqClasses1, part1);
        HashSet eqClasses2 = new HashSet();
        eqClasses2.add(((Dendrogram)link_bs).memberSet());
        eqClasses2.add(((Dendrogram)link_as).memberSet());
        Assert.assertEquals(eqClasses2, part2);
        HashSet eqClasses3 = new HashSet();
        eqClasses3.add(((Dendrogram)dendro).memberSet());
        Assert.assertEquals(eqClasses3, part3);
        Assert.assertEquals(eqClasses3, part4);
    }

    @Test
    public void testOne() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("foo");
        Assert.assertEquals((double)0.0, (double)((Dendrogram)leaf1).score(), (double)1.0E-4);
        Assert.assertEquals(leaf1, leaf1.dereference());
        Assert.assertNull(leaf1.parent());
        Assert.assertEquals((int)1, (int)((Dendrogram)leaf1).size());
        Assert.assertTrue((boolean)leaf1.contains("foo"));
        Assert.assertEquals(((Dendrogram)leaf1).memberSet(), SmallSet.create("foo"));
    }

    @Test
    public void testTwo() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("foo");
        LeafDendrogram<String> leaf2 = new LeafDendrogram<String>("bar");
        LinkDendrogram<String> link1 = new LinkDendrogram<String>(leaf1, leaf2, 1.0);
        Assert.assertEquals((double)1.0, (double)((Dendrogram)link1).score(), (double)1.0E-4);
        Assert.assertEquals(link1, link1.dereference());
        Assert.assertEquals(link1, leaf1.dereference());
        Assert.assertEquals(link1, leaf2.dereference());
        Assert.assertEquals(link1, leaf1.parent());
        Assert.assertEquals(link1, leaf2.parent());
        Assert.assertEquals((int)2, (int)link1.size());
        Assert.assertTrue((boolean)((Dendrogram)link1).memberSet().contains("foo"));
        Assert.assertTrue((boolean)((Dendrogram)link1).memberSet().contains("bar"));
        Assert.assertEquals(SmallSet.create("foo", "bar"), ((Dendrogram)link1).memberSet());
        LeafDendrogram<String> leaf3 = new LeafDendrogram<String>("baz");
        LinkDendrogram<String> link2 = new LinkDendrogram<String>(leaf3, link1, 2.0);
        Assert.assertEquals(link2, link1.parent());
        Assert.assertEquals(link2, link1.dereference());
        Assert.assertEquals(link2, link1.dereference());
        Assert.assertEquals(link2, link2.dereference());
        Assert.assertEquals(link2, link2.dereference());
        Assert.assertEquals(link2, leaf1.dereference());
        Assert.assertEquals(link2, leaf1.dereference());
        Assert.assertEquals(link2, leaf2.dereference());
        Assert.assertEquals(link2, leaf2.dereference());
        Assert.assertEquals(link2, leaf3.dereference());
        Assert.assertEquals(link2, leaf3.dereference());
        HashSet<String> set = new HashSet<String>();
        set.add("foo");
        set.add("bar");
        set.add("baz");
        Assert.assertEquals(set, ((Dendrogram)link2).memberSet());
        Assert.assertNotNull(new LinkDendrogram<String>(leaf1, leaf2, Double.POSITIVE_INFINITY));
    }

    @Test
    public void testEquals() {
        Asserts.assertNotEquals(new LeafDendrogram<String>("foo"), new LeafDendrogram<String>("foo"));
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxEx1() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("foo");
        LeafDendrogram<String> leaf2 = new LeafDendrogram<String>("bar");
        new LinkDendrogram<String>(leaf1, leaf2, -3.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxEx2() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("foo");
        LeafDendrogram<String> leaf2 = new LeafDendrogram<String>("bar");
        new LinkDendrogram<String>(leaf1, leaf2, Double.NaN);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConstruxEx3() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("foo");
        LeafDendrogram<String> leaf2 = new LeafDendrogram<String>("bar");
        new LinkDendrogram<String>(leaf1, leaf2, Double.NEGATIVE_INFINITY);
    }

    @Test
    public void testPartitionDistanceLeaf() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("foo");
        Assert.assertEquals(CollectionUtils.asSet(CollectionUtils.asSet("foo")), leaf1.partitionDistance(1.0));
    }

    @Test
    public void testPartitionDistanceLink() {
        LeafDendrogram<String> leaf1 = new LeafDendrogram<String>("foo");
        LeafDendrogram<String> leaf2 = new LeafDendrogram<String>("bar");
        LinkDendrogram<String> link12 = new LinkDendrogram<String>(leaf1, leaf2, 2.0);
        Assert.assertEquals(CollectionUtils.asSet(CollectionUtils.asSet("foo"), CollectionUtils.asSet("bar")), link12.partitionDistance(1.0));
        Assert.assertEquals(CollectionUtils.asSet(CollectionUtils.asSet("foo", "bar")), link12.partitionDistance(20.0));
    }
}

