/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.cluster;

import com.aliasi.cluster.KMeansClusterer;
import com.aliasi.io.Reporters;
import com.aliasi.tokenizer.IndoEuropeanTokenizerFactory;
import com.aliasi.tokenizer.TokenFeatureExtractor;
import com.aliasi.util.FeatureExtractor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class KMeansClustererTest {
    static FeatureExtractor FEATURE_EXTRACTOR = new TokenFeatureExtractor(IndoEuropeanTokenizerFactory.INSTANCE);
    static Random RANDOM = new Random(42L);
    static final String AA = "A A";
    static final String AAA = "A A A";
    static final String BBB = "B B B";
    static final String CCC = "C C C";
    static final String AAB = "A A B";
    static final String BBA = "B B A";
    static FeatureExtractor<double[]> ID_PARSER = new FeatureExtractor<double[]>(){

        @Override
        public Map<String, ? extends Number> features(double[] xs) {
            HashMap<String, Double> result = new HashMap<String, Double>();
            for (int i = 0; i < xs.length; ++i) {
                result.put(Integer.toString(i), xs[i]);
            }
            return result;
        }
    };

    static Set<double[]> randomDenseElts(int numElts, int numDims, Random random) {
        HashSet<double[]> inputSet = new HashSet<double[]>(numElts * 2);
        for (int i = 0; i < numElts; ++i) {
            inputSet.add(KMeansClustererTest.randomDenseElt(numDims, random));
        }
        return inputSet;
    }

    static double[] randomDenseElt(int numDims, Random random) {
        double[] xs = new double[numDims];
        for (int i = 0; i < xs.length; ++i) {
            xs[i] = 10.0 * random.nextDouble() - 5.0;
        }
        return xs;
    }

    public void testKMeansPlusPlus() {
        int K = 500;
        int n = 89037;
        int d = 50;
        int maxEpochs = 200;
        double minImprovement = 1.0E-4;
        KMeansClusterer<double[]> clustererKmpp = new KMeansClusterer<double[]>(ID_PARSER, K, maxEpochs, true, minImprovement);
        KMeansClusterer<double[]> clusterer = new KMeansClusterer<double[]>(ID_PARSER, K, maxEpochs, false, minImprovement);
        Random random = new Random();
        Set<double[]> eltSet = KMeansClustererTest.randomDenseElts(n, d, random);
        Set<Set<double[]>> clustering = clusterer.cluster(eltSet, random, Reporters.silent());
    }

    public static void main(String[] args) {
        new KMeansClustererTest().testKMeansPlusPlus();
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroExc1() {
        int numClusters = 0;
        int maxIterations = 10;
        new KMeansClusterer(FEATURE_EXTRACTOR, numClusters, maxIterations, false, 0.0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testZeroExc2() {
        int numClusters = 10;
        int maxIterations = -1;
        new KMeansClusterer(FEATURE_EXTRACTOR, numClusters, maxIterations, false, 0.0);
    }

    @Test
    public void testOne() {
        int numClusters = 1;
        int maxIterations = 10;
        KMeansClusterer clusterer = new KMeansClusterer(FEATURE_EXTRACTOR, numClusters, maxIterations, false, 0.0);
        KMeansClusterer clustererPP = new KMeansClusterer(FEATURE_EXTRACTOR, numClusters, maxIterations, false, 0.0);
        this.assertCluster(clusterer, clustererPP, new String[0], new String[0][]);
        this.assertCluster(clusterer, clustererPP, new String[]{AAA}, new String[][]{{AAA}});
        this.assertCluster(clusterer, clustererPP, new String[]{AAA, BBB}, new String[][]{{AAA, BBB}});
        this.assertCluster(clusterer, clustererPP, new String[]{AAA, BBB, CCC}, new String[][]{{AAA, BBB, CCC}});
    }

    @Test
    public void testTwo() {
        int numClusters = 2;
        int maxIterations = 10;
        KMeansClusterer clusterer = new KMeansClusterer(FEATURE_EXTRACTOR, numClusters, maxIterations, false, 0.0);
        KMeansClusterer clustererPP = new KMeansClusterer(FEATURE_EXTRACTOR, numClusters, maxIterations, true, 0.0);
        this.assertCluster(clusterer, clustererPP, new String[0], new String[0][]);
        this.assertCluster(clusterer, clustererPP, new String[]{AAA}, new String[][]{{AAA}});
        this.assertCluster(clusterer, clustererPP, new String[]{AAA, BBB}, new String[][]{{AAA}, {BBB}});
        this.assertCluster(clusterer, clustererPP, new String[]{AA, AAB, BBB}, new String[][]{{AA, AAB}, {BBB}});
    }

    @Test
    public void testRandomRecluster() {
        KMeansClusterer<String> clusterer = new KMeansClusterer<String>(FEATURE_EXTRACTOR, 100, 20, false, 0.0);
        for (int t = 0; t < 5; ++t) {
            Random random = new Random();
            long seed = random.nextLong();
            random = new Random(seed);
            int numClusters = 2 + random.nextInt(1);
            HashSet<String> inputSet = new HashSet<String>();
            HashSet<Set<Set<String>>> initialClustering = new HashSet<Set<Set<String>>>();
            for (int i = 0; i < numClusters; ++i) {
                initialClustering.add(this.randomInputs(1 + random.nextInt(3), random, inputSet));
            }
            Set<String> unclusteredElements = this.randomInputs(0 + random.nextInt(5), random, inputSet);
            Set<Set<String>> clustering = clusterer.recluster(initialClustering, unclusteredElements, Reporters.silent());
            this.assertCovers(clustering, inputSet);
        }
    }

    Set<String> randomInputs(int numInputs, Random random) {
        return this.randomInputs(numInputs, random, new HashSet<String>());
    }

    Set<String> randomInputs(int numInputs, Random random, Set<String> accum) {
        HashSet<String> inputSet = new HashSet<String>(numInputs * 2);
        for (int n = 0; n < numInputs; ++n) {
            StringBuilder sb = new StringBuilder();
            int length = 5;
            int numChars = 2;
            for (int i = 0; i < length; ++i) {
                if (i > 0) {
                    sb.append(' ');
                }
                char c = (char)(97 + random.nextInt(numChars));
                sb.append(c);
            }
            if (!accum.add(sb.toString())) {
                --n;
                continue;
            }
            inputSet.add(sb.toString());
        }
        return inputSet;
    }

    @Test
    public void testRandom() {
        for (int t = 0; t < 100; ++t) {
            Random random = new Random();
            long seed = random.nextLong();
            random = new Random(seed);
            int numInputs = random.nextInt(10) + 5;
            Set<String> inputSet = this.randomInputs(numInputs, random);
            int maxIterations = random.nextInt(50) + 50;
            int numClusters = 3;
            KMeansClusterer<String> clusterer = new KMeansClusterer<String>(FEATURE_EXTRACTOR, numClusters, maxIterations, false, 0.0);
            KMeansClusterer<String> clustererPlusPlus = new KMeansClusterer<String>(FEATURE_EXTRACTOR, numClusters, maxIterations, true, 0.0);
            int expectedNumClusters = Math.min(inputSet.size(), numClusters);
            Set<Set<String>> clustering = clusterer.cluster(inputSet, random, null);
            this.assertCovers(clustering, inputSet);
            Set<Set<String>> clustering2 = clustererPlusPlus.cluster(inputSet, random, null);
            this.assertCovers(clustering2, inputSet);
        }
    }

    void assertCovers(Set<Set<String>> clustering, Set<String> elts) {
        HashSet<String> clusteringElts = new HashSet<String>();
        for (Set<String> cluster : clustering) {
            Assert.assertTrue((cluster.size() > 0 ? 1 : 0) != 0);
            clusteringElts.addAll(cluster);
        }
        Assert.assertEquals(elts, clusteringElts);
    }

    void assertCluster(KMeansClusterer clusterer, KMeansClusterer clustererPP, String[] inputs, String[][] expectedClusters) {
        Set<Set<String>> expectedClustering = KMeansClustererTest.toClustering(expectedClusters);
        for (int i = 0; i < 1000; ++i) {
            Set<String> inputSet = KMeansClustererTest.toSet(inputs);
            Set<Set<String>> clustering = clusterer.cluster(inputSet, RANDOM, null);
            Assert.assertEquals(expectedClustering, clustering);
            Set<Set<String>> clusteringPP = clustererPP.cluster(inputSet, RANDOM, null);
            Assert.assertEquals(expectedClustering, clusteringPP);
        }
    }

    static Set<Set<String>> toClustering(String[][] clusters) {
        HashSet<Set<String>> clustering = new HashSet<Set<String>>();
        for (int i = 0; i < clusters.length; ++i) {
            clustering.add(KMeansClustererTest.toSet(clusters[i]));
        }
        return clustering;
    }

    static Set<String> toSet(String[] xs) {
        HashSet<String> result = new HashSet<String>();
        for (int i = 0; i < xs.length; ++i) {
            result.add(xs[i]);
        }
        return result;
    }
}

