/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.cluster;

import com.aliasi.cluster.LatentDirichletAllocation;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class LatentDirichletAllocationTest {
    @Test
    public void testSerializer() throws IOException, ClassNotFoundException {
        double docTopicPrior = 0.1;
        double[][] topicWordProbs = new double[][]{{0.7, 0.25, 0.05}, {0.05, 0.5, 0.45}};
        LatentDirichletAllocation lda = new LatentDirichletAllocation(docTopicPrior, topicWordProbs);
        LatentDirichletAllocation ldaDeser = (LatentDirichletAllocation)AbstractExternalizable.serializeDeserialize(lda);
        Assert.assertEquals((double)lda.documentTopicPrior(), (double)ldaDeser.documentTopicPrior(), (double)1.0E-5);
        Assert.assertEquals((int)lda.numTopics(), (int)ldaDeser.numTopics());
        Assert.assertEquals((int)lda.numWords(), (int)ldaDeser.numWords());
        for (int topic = 0; topic < lda.numTopics(); ++topic) {
            for (int word = 0; word < lda.numWords(); ++word) {
                Assert.assertEquals((double)lda.wordProbability(topic, word), (double)ldaDeser.wordProbability(topic, word), (double)1.0E-5);
            }
        }
    }

    @Test
    public void testTopicSampler() {
        double docTopicPrior = 0.1;
        double[][] topicWordProbs = new double[][]{{0.7, 0.25, 0.05}, {0.05, 0.5, 0.45}};
        LatentDirichletAllocation lda = new LatentDirichletAllocation(docTopicPrior, topicWordProbs);
        int[] doc1 = new int[]{0, 0, 1, 0, 1, 0};
        int[] doc2 = new int[]{2, 1, 1, 2, 2, 2, 1, 2, 2, 2};
        int[] doc3 = new int[]{2, 2, 2, 0, 0, 2, 2, 1, 1};
        this.assertTopicSamples(doc1, lda);
        this.assertTopicSamples(doc2, lda);
        this.assertTopicSamples(doc3, lda);
    }

    void assertTopicSamples(int[] doc, LatentDirichletAllocation lda) {
        short[][] samples = lda.sampleTopics(doc, 20, 500, 500, new Random());
        for (int i = 0; i < samples.length; ++i) {
            short[] sample = samples[i];
            for (int tok = 0; tok < sample.length; ++tok) {
            }
        }
    }

    @Test
    public void testGetters() {
        double docTopicPrior = 1.0;
        double[][] topicWordProbs = new double[][]{{0.7, 0.25, 0.05}, {0.01, 0.3, 0.69}};
        LatentDirichletAllocation lda = new LatentDirichletAllocation(docTopicPrior, topicWordProbs);
        Assert.assertEquals((double)1.0, (double)lda.documentTopicPrior(), (double)1.0E-4);
        Assert.assertEquals((int)3, (int)lda.numWords());
        Assert.assertEquals((int)2, (int)lda.numTopics());
        for (int topic = 0; topic < lda.numTopics(); ++topic) {
            double[] topicWordProbsOut = lda.wordProbabilities(topic);
            for (int word = 0; word < lda.numWords(); ++word) {
                Assert.assertEquals((double)topicWordProbs[topic][word], (double)topicWordProbsOut[word], (double)1.0E-4);
                Assert.assertEquals((double)topicWordProbs[topic][word], (double)lda.wordProbability(topic, word), (double)1.0E-4);
            }
        }
    }

    @Test
    public void testExs() {
        double docTopicPrior = 1.0;
        double[][] topicWordProbs = new double[][]{{0.7, 0.25, 0.05}, {0.01, 0.3, 0.69}};
        LatentDirichletAllocation lda = new LatentDirichletAllocation(docTopicPrior, topicWordProbs);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExs1() {
        double[][] topicWordProbs = new double[][]{{0.7, 0.25, 0.05}, {0.01, 0.3, 0.69}};
        new LatentDirichletAllocation(0.0, topicWordProbs);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExs2() {
        double[][] topicWordProbs = new double[][]{{0.7, 0.25, 0.05}, {0.01, 0.3, 0.69}};
        new LatentDirichletAllocation(-1.0, topicWordProbs);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExs3() {
        double[][] topicWordProbs = new double[][]{{0.7, 0.25, 0.05}, {0.01, 0.3, 0.69}};
        new LatentDirichletAllocation(Double.NaN, topicWordProbs);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExs4() {
        double[][] topicWordProbs = new double[][]{{0.7, 0.25, 0.05}, {0.01, 0.3, 0.69}};
        new LatentDirichletAllocation(Double.POSITIVE_INFINITY, topicWordProbs);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExs5() {
        new LatentDirichletAllocation(1.0, new double[0][2]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExs6() {
        new LatentDirichletAllocation(1.0, new double[][]{{0.0, 1.0}, {-0.2, 0.5}});
    }

    @Test(expected=IllegalArgumentException.class)
    public void testExs7() {
        new LatentDirichletAllocation(1.0, new double[][]{{0.0, 1.0}, {0.5, 1.5}, {0.5, 0.5}});
    }
}

