/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.cluster;

import com.aliasi.cluster.Dendrogram;
import com.aliasi.cluster.LeafDendrogram;
import com.aliasi.cluster.SingleLinkClusterer;
import com.aliasi.util.Distance;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class SingleLinkClustererTest {
    static final Distance<String> TEST_DISTANCE = new TestDistance();

    @Test
    public void testBoundaries() {
        SingleLinkClusterer<String> clusterer = new SingleLinkClusterer<String>(TEST_DISTANCE);
        HashSet elts0 = new HashSet();
        Set clusters = clusterer.cluster(elts0);
        Assert.assertEquals((int)0, (int)clusters.size());
        HashSet<String> elts1 = new HashSet<String>();
        elts1.add("A");
        HashSet<HashSet<String>> clustering = new HashSet<HashSet<String>>();
        clustering.add(elts1);
        Assert.assertEquals(clustering, clusterer.cluster(elts1));
        Dendrogram<String> dendro1 = clusterer.hierarchicalCluster(elts1);
        Assert.assertTrue((boolean)(dendro1 instanceof LeafDendrogram));
        Assert.assertEquals(elts1, dendro1.memberSet());
        Assert.assertEquals((double)0.0, (double)dendro1.score(), (double)0.001);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testBoundariesExc() {
        SingleLinkClusterer<String> clusterer = new SingleLinkClusterer<String>(TEST_DISTANCE);
        HashSet elts0 = new HashSet();
        clusterer.hierarchicalCluster(elts0);
    }

    @Test
    public void testOne() {
        SingleLinkClusterer<String> clusterer = new SingleLinkClusterer<String>(TEST_DISTANCE);
        HashSet<String> elts = new HashSet<String>();
        elts.add("A");
        elts.add("B");
        elts.add("C");
        elts.add("D");
        elts.add("E");
        Dendrogram<String> dendro = clusterer.hierarchicalCluster(elts);
        HashSet<String> a = new HashSet<String>();
        a.add("A");
        HashSet<String> b = new HashSet<String>();
        b.add("B");
        HashSet<String> c = new HashSet<String>();
        c.add("C");
        HashSet<String> d = new HashSet<String>();
        d.add("D");
        HashSet<String> e = new HashSet<String>();
        e.add("E");
        HashSet<String> ab = new HashSet<String>();
        ab.addAll(a);
        ab.addAll(b);
        HashSet<String> abc = new HashSet<String>();
        abc.addAll(ab);
        abc.addAll(c);
        HashSet<String> de = new HashSet<String>();
        de.addAll(d);
        de.addAll(e);
        HashSet<String> abcde = new HashSet<String>();
        abcde.addAll(abc);
        abcde.addAll(de);
        Assert.assertEquals(abcde, dendro.memberSet());
        HashSet<HashSet<String>> p1 = new HashSet<HashSet<String>>();
        p1.add(abcde);
        Assert.assertEquals(p1, dendro.partitionK(1));
        HashSet<HashSet<String>> p2 = new HashSet<HashSet<String>>();
        p2.add(abc);
        p2.add(de);
        Assert.assertEquals(p2, dendro.partitionK(2));
        HashSet<HashSet<String>> p3 = new HashSet<HashSet<String>>();
        p3.add(abc);
        p3.add(d);
        p3.add(e);
        Assert.assertEquals(p3, dendro.partitionK(3));
        HashSet<HashSet<String>> p4 = new HashSet<HashSet<String>>();
        p4.add(ab);
        p4.add(c);
        p4.add(d);
        p4.add(e);
        Assert.assertEquals(p4, dendro.partitionK(4));
        HashSet<HashSet<String>> p5 = new HashSet<HashSet<String>>();
        p5.add(a);
        p5.add(b);
        p5.add(c);
        p5.add(d);
        p5.add(e);
        Assert.assertEquals(p5, dendro.partitionK(5));
        Assert.assertEquals((double)5.0, (double)dendro.score(), (double)0.001);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSlExc1() {
        SingleLinkClusterer<String> clusterer = new SingleLinkClusterer<String>(TEST_DISTANCE);
        HashSet<String> elts = new HashSet<String>();
        elts.add("A");
        elts.add("B");
        elts.add("C");
        elts.add("D");
        elts.add("E");
        Dendrogram<String> dendro = clusterer.hierarchicalCluster(elts);
        dendro.partitionK(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSlExc2() {
        SingleLinkClusterer<String> clusterer = new SingleLinkClusterer<String>(TEST_DISTANCE);
        HashSet<String> elts = new HashSet<String>();
        elts.add("A");
        elts.add("B");
        elts.add("C");
        elts.add("D");
        elts.add("E");
        Dendrogram<String> dendro = clusterer.hierarchicalCluster(elts);
        dendro.partitionK(6);
    }

    static class TestDistance
    extends FixedDistance<String> {
        TestDistance() {
            this.setVal("A", "B", 1.0);
            this.setVal("A", "C", 2.0);
            this.setVal("A", "D", 7.0);
            this.setVal("A", "E", 5.0);
            this.setVal("B", "C", 3.0);
            this.setVal("B", "D", 8.0);
            this.setVal("B", "E", 6.0);
            this.setVal("C", "D", 5.0);
            this.setVal("C", "E", 9.0);
            this.setVal("D", "E", 4.0);
        }
    }

    static class FixedDistance<E>
    implements Distance<E> {
        Map<E, Map<E, Double>> mVals = new HashMap<E, Map<E, Double>>();

        FixedDistance() {
        }

        @Override
        public double distance(E e1, E e2) {
            if (e1.equals(e2)) {
                return 0.0;
            }
            Map<E, Double> m1 = this.mVals.get(e1);
            if (m1 == null) {
                return Double.POSITIVE_INFINITY;
            }
            Double v = m1.get(e2);
            if (v == null) {
                return Double.POSITIVE_INFINITY;
            }
            return v;
        }

        public void setVal(E e1, E e2, double val) {
            this.set(e1, e2, val);
            this.set(e2, e1, val);
        }

        void set(E e1, E e2, double val) {
            Map<E, Double> m1 = this.mVals.get(e1);
            if (m1 == null) {
                m1 = new HashMap<E, Double>();
                this.mVals.put(e1, m1);
            }
            m1.put(e2, val);
        }
    }
}

