/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.coref;

import com.aliasi.coref.EnglishMentionFactory;
import com.aliasi.coref.Mention;
import com.aliasi.coref.WithinDocCoref;
import junit.framework.Assert;
import org.junit.Test;

public class WithinDocCorefTest {
    @Test
    public void testOne() {
        String[] phrases = new String[]{"Mr. John Smith", "John Smith", "Johanna Smith", "he", "IBM"};
        String[] entityTypes = new String[]{"PERSON", "PERSON", "PERSON", "MALE_PRONOUN", "ORGANIZATION"};
        int[] offsets = new int[]{1, 2, 3, 3, 3};
        int[] expectedIds = new int[]{0, 0, 1, 1, 2};
        this.assertCoref(phrases, entityTypes, offsets, expectedIds);
    }

    @Test
    public void testTwo() {
        String[] phrases = new String[]{"Mr. John Smith", "John Smith", "Johanna Smith", "he", "IBM"};
        String[] entityTypes = new String[]{"PERSON", "PERSON", "PERSON", "MALE_PRONOUN", "ORGANIZATION"};
        int[] offsets = new int[]{1, 2, 3, 3, 3};
        int[] expectedIds = new int[]{0, 0, 1, 1, 2};
        this.assertCoref(phrases, entityTypes, offsets, expectedIds);
    }

    public void assertCoref(String[] phrases, String[] entityTypes, int[] offsets, int[] refIds) {
        Assert.assertEquals((int)phrases.length, (int)entityTypes.length);
        Assert.assertEquals((int)phrases.length, (int)offsets.length);
        Assert.assertEquals((int)refIds.length, (int)offsets.length);
        EnglishMentionFactory factory = new EnglishMentionFactory();
        WithinDocCoref coref = new WithinDocCoref(factory);
        for (int i = 0; i < phrases.length; ++i) {
            Mention mention = factory.create(phrases[i], entityTypes[i]);
            Assert.assertEquals((int)refIds[i], (int)coref.resolveMention(mention, offsets[i]));
        }
    }
}

