/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.corpus;

import com.aliasi.corpus.Corpus;
import com.aliasi.corpus.ObjectHandler;
import com.aliasi.corpus.XValidatingObjectCorpus;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class XValidatingObjectCorpusTest {
    @Test
    public void testView() throws IOException {
        XValidatingObjectCorpus<String> corpus = new XValidatingObjectCorpus<String>(2);
        corpus.handle("a");
        corpus.handle("b");
        corpus.handle("c");
        corpus.handle("d");
        this.assertTest(corpus, "a", "b");
        this.assertTrain(corpus, "c", "d");
        XValidatingObjectCorpus<String> view = corpus.itemView();
        view.setFold(1);
        this.assertTest(view, "c", "d");
        this.assertTrain(view, "a", "b");
    }

    void assertTest(Corpus<ObjectHandler<String>> corpus, String ... expectedVals) throws IOException {
        final ArrayList vals = new ArrayList();
        corpus.visitTest(new ObjectHandler<String>(){

            @Override
            public void handle(String s) {
                vals.add(s);
            }
        });
        Assert.assertEquals(Arrays.asList(expectedVals), vals);
    }

    void assertTrain(Corpus<ObjectHandler<String>> corpus, String ... expectedVals) throws IOException {
        final ArrayList vals = new ArrayList();
        corpus.visitTrain(new ObjectHandler<String>(){

            @Override
            public void handle(String s) {
                vals.add(s);
            }
        });
        Assert.assertEquals(Arrays.asList(expectedVals), vals);
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testViewEx1() {
        XValidatingObjectCorpus<String> corpus = new XValidatingObjectCorpus<String>(2);
        corpus.handle("a");
        corpus.handle("b");
        XValidatingObjectCorpus view1 = corpus.itemView();
        view1.permuteCorpus(new Random());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testViewEx2() {
        XValidatingObjectCorpus<String> corpus = new XValidatingObjectCorpus<String>(2);
        corpus.handle("a");
        XValidatingObjectCorpus<String> view1 = corpus.itemView();
        view1.handle("b");
    }

    @Test
    public void testSerializable() throws IOException {
        XValidatingObjectCorpus<String> corpus = new XValidatingObjectCorpus<String>(2);
        corpus.handle("a");
        corpus.handle("b");
        corpus.handle("c");
        corpus.handle("d");
        corpus.permuteCorpus(new Random());
        XValidatingObjectCorpus corpus2 = (XValidatingObjectCorpus)AbstractExternalizable.serializeDeserialize(corpus);
        List<String> xs1 = XValidatingObjectCorpusTest.corpusToString(corpus);
        List<String> xs2 = XValidatingObjectCorpusTest.corpusToString(corpus2);
        Assert.assertEquals(xs1, xs2);
    }

    static List<String> corpusToString(XValidatingObjectCorpus<String> corpus) {
        final ArrayList<String> xs = new ArrayList<String>();
        corpus.visitCorpus(new ObjectHandler<String>(){

            @Override
            public void handle(String s) {
                xs.add(s);
            }
        });
        return xs;
    }

    @Test(expected=IllegalArgumentException.class)
    public void testConsEx() {
        new XValidatingObjectCorpus(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetNumFoldsExc() {
        XValidatingObjectCorpus corpus = new XValidatingObjectCorpus(12);
        corpus.setNumFolds(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFoldExc1() {
        XValidatingObjectCorpus corpus = new XValidatingObjectCorpus(12);
        corpus.setFold(-1);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSetFoldExc2() {
        XValidatingObjectCorpus corpus = new XValidatingObjectCorpus(12);
        corpus.setFold(12);
    }

    @Test
    public void testPermute() {
        XValidatingObjectCorpus<String> corpus = new XValidatingObjectCorpus<String>(3);
        corpus.handle("a");
        corpus.handle("b");
        corpus.handle("c");
        Random random = new Random();
        corpus.permuteCorpus(random);
        Collector collector = new Collector();
        corpus.visitCorpus(collector);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("a", "b", "c")), new HashSet<String>(collector.mItems));
    }

    @Test
    public void testAllZeroFolds() {
        XValidatingObjectCorpus<String> corpus = new XValidatingObjectCorpus<String>(0);
        corpus.handle("a");
        corpus.handle("b");
        corpus.handle("c");
        Random random = new Random();
        corpus.permuteCorpus(random);
        Collector collector = new Collector();
        corpus.visitTrain(collector);
        Assert.assertEquals(new HashSet<String>(Arrays.asList("a", "b", "c")), new HashSet<String>(collector.mItems));
        Collector collector2 = new Collector();
        corpus.visitTest(collector2);
        Assert.assertEquals((int)0, (int)collector2.mItems.size());
    }

    @Test
    public void testFolds() {
        XValidatingObjectCorpus<String> corpus = new XValidatingObjectCorpus<String>(3);
        corpus.handle("a");
        corpus.handle("b");
        corpus.handle("c");
        corpus.handle("d");
        corpus.handle("e");
        corpus.handle("f");
        this.assertTrainTest(corpus, 0, Arrays.asList("c", "d", "e", "f"), Arrays.asList("a", "b"));
        this.assertTrainTest(corpus, 1, Arrays.asList("a", "b", "e", "f"), Arrays.asList("c", "d"));
        this.assertTrainTest(corpus, 2, Arrays.asList("a", "b", "c", "d"), Arrays.asList("e", "f"));
    }

    void assertTrainTest(XValidatingObjectCorpus<String> corpus, int fold, List<String> trainCases, List<String> testCases) {
        corpus.setFold(fold);
        Collector collector = new Collector();
        corpus.visitTrain(collector);
        Assert.assertEquals(trainCases, collector.mItems);
        Collector collector2 = new Collector();
        corpus.visitTest(collector2);
        Assert.assertEquals(testCases, collector2.mItems);
    }

    static class Collector
    implements ObjectHandler<String> {
        List<String> mItems = new ArrayList<String>();

        Collector() {
        }

        @Override
        public void handle(String s) {
            this.mItems.add(s);
        }
    }
}

