/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.dict;

import com.aliasi.dict.DictionaryEntry;
import com.aliasi.dict.TrieDictionary;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import junit.framework.Assert;
import org.junit.Test;

public class TrieDictionaryTest {
    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        DictionaryEntry<String> entry1 = new DictionaryEntry<String>("this", "DET", 5, 15.0);
        DictionaryEntry<String> entry2 = new DictionaryEntry<String>("the", "DET", 5.0);
        DictionaryEntry<String> entry3 = new DictionaryEntry<String>("that", "DET", 5);
        DictionaryEntry<String> entry4 = new DictionaryEntry<String>("that", "NP");
        DictionaryEntry<String> entry5 = new DictionaryEntry<String>("a", "DET");
        DictionaryEntry<String> entry6 = new DictionaryEntry<String>("member", "N");
        TrieDictionary<String> dict = new TrieDictionary<String>();
        dict.addEntry(entry1);
        dict.addEntry(entry2);
        dict.addEntry(entry3);
        dict.addEntry(entry4);
        dict.addEntry(entry5);
        dict.addEntry(entry6);
        TrieDictionary dict2 = (TrieDictionary)AbstractExternalizable.compile(dict);
        TrieDictionary dict3 = (TrieDictionary)AbstractExternalizable.serializeDeserialize(dict);
        this.assertEqualElts(dict, dict2);
        this.assertEqualElts(dict, dict3);
    }

    void assertEqualElts(TrieDictionary<String> dict, TrieDictionary<String> dict2) {
        Assert.assertEquals(this.getElements(dict), this.getElements(dict2));
    }

    Set<DictionaryEntry<String>> getElements(TrieDictionary<String> dict) {
        HashSet<DictionaryEntry<String>> elts = new HashSet<DictionaryEntry<String>>();
        for (DictionaryEntry<String> dictionaryEntry : dict) {
            elts.add(dictionaryEntry);
        }
        return elts;
    }

    @Test
    public void testOne() {
        TrieDictionary<String> dict = new TrieDictionary<String>();
        Assert.assertFalse((boolean)dict.iterator().hasNext());
        Assert.assertEquals((int)0, (int)dict.size());
        DictionaryEntry<String> entryThis = new DictionaryEntry<String>("this", "DET");
        DictionaryEntry<String> entryThe = new DictionaryEntry<String>("the", "DET");
        DictionaryEntry<String> entryThat = new DictionaryEntry<String>("that", "DET");
        DictionaryEntry<String> entryThat2 = new DictionaryEntry<String>("that", "NP");
        DictionaryEntry<String> entryA = new DictionaryEntry<String>("a", "DET");
        DictionaryEntry<String> entryMember = new DictionaryEntry<String>("member", "N");
        dict.addEntry(entryThis);
        this.assertDict(new DictionaryEntry[]{entryThis}, dict);
        dict.addEntry(entryThe);
        this.assertDict(new DictionaryEntry[]{entryThe, entryThis}, dict);
        dict.addEntry(entryA);
        dict.addEntry(entryA);
        this.assertDict(new DictionaryEntry[]{entryA, entryThe, entryThis}, dict);
        dict.addEntry(entryMember);
        this.assertDict(new DictionaryEntry[]{entryA, entryMember, entryThe, entryThis}, dict);
        dict.addEntry(entryThat);
        dict.addEntry(entryThat2);
        DictionaryEntry[] entries = new DictionaryEntry[]{entryA, entryMember, entryThe, entryThis, entryThat, entryThat2};
        HashSet<DictionaryEntry> expectedEntrySet = new HashSet<DictionaryEntry>(Arrays.asList(entries));
        Assert.assertEquals((int)entries.length, (int)expectedEntrySet.size());
        Assert.assertEquals(expectedEntrySet, new HashSet(dict.entryList()));
        this.assertPhraseEntries(dict, "that", new Object[]{entryThat, entryThat2});
        this.assertPhraseEntries(dict, "the", new Object[]{entryThe});
        this.assertPhraseEntries(dict, "member", new Object[]{entryMember});
        this.assertPhraseEntries(dict, "foo", new Object[0]);
        this.assertCatEntries(dict, "DET", new Object[]{entryA, entryThe, entryThis, entryThat});
        this.assertCatEntries(dict, "NP", new Object[]{entryThat2});
        this.assertCatEntries(dict, "V", new Object[0]);
    }

    void assertCatEntries(TrieDictionary dict, Object cat, Object[] entries) {
        HashSet<Object> expectedEntrySet = new HashSet<Object>(Arrays.asList(entries));
        HashSet<DictionaryEntry<Object>> foundSet = new HashSet<DictionaryEntry<Object>>(dict.categoryEntryList(cat));
        Assert.assertEquals(expectedEntrySet, foundSet);
    }

    void assertPhraseEntries(TrieDictionary dict, String phrase, Object[] entries) {
        HashSet<Object> expectedEntrySet = new HashSet<Object>(Arrays.asList(entries));
        HashSet foundSet = new HashSet(dict.phraseEntryList(phrase));
        Assert.assertEquals(expectedEntrySet, foundSet);
    }

    void assertDict(DictionaryEntry[] entries, TrieDictionary dict) {
        Assert.assertEquals((int)entries.length, (int)dict.size());
        Iterator it = dict.iterator();
        for (int i = 0; i < entries.length; ++i) {
            Assert.assertEquals((Object)entries[i], it.next());
        }
    }
}

