/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.features;

import com.aliasi.features.KnownFeatureExtractor;
import com.aliasi.test.unit.features.MockFeatureExtractor;
import com.aliasi.test.unit.features.SerializableMockFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import com.aliasi.util.ObjectToDoubleMap;
import java.io.IOException;
import java.io.NotSerializableException;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class KnownFeatureExtractorTest {
    @Test
    public void testBasic() {
        ObjectToDoubleMap<String> feats1 = new ObjectToDoubleMap<String>();
        feats1.put("A", 10.0);
        feats1.put("B", 2.0);
        feats1.put("C", -50.0);
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        mfe.put(1, feats1);
        HashSet<String> knownFeatureSet = new HashSet<String>(Arrays.asList("A", "C"));
        KnownFeatureExtractor<Integer> knownFe = new KnownFeatureExtractor<Integer>(mfe, knownFeatureSet);
        Assert.assertEquals(knownFeatureSet, knownFe.knownFeatureSet());
        Map<String, Number> feats = knownFe.features(1);
        Assert.assertEquals((Object)10.0, (Object)feats.get("A"));
        Assert.assertNull((Object)feats.get("B"));
        Assert.assertEquals((Object)-50.0, (Object)feats.get("C"));
    }

    @Test
    public void testSerialize() throws IOException, ClassNotFoundException {
        ObjectToDoubleMap<String> feats1 = new ObjectToDoubleMap<String>();
        feats1.put("A", 10.0);
        feats1.put("B", 2.0);
        feats1.put("C", -50.0);
        SerializableMockFeatureExtractor mfe = new SerializableMockFeatureExtractor();
        mfe.put(1, feats1);
        HashSet<String> knownFeatureSet = new HashSet<String>(Arrays.asList("A", "C"));
        KnownFeatureExtractor<Integer> knownFe = new KnownFeatureExtractor<Integer>(mfe, knownFeatureSet);
        FeatureExtractor knownFe2 = (FeatureExtractor)AbstractExternalizable.serializeDeserialize(knownFe);
        Map<String, Number> feats = knownFe2.features(1);
        Assert.assertEquals((Object)10.0, (Object)feats.get("A"));
        Assert.assertNull((Object)feats.get("B"));
        Assert.assertEquals((Object)-50.0, (Object)feats.get("C"));
    }

    @Test(expected=NotSerializableException.class)
    public void testUnSerialize() throws IOException, ClassNotFoundException {
        MockFeatureExtractor mfe = new MockFeatureExtractor();
        HashSet<String> knownSet = new HashSet<String>();
        KnownFeatureExtractor<Integer> knownFe = new KnownFeatureExtractor<Integer>(mfe, knownSet);
        AbstractExternalizable.serializeDeserialize(knownFe);
    }
}

