/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.features;

import com.aliasi.features.PrefixedFeatureExtractor;
import com.aliasi.test.unit.features.MockFeatureExtractor;
import com.aliasi.test.unit.features.SerializableMockFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class PrefixedFeatureExtractorTest {
    @Test
    public void testAll() throws IOException {
        SerializableMockFeatureExtractor fe = new SerializableMockFeatureExtractor();
        fe.put(15, new String[]{"a", "b", "c"}, new double[]{1.5, 2.0, 3.0});
        fe.put(12, new String[0], new double[0]);
        Assert.assertNotNull((Object)AbstractExternalizable.serializeDeserialize(fe));
        PrefixedFeatureExtractor<Integer> pfe = new PrefixedFeatureExtractor<Integer>("pref_", fe);
        Map<String, Number> featMap = pfe.features(15);
        MockFeatureExtractor.assertFeats(pfe, 15, new String[]{"pref_a", "pref_b", "pref_c"}, new double[]{1.5, 2.0, 3.0});
        MockFeatureExtractor.assertFeats(pfe, 12, new String[0], new double[0]);
        FeatureExtractor pfeDeser = (FeatureExtractor)AbstractExternalizable.serializeDeserialize(pfe);
        MockFeatureExtractor.assertFeats(pfeDeser, 15, new String[]{"pref_a", "pref_b", "pref_c"}, new double[]{1.5, 2.0, 3.0});
        MockFeatureExtractor.assertFeats(pfeDeser, 12, new String[0], new double[0]);
    }
}

