/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.features;

import com.aliasi.features.StringLengthFeatureExtractor;
import com.aliasi.util.AbstractExternalizable;
import com.aliasi.util.FeatureExtractor;
import java.io.IOException;
import java.util.Map;
import junit.framework.Assert;
import org.junit.Test;

public class StringLengthFeatureExtractorTest {
    @Test(expected=IllegalArgumentException.class)
    public void testEx1() {
        new StringLengthFeatureExtractor(new int[0]);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testEx2() {
        new StringLengthFeatureExtractor(2, -1);
    }

    @Test
    public void testAll() throws IOException {
        StringLengthFeatureExtractor fe = new StringLengthFeatureExtractor(5, 1, 2);
        Map<String, ? extends Number> features = fe.features("");
        Assert.assertTrue((boolean)features.isEmpty());
        features = fe.features("a");
        Assert.assertEquals((int)1, (int)features.size());
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=1").doubleValue(), (double)1.0E-4);
        features = fe.features("abc");
        Assert.assertEquals((int)2, (int)features.size());
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=1").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=2").doubleValue(), (double)1.0E-4);
        features = fe.features("abcdef");
        Assert.assertEquals((int)3, (int)features.size());
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=1").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=2").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=5").doubleValue(), (double)1.0E-4);
        FeatureExtractor fe2 = (FeatureExtractor)AbstractExternalizable.serializeDeserialize(fe);
        features = fe2.features("a");
        Assert.assertEquals((int)1, (int)features.size());
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=1").doubleValue(), (double)1.0E-4);
        features = fe2.features("abc");
        Assert.assertEquals((int)2, (int)features.size());
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=1").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=2").doubleValue(), (double)1.0E-4);
        features = fe2.features("abcdef");
        Assert.assertEquals((int)3, (int)features.size());
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=1").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=2").doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)features.get("LEN>=5").doubleValue(), (double)1.0E-4);
    }
}

