/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.io;

import com.aliasi.io.BitInput;
import com.aliasi.io.BitOutput;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Random;
import junit.framework.Assert;
import org.junit.Test;

public class BitInputTest {
    @Test
    public void testUnaryBig() throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        BitOutput bitOutput = new BitOutput(bytesOut);
        for (int i = 1; i < 150; ++i) {
            bitOutput.writeUnary(i);
        }
        bitOutput.writeUnary(1500);
        bitOutput.flush();
        byte[] bytes = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        BitInput bitInput = new BitInput(bytesIn);
        for (int i = 1; i < 150; ++i) {
            Assert.assertEquals((int)i, (int)bitInput.readUnary());
        }
        Assert.assertEquals((int)1500, (int)bitInput.readUnary());
    }

    @Test
    public void testUnary() throws IOException {
        String bits = "10100001";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        Assert.assertEquals((int)1, (int)bitsIn.readUnary());
        Assert.assertEquals((int)2, (int)bitsIn.readUnary());
        Assert.assertFalse((boolean)bitsIn.endOfStream());
        Assert.assertEquals((int)5, (int)bitsIn.readUnary());
        Assert.assertTrue((boolean)bitsIn.endOfStream());
    }

    @Test
    public void testUnary2() throws IOException {
        String bits = "0000000000000010";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        Assert.assertEquals((int)15, (int)bitsIn.readUnary());
        Assert.assertFalse((boolean)bitsIn.endOfStream());
    }

    @Test(expected=IOException.class)
    public void testUnaryExceptions() throws IOException {
        String bits = "00000000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        bitsIn.readUnary();
    }

    @Test
    public void testBitInputStream() {
        BitInputStream bitIn = new BitInputStream("00100100");
        Assert.assertEquals((int)1, (int)bitIn.available());
        Assert.assertEquals((int)36, (int)bitIn.read());
        Assert.assertEquals((int)-1, (int)bitIn.read());
        bitIn = new BitInputStream("111111110000000000000001");
        Assert.assertEquals((int)3, (int)bitIn.available());
        Assert.assertEquals((int)255, (int)bitIn.read());
        Assert.assertEquals((int)0, (int)bitIn.read());
        Assert.assertEquals((int)1, (int)bitIn.read());
        Assert.assertEquals((int)-1, (int)bitIn.read());
    }

    @Test
    public void testBitInput() throws IOException {
        BitInputStream in = new BitInputStream("1010101001101101");
        BitInput bitsIn = new BitInput(in);
        Assert.assertEquals((long)16L, (long)bitsIn.available());
        Assert.assertEquals((boolean)true, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)false, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)true, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)false, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)true, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)false, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)true, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)false, (boolean)bitsIn.readBit());
        Assert.assertFalse((boolean)bitsIn.endOfStream());
        Assert.assertEquals((boolean)false, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)true, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)true, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)false, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)true, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)true, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)false, (boolean)bitsIn.readBit());
        Assert.assertEquals((boolean)true, (boolean)bitsIn.readBit());
        Assert.assertTrue((boolean)bitsIn.endOfStream());
        Assert.assertFalse((boolean)in.mClosed);
        bitsIn.close();
        Assert.assertTrue((boolean)in.mClosed);
    }

    @Test(expected=IOException.class)
    public void testBinaryExceptions() throws IOException {
        BitInput bitsIn = BitInputTest.bitInput("01010101");
        bitsIn.readBinary(9);
    }

    @Test
    public void testBinary() throws IOException {
        String bits = "0100011011000001111000000000000000100000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        Assert.assertEquals((long)0L, (long)bitsIn.readBinary(1));
        Assert.assertEquals((long)1L, (long)bitsIn.readBinary(1));
        Assert.assertEquals((long)0L, (long)bitsIn.readBinary(2));
        Assert.assertEquals((long)1L, (long)bitsIn.readBinary(2));
        Assert.assertEquals((long)2L, (long)bitsIn.readBinary(2));
        Assert.assertEquals((long)3L, (long)bitsIn.readBinary(2));
        Assert.assertEquals((long)0L, (long)bitsIn.readBinary(3));
        Assert.assertEquals((long)1L, (long)bitsIn.readBinary(3));
        Assert.assertEquals((long)7L, (long)bitsIn.readBinary(3));
        Assert.assertEquals((long)1L, (long)bitsIn.readBinary(16));
        Assert.assertFalse((boolean)bitsIn.endOfStream());
        Assert.assertEquals((long)0L, (long)bitsIn.readBinary(5));
        Assert.assertTrue((boolean)bitsIn.endOfStream());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRiceExceptions() throws IOException {
        BitInput bitInput = BitInputTest.bitInput("00000001");
        bitInput.readRice(0);
    }

    @Test(expected=IllegalArgumentException.class)
    public void testRiceExceptions2() throws IOException {
        BitInput bitInput = BitInputTest.bitInput("00000001");
        bitInput.readRice(65);
    }

    @Test(expected=IOException.class)
    public void testRiceExceptions3() throws IOException {
        BitInput bitInput = BitInputTest.bitInput("00000001");
        bitInput.readRice(15);
    }

    @Test
    public void testRice() throws IOException {
        String bits = "10110100110010001100000000100000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        Assert.assertEquals((long)1L, (long)bitsIn.readRice(1));
        Assert.assertEquals((long)2L, (long)bitsIn.readRice(1));
        Assert.assertEquals((long)3L, (long)bitsIn.readRice(1));
        Assert.assertEquals((long)4L, (long)bitsIn.readRice(1));
        Assert.assertEquals((long)5L, (long)bitsIn.readRice(1));
        Assert.assertEquals((long)6L, (long)bitsIn.readRice(1));
        Assert.assertEquals((long)17L, (long)bitsIn.readRice(1));
        Assert.assertFalse((boolean)bitsIn.endOfStream());
    }

    @Test(expected=IOException.class)
    public void testRiceExc() throws IOException {
        String bits = "10110100110010001100000000100000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        bitsIn.readRice(1);
        bitsIn.readRice(1);
        bitsIn.readRice(1);
        bitsIn.readRice(1);
        bitsIn.readRice(1);
        bitsIn.readRice(1);
        bitsIn.readRice(1);
        bitsIn.readRice(1);
    }

    @Test
    public void testRice2() throws IOException {
        String bits = "10010111011101000101000010000000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        Assert.assertEquals((long)1L, (long)bitsIn.readRice(2));
        Assert.assertEquals((long)2L, (long)bitsIn.readRice(2));
        Assert.assertEquals((long)3L, (long)bitsIn.readRice(2));
        Assert.assertEquals((long)4L, (long)bitsIn.readRice(2));
        Assert.assertEquals((long)5L, (long)bitsIn.readRice(2));
        Assert.assertEquals((long)6L, (long)bitsIn.readRice(2));
        Assert.assertEquals((long)17L, (long)bitsIn.readRice(2));
        Assert.assertFalse((boolean)bitsIn.endOfStream());
    }

    @Test(expected=IOException.class)
    public void testRice2Exc() throws IOException {
        String bits = "10010111011101000101000010000000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        bitsIn.readRice(2);
        bitsIn.readRice(2);
        bitsIn.readRice(2);
        bitsIn.readRice(2);
        bitsIn.readRice(2);
        bitsIn.readRice(2);
        bitsIn.readRice(2);
        bitsIn.readRice(2);
    }

    @Test
    public void testRice3() throws IOException {
        String bits = "10001001101010111100110100100000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        Assert.assertEquals((long)1L, (long)bitsIn.readRice(3));
        Assert.assertEquals((long)2L, (long)bitsIn.readRice(3));
        Assert.assertEquals((long)3L, (long)bitsIn.readRice(3));
        Assert.assertEquals((long)4L, (long)bitsIn.readRice(3));
        Assert.assertEquals((long)5L, (long)bitsIn.readRice(3));
        Assert.assertEquals((long)6L, (long)bitsIn.readRice(3));
        Assert.assertEquals((long)17L, (long)bitsIn.readRice(3));
        Assert.assertFalse((boolean)bitsIn.endOfStream());
    }

    @Test(expected=IOException.class)
    public void testRice3Exc() throws IOException {
        String bits = "10001001101010111100110100100000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        bitsIn.readRice(3);
        bitsIn.readRice(3);
        bitsIn.readRice(3);
        bitsIn.readRice(3);
        bitsIn.readRice(3);
        bitsIn.readRice(3);
        bitsIn.readRice(3);
        bitsIn.readRice(3);
    }

    @Test(expected=IOException.class)
    public void testFibonacciExceptions() throws IOException {
        String bits = "00000000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        bitsIn.readFibonacci();
    }

    @Test
    public void testFibonacci() throws IOException {
        String bits = "1101100111011000111001101011101001100000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        Assert.assertEquals((long)1L, (long)bitsIn.readFibonacci());
        Assert.assertEquals((long)2L, (long)bitsIn.readFibonacci());
        Assert.assertEquals((long)3L, (long)bitsIn.readFibonacci());
        Assert.assertEquals((long)4L, (long)bitsIn.readFibonacci());
        Assert.assertEquals((long)5L, (long)bitsIn.readFibonacci());
        Assert.assertEquals((long)6L, (long)bitsIn.readFibonacci());
        Assert.assertEquals((long)7L, (long)bitsIn.readFibonacci());
        Assert.assertEquals((long)17L, (long)bitsIn.readFibonacci());
    }

    @Test(expected=IOException.class)
    public void testFibonacciExcs() throws IOException {
        String bits = "1101100111011000111001101011101001100000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        bitsIn.readFibonacci();
        bitsIn.readFibonacci();
        bitsIn.readFibonacci();
        bitsIn.readFibonacci();
        bitsIn.readFibonacci();
        bitsIn.readFibonacci();
        bitsIn.readFibonacci();
        bitsIn.readFibonacci();
        bitsIn.readFibonacci();
    }

    @Test
    public void testN2Minus1RoundTrips() throws IOException {
        long[] testVals = new long[]{2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L};
        this.testRoundTrip(testVals);
    }

    @Test
    public void testLowRoundTrips() throws IOException {
        long[] testVals = new long[1024];
        for (int i = 0; i < testVals.length; ++i) {
            testVals[i] = i + 1;
        }
        this.testRoundTrip(testVals);
    }

    @Test
    public void testRandomRoundTrips() throws IOException {
        long[] testVals = BitInputTest.randomVals(100, 0, 62);
        this.testRoundTrip(testVals);
    }

    void testRoundTrip(long[] testVals) throws IOException {
        ByteArrayOutputStream bytesOut = new ByteArrayOutputStream();
        BitOutput bitOutput = new BitOutput(bytesOut);
        for (int i = 0; i < testVals.length; ++i) {
            bitOutput.writeBinary(testVals[i], 63);
            bitOutput.writeGamma(testVals[i]);
            bitOutput.writeDelta(testVals[i]);
            bitOutput.writeFibonacci(testVals[i]);
            bitOutput.writeRice(testVals[i], 59);
            bitOutput.writeRice(testVals[i], 61);
            bitOutput.writeRice(testVals[i], 63);
        }
        bitOutput.flush();
        Random random = new Random();
        byte[] bytes = bytesOut.toByteArray();
        ByteArrayInputStream bytesIn = new ByteArrayInputStream(bytes);
        BitInput bitInput = new BitInput(bytesIn);
        for (int i = 0; i < testVals.length; ++i) {
            if (random.nextBoolean()) {
                bitInput.skip(63L);
            } else {
                Assert.assertEquals((String)"binary", (long)testVals[i], (long)bitInput.readBinary(63));
            }
            if (random.nextBoolean()) {
                bitInput.skipGamma();
            } else {
                Assert.assertEquals((String)"gamma", (long)testVals[i], (long)bitInput.readGamma());
            }
            if (random.nextBoolean()) {
                bitInput.skipDelta();
            } else {
                Assert.assertEquals((String)"delta", (long)testVals[i], (long)bitInput.readDelta());
            }
            if (random.nextBoolean()) {
                bitInput.skipFibonacci();
            } else {
                Assert.assertEquals((String)"fib", (long)testVals[i], (long)bitInput.readFibonacci());
            }
            if (random.nextBoolean()) {
                bitInput.skipRice(59);
            } else {
                Assert.assertEquals((String)"rice59", (long)testVals[i], (long)bitInput.readRice(59));
            }
            if (random.nextBoolean()) {
                bitInput.skipRice(61);
            } else {
                Assert.assertEquals((String)"rice61", (long)testVals[i], (long)bitInput.readRice(61));
            }
            if (random.nextBoolean()) {
                bitInput.skipRice(63);
                continue;
            }
            Assert.assertEquals((String)"rice63", (long)testVals[i], (long)bitInput.readRice(63));
        }
    }

    public static long[] randomVals(int sizePer, int minShift, int maxShift) {
        Random random = new Random();
        long[] vals = new long[sizePer * (maxShift - minShift + 1)];
        int index = 0;
        for (int shift = minShift; shift <= maxShift; ++shift) {
            for (int i = 0; i < sizePer; ++i) {
                long n = random.nextLong();
                if (n < 0L) {
                    n = -(n + 1L);
                }
                if ((n >>>= shift) == 0L) {
                    // empty if block
                }
                vals[index++] = ++n;
            }
        }
        return vals;
    }

    @Test(expected=IOException.class)
    public void testGammaException() throws IOException {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 75; ++i) {
            sb.append("0");
        }
        sb.append("1");
        sb.append("00000001010101010000");
        BitInput bitsIn = BitInputTest.bitInput(sb.toString());
        bitsIn.readGamma();
    }

    @Test(expected=IOException.class)
    public void testGammaException2() throws IOException {
        BitInput bitsIn = BitInputTest.bitInput("00001000");
        bitsIn.readGamma();
    }

    @Test
    public void testGamma() throws IOException {
        String bits = "10100110010000101000010001000000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        Assert.assertEquals((long)1L, (long)bitsIn.readGamma());
        Assert.assertEquals((long)2L, (long)bitsIn.readGamma());
        Assert.assertEquals((long)3L, (long)bitsIn.readGamma());
        Assert.assertEquals((long)4L, (long)bitsIn.readGamma());
        Assert.assertEquals((long)5L, (long)bitsIn.readGamma());
        Assert.assertEquals((long)17L, (long)bitsIn.readGamma());
        Assert.assertFalse((boolean)bitsIn.endOfStream());
        try {
            bitsIn.readGamma();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assert.assertTrue((boolean)bitsIn.endOfStream());
    }

    @Test(expected=IOException.class)
    public void testGammaExc() throws IOException {
        String bits = "10100110010000101000010001000000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        bitsIn.readGamma();
        bitsIn.readGamma();
        bitsIn.readGamma();
        bitsIn.readGamma();
        bitsIn.readGamma();
        bitsIn.readGamma();
        bitsIn.readGamma();
    }

    @Test(expected=IOException.class)
    public void testDeltaExceptions() throws IOException {
        StringBuilder sb = new StringBuilder();
        sb.append("000000011111111");
        for (int i = 0; i < 305; ++i) {
            sb.append("0");
        }
        BitInput bitsIn = BitInputTest.bitInput(sb.toString());
        bitsIn.readDelta();
    }

    @Test(expected=IOException.class)
    public void testDeltaExceptions2() throws IOException {
        BitInput bitsIn = BitInputTest.bitInput("00111000");
        bitsIn.readDelta();
    }

    @Test
    public void testDelta() throws IOException {
        String bits = "10100010101100011010010100010000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        Assert.assertEquals((long)1L, (long)bitsIn.readDelta());
        Assert.assertEquals((long)2L, (long)bitsIn.readDelta());
        Assert.assertEquals((long)3L, (long)bitsIn.readDelta());
        Assert.assertEquals((long)4L, (long)bitsIn.readDelta());
        Assert.assertEquals((long)5L, (long)bitsIn.readDelta());
        Assert.assertEquals((long)17L, (long)bitsIn.readDelta());
        Assert.assertFalse((boolean)bitsIn.endOfStream());
    }

    @Test(expected=IOException.class)
    public void testDeltaExc() throws IOException {
        String bits = "10100010101100011010010100010000";
        BitInput bitsIn = BitInputTest.bitInput(bits);
        bitsIn.readDelta();
        bitsIn.readDelta();
        bitsIn.readDelta();
        bitsIn.readDelta();
        bitsIn.readDelta();
        bitsIn.readDelta();
        bitsIn.readDelta();
    }

    @Test
    public void testSkip() throws IOException {
        BitInputStream in = new BitInputStream("1010101001101101");
        BitInput bitsIn = new BitInput(in);
        Assert.assertEquals((long)7L, (long)bitsIn.skip(7L));
        Assert.assertFalse((boolean)bitsIn.readBit());
        Assert.assertEquals((long)8L, (long)bitsIn.skip(9L));
        Assert.assertTrue((boolean)bitsIn.endOfStream());
        in = new BitInputStream("111111110000000000000001");
        bitsIn = new BitInput(in);
        bitsIn.readBit();
        bitsIn.readBit();
        Assert.assertEquals((long)9L, (long)bitsIn.skip(9L));
        Assert.assertEquals((long)13L, (long)bitsIn.available());
        in = new BitInputStream("111111110000000000000001");
        bitsIn = new BitInput(in);
        bitsIn.readBit();
        Assert.assertEquals((long)23L, (long)bitsIn.skip(23L));
        Assert.assertTrue((boolean)bitsIn.endOfStream());
    }

    @Test(expected=IllegalArgumentException.class)
    public void testSkipExc() throws IOException {
        BitInputStream in = new BitInputStream("1010101001101101");
        BitInput bitsIn = new BitInput(in);
        bitsIn.skip(-12L);
    }

    static BitInput bitInput(String inputBits) throws IOException {
        return new BitInput(new BitInputStream(inputBits));
    }

    static class BitInputStream
    extends ByteArrayInputStream {
        boolean mClosed = false;

        public BitInputStream(String inputBits) {
            super(BitInputStream.bitsToBytes(inputBits));
        }

        static byte[] bitsToBytes(String bits) {
            if (bits.length() % 8 != 0) {
                String msg = "bits.length()=" + bits.length();
                throw new IllegalArgumentException(msg);
            }
            byte[] bytes = new byte[bits.length() / 8];
            int i = 0;
            int n = 0;
            while (i < bits.length()) {
                bytes[n] = (byte)Integer.parseInt(bits.substring(i, i + 8), 2);
                i += 8;
                ++n;
            }
            return bytes;
        }

        @Override
        public void close() {
            this.mClosed = true;
        }
    }
}

