/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.matrix;

import com.aliasi.matrix.AbstractVector;
import com.aliasi.matrix.DenseVector;
import com.aliasi.matrix.Vector;
import com.aliasi.test.unit.Asserts;
import junit.framework.Assert;
import org.junit.Test;

public class AbstractVectorTest {
    @Test
    public void testOne() {
        Vector1 v1 = new Vector1();
        Vector2 v2 = new Vector2();
        Assert.assertFalse((boolean)v1.equals(v2));
        Assert.assertEquals((Object)v1, (Object)v1);
        Vector v3 = v1.add(v2);
        Assert.assertEquals((int)3, (int)v3.numDimensions());
        Assert.assertEquals((double)8.0, (double)v3.value(1), (double)1.0E-5);
        double l1 = Math.sqrt(14.0);
        double l2 = Math.sqrt(110.0);
        Assert.assertEquals((Object)l1, (Object)v1.length());
        double dot = 38.0;
        Assert.assertEquals((Object)dot, (Object)v1.dotProduct(v2));
        double cos = dot / (l1 * l2);
        Assert.assertEquals((double)cos, (double)v1.cosine(v2), (double)1.0E-5);
        try {
            v1.setValue(1, 3.0);
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Asserts.succeed();
        }
        try {
            v1.value(7);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            Asserts.succeed();
        }
        int[] expectedNonZeroDims = new int[]{0, 1, 2};
        int[] nonZeroDims = v1.nonZeroDimensions();
        Assert.assertEquals((int)expectedNonZeroDims.length, (int)nonZeroDims.length);
        for (int i = 0; i < nonZeroDims.length; ++i) {
            Assert.assertEquals((int)expectedNonZeroDims[i], (int)nonZeroDims[i]);
        }
        try {
            v1.increment(1.0, new DenseVector(new double[]{-1.0, 0.0, 0.0}));
            Assert.fail();
        }
        catch (UnsupportedOperationException e) {
            Asserts.succeed();
        }
        Assert.assertEquals((double)1.0, (double)v1.value(0), (double)1.0E-5);
    }

    @Test
    public void testMut() {
        MutVect v = new MutVect();
        Assert.assertEquals((int)0, (int)v.nonZeroDimensions().length);
        v.increment(3.0, new Vector1());
        Assert.assertEquals((int)3, (int)v.nonZeroDimensions().length);
        Assert.assertEquals((double)3.0, (double)v.value(0), (double)1.0E-4);
        Assert.assertEquals((double)6.0, (double)v.value(1), (double)1.0E-4);
        Assert.assertEquals((double)9.0, (double)v.value(2), (double)1.0E-4);
        MutVect v2 = new MutVect();
        v2.increment(1.0, new DenseVector(new double[]{0.0, 1.0, 0.0}));
        Assert.assertEquals((int)1, (int)v2.nonZeroDimensions().length);
        Assert.assertEquals((int)1, (int)v2.nonZeroDimensions()[0]);
    }

    public static class Vector2
    extends AbstractVector {
        @Override
        public int numDimensions() {
            return 3;
        }

        @Override
        public double value(int d) {
            if (d == 0) {
                return 5.0;
            }
            if (d == 1) {
                return 6.0;
            }
            if (d == 2) {
                return 7.0;
            }
            throw new IndexOutOfBoundsException("boo");
        }
    }

    public static class Vector1
    extends AbstractVector {
        @Override
        public int numDimensions() {
            return 3;
        }

        @Override
        public double value(int d) {
            if (d == 0) {
                return 1.0;
            }
            if (d == 1) {
                return 2.0;
            }
            if (d == 2) {
                return 3.0;
            }
            throw new IndexOutOfBoundsException("boo");
        }
    }

    public static class MutVect
    extends AbstractVector {
        double[] xs = new double[]{0.0, 0.0, 0.0};

        @Override
        public int numDimensions() {
            return 3;
        }

        @Override
        public double value(int i) {
            return this.xs[i];
        }

        @Override
        public void setValue(int i, double v) {
            this.xs[i] = v;
        }
    }
}

