/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.matrix;

import com.aliasi.matrix.DenseVector;
import com.aliasi.matrix.SparseFloatVector;
import com.aliasi.test.unit.Asserts;
import com.aliasi.util.AbstractExternalizable;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import org.junit.Test;

public class DenseVectorTest {
    @Test
    public void testSerialize() throws IOException {
        this.assertSerializeDeserialize(new DenseVector(new double[]{1.0}));
        this.assertSerializeDeserialize(new DenseVector(new double[]{1.0, 2.0, 3.0}));
        this.assertSerializeDeserialize(new DenseVector(17));
        this.assertSerializeDeserialize(new DenseVector(new DenseVector(17)));
    }

    void assertSerializeDeserialize(DenseVector v) throws IOException {
        DenseVector v2 = (DenseVector)AbstractExternalizable.serializeDeserialize(v);
        Assert.assertEquals((int)v.numDimensions(), (int)v2.numDimensions());
        for (int i = 0; i < v.numDimensions(); ++i) {
            Assert.assertEquals((double)v.value(i), (double)v2.value(i), (double)1.0E-6);
        }
    }

    @Test
    public void testIncrementZeros() {
        DenseVector v1 = new DenseVector(new double[]{1.0, 2.0, 3.0});
        DenseVector v2 = new DenseVector(new double[]{5.0, 6.0, 7.0});
        int[] nonZeroDims = v1.nonZeroDimensions();
        Assert.assertEquals((int)3, (int)nonZeroDims.length);
        Assert.assertEquals((int)0, (int)nonZeroDims[0]);
        Assert.assertEquals((int)1, (int)nonZeroDims[1]);
        Assert.assertEquals((int)2, (int)nonZeroDims[2]);
        v2.increment(2.0, v1);
        Assert.assertEquals((double)7.0, (double)v2.value(0), (double)1.0E-5);
        Assert.assertEquals((double)10.0, (double)v2.value(1), (double)1.0E-5);
        Assert.assertEquals((double)13.0, (double)v2.value(2), (double)1.0E-5);
        DenseVector v3 = new DenseVector(new double[]{1.0, 2.0, 3.0});
        SparseFloatVector v4 = new SparseFloatVector(new int[]{0, 2}, new float[]{5.0f, 6.0f}, 3);
        v3.increment(2.0, v4);
        Assert.assertEquals((double)11.0, (double)v3.value(0), (double)1.0E-4);
        Assert.assertEquals((double)2.0, (double)v3.value(1), (double)1.0E-4);
        Assert.assertEquals((double)15.0, (double)v3.value(2), (double)1.0E-4);
    }

    @Test
    public void testVectorOps() {
        DenseVector v1 = new DenseVector(new double[]{1.0, 1.0, 0.0});
        DenseVector v2 = new DenseVector(new double[]{1.0, 0.0, 1.0});
        Assert.assertEquals((double)Math.sqrt(2.0), (double)v1.length(), (double)1.0E-4);
        Assert.assertEquals((double)Math.sqrt(2.0), (double)v2.length(), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)v1.dotProduct(v2), (double)1.0E-4);
        Assert.assertEquals((double)1.0, (double)v2.dotProduct(v1), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)v1.cosine(v2), (double)1.0E-4);
        Assert.assertEquals((double)0.5, (double)v2.cosine(v1), (double)1.0E-4);
        DenseVector v3 = new DenseVector(new double[]{3.0, 5.0});
        try {
            v1.dotProduct(v3);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            v3.dotProduct(v1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            v1.cosine(v3);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            v3.cosine(v1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }

    @Test
    public void testSized() {
        DenseVector v = new DenseVector(2);
        Assert.assertEquals((int)2, (int)v.numDimensions());
        Assert.assertEquals((double)0.0, (double)v.value(0), (double)0.001);
        v.setValue(0, 5.0);
        Assert.assertEquals((double)5.0, (double)v.value(0), (double)0.001);
        v.setValue(1, 2.0);
        Assert.assertEquals((double)2.0, (double)v.value(1), (double)1.0E-4);
    }

    @Test
    public void testHashCode() {
        DenseVector v = new DenseVector(new double[]{1.0, 2.0, 3.0});
        List<Double> list = Arrays.asList(1.0, 2.0, 3.0);
        Assert.assertEquals((int)list.hashCode(), (int)v.hashCode());
    }

    @Test
    public void testEquals() {
        DenseVector v1 = new DenseVector(new double[]{1.0, 3.0, 7.0, 12.0});
        DenseVector v2 = new DenseVector(4);
        v2.setValue(0, 1.0);
        v2.setValue(1, 3.0);
        v2.setValue(2, 7.0);
        v2.setValue(3, 12.0);
        Asserts.assertFullEquals(v1, v2);
    }

    @Test
    public void testAllocated() {
        DenseVector v = new DenseVector(new double[]{1.0, 2.0, 3.0});
        Assert.assertEquals((int)3, (int)v.numDimensions());
        Assert.assertEquals((double)2.0, (double)v.value(1), (double)1.0E-4);
        DenseVector v2 = new DenseVector(new double[]{1.0, 2.0, 3.0});
        Assert.assertEquals((int)3, (int)v2.numDimensions());
        Assert.assertEquals((double)2.0, (double)v2.value(1), (double)1.0E-4);
        DenseVector v3 = new DenseVector(2);
        Assert.assertEquals((int)2, (int)v3.numDimensions());
        Assert.assertEquals((double)0.0, (double)v3.value(1), (double)1.0E-4);
    }

    @Test
    public void testConstructorExs() {
        try {
            new DenseVector(new double[0]);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
        try {
            new DenseVector(0);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Assert.assertTrue((boolean)true);
        }
    }
}

