/*
 * Decompiled with CFR 0.152.
 */
package com.aliasi.test.unit.matrix;

import com.aliasi.matrix.ProximityMatrix;
import com.aliasi.test.unit.Asserts;
import junit.framework.Assert;
import org.junit.Test;

public class ProximityMatrixTest {
    @Test
    public void testOne() {
        int j;
        int i;
        ProximityMatrix matrix = new ProximityMatrix(10);
        for (i = 0; i < 10; ++i) {
            for (j = i + 1; j < 10; ++j) {
                matrix.setValue(i, j, i * j);
            }
        }
        for (i = 0; i < 10; ++i) {
            for (j = 0; j < 10; ++j) {
                if (i == j) {
                    Assert.assertEquals((double)0.0, (double)matrix.value(i, j), (double)1.0E-4);
                    continue;
                }
                Assert.assertEquals((double)(i * j), (double)matrix.value(i, j), (double)1.0E-4);
            }
        }
    }

    @Test
    public void testExs() {
        try {
            new ProximityMatrix(-1);
            Assert.fail();
        }
        catch (IllegalArgumentException e) {
            Asserts.succeed();
        }
        try {
            new ProximityMatrix(7).value(7, 3);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            Asserts.succeed();
        }
        try {
            new ProximityMatrix(7).value(3, 7);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            Asserts.succeed();
        }
        try {
            new ProximityMatrix(7).value(3, -1);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            Asserts.succeed();
        }
        try {
            new ProximityMatrix(7).value(-1, 3);
            Assert.fail();
        }
        catch (IndexOutOfBoundsException e) {
            Asserts.succeed();
        }
    }
}

